/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.DockerCredentialsHolder;
import com.intellij.remote.PathMappingProvider;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkConnectionAcceptor;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublishConfigMappingProvider
extends PathMappingProvider {
    @NotNull
    public String getProviderPresentableName(@NotNull RemoteSdkAdditionalData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider", "getProviderPresentableName"));
        }
        final Ref name = new Ref();
        data.switchOnConnectionType(new RemoteSdkConnectionAcceptor(){

            public void ssh(@NotNull RemoteCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider$1", "ssh"));
                }
                name.set((Object)"SFTP Deployment configurations");
            }

            public void vagrant(@NotNull VagrantBasedCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider$1", "vagrant"));
                }
            }

            public void deployment(@NotNull WebDeploymentCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider$1", "deployment"));
                }
                name.set((Object)("'" + cred.getWebServerConfigName() + "' Deployment configuration"));
            }

            public void docker(@NotNull DockerCredentialsHolder credentials) {
                if (credentials == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider$1", "docker"));
                }
            }
        });
        String string = (String)name.get();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider", "getProviderPresentableName"));
        }
        return string;
    }

    public boolean accepts(@Nullable RemoteSdkAdditionalData data) {
        return data != null && (data.getRemoteConnectionType() == CredentialsType.WEB_DEPLOYMENT || data.getRemoteConnectionType() == CredentialsType.SSH_HOST);
    }

    @NotNull
    public PathMappingSettings getPathMappingSettings(final @NotNull Project project, final @NotNull RemoteSdkAdditionalData data) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider", "getPathMappingSettings"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider", "getPathMappingSettings"));
        }
        final PathMappingSettings mappingSettings = new PathMappingSettings();
        data.switchOnConnectionType(new RemoteSdkConnectionAcceptor(){

            public void ssh(@NotNull RemoteCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider$2", "ssh"));
                }
                try {
                    RemoteSdkCredentials credentials = data.getRemoteSdkCredentials(false);
                    mappingSettings.addAll(PublishConfigMappingProvider.getPathMappingsForDeploymentConfigurations(project, (RemoteCredentials)credentials));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            public void vagrant(@NotNull VagrantBasedCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider$2", "vagrant"));
                }
            }

            public void deployment(@NotNull WebDeploymentCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider$2", "deployment"));
                }
                PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
                for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList()) {
                    if (!cred.getWebServerConfigId().equals(webConfig.getId())) continue;
                    PublishConfigMappingProvider.addMappings(webConfig, publishConfig, mappingSettings);
                }
            }

            public void docker(@NotNull DockerCredentialsHolder credentials) {
                if (credentials == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider$2", "docker"));
                }
            }
        });
        PathMappingSettings pathMappingSettings = mappingSettings;
        if (pathMappingSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/PublishConfigMappingProvider", "getPathMappingSettings"));
        }
        return pathMappingSettings;
    }

    private static void addMappings(WebServerConfig webConfig, PublishConfig publishConfig, PathMappingSettings mappingSettings) {
        List mappings = publishConfig.getPathMappings(webConfig.getId());
        for (DeploymentPathMapping mapping : mappings) {
            String rootFolder = webConfig.getFileTransferConfig().getRootFolder();
            if ((rootFolder = rootFolder.replaceAll("\\\\", "/").trim()).endsWith("/")) {
                rootFolder = rootFolder.substring(0, rootFolder.length() - 1);
            }
            if (StringUtil.isEmpty((String)mapping.getLocalPath()) || StringUtil.isEmpty((String)mapping.getDeployPath())) continue;
            mappingSettings.addMapping(mapping.getLocalPath(), rootFolder + mapping.getDeployPath());
        }
    }

    private static PathMappingSettings getPathMappingsForDeploymentConfigurations(Project project, RemoteCredentials data) {
        PathMappingSettings mappingSettings = new PathMappingSettings();
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
        for (WebServerConfig webConfig : RemoteSdkUtil.getSftpServerList(project)) {
            if (!StringUtil.equals((CharSequence)PublishConfigMappingProvider.normalizeHost(webConfig.getFileTransferConfig().getHost()), (CharSequence)PublishConfigMappingProvider.normalizeHost(data.getHost()))) continue;
            PublishConfigMappingProvider.addMappings(webConfig, publishConfig, mappingSettings);
        }
        return mappingSettings;
    }

    @Nullable
    private static CharSequence normalizeHost(@Nullable String host) {
        if ("localhost".equals(host)) {
            return "127.0.0.1";
        }
        return host;
    }
}

