/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.JdkFutureAdapters;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.DockerCredentialsHolder;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentialException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkConnectionAcceptor;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.remote.VagrantSupport;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkCredentialsProducerImpl<T extends RemoteSdkCredentials>
implements RemoteSdkCredentialsProducer<T> {
    private static final Logger LOG = Logger.getInstance(RemoteSdkCredentialsProducer.class);
    private static final LoadingCache<VagrantBasedCredentialsHolder, RemoteCredentials> ourCachedVagrantCredentials = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS).refreshAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<VagrantBasedCredentialsHolder, RemoteCredentials>(){

        public RemoteCredentials load(@NotNull VagrantBasedCredentialsHolder cred) throws Exception {
            if (cred == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl$1", "load"));
            }
            return null;
        }

        public ListenableFuture<RemoteCredentials> reload(final @NotNull VagrantBasedCredentialsHolder cred, @NotNull RemoteCredentials oldValue) throws Exception {
            if (cred == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl$1", "reload"));
            }
            if (oldValue == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl$1", "reload"));
            }
            return JdkFutureAdapters.listenInPoolThread((Future)ApplicationManager.getApplication().executeOnPooledThread((Callable)new Callable<RemoteCredentials>(){

                @Override
                public RemoteCredentials call() throws Exception {
                    LOG.info("Updating credentials for " + cred);
                    return RemoteSdkCredentialsProducerImpl.getAndCheckVagrantRemoteCredentials(cred, false);
                }
            }));
        }
    });
    @NotNull
    private final Function<RemoteCredentials, T> myTransformer;
    @NotNull
    private final RemoteConnectionCredentialsWrapper myWrapper;
    private final boolean myUseCache;

    public RemoteSdkCredentialsProducerImpl(@NotNull Function<RemoteCredentials, T> transformer, @NotNull RemoteConnectionCredentialsWrapper wrapper) {
        if (transformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformer", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "<init>"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "<init>"));
        }
        this(transformer, wrapper, false);
    }

    public RemoteSdkCredentialsProducerImpl(@NotNull Function<RemoteCredentials, T> transformer, @NotNull RemoteConnectionCredentialsWrapper wrapper, boolean useCache) {
        if (transformer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transformer", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "<init>"));
        }
        if (wrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "<init>"));
        }
        this.myTransformer = transformer;
        this.myWrapper = wrapper;
        this.myUseCache = useCache;
    }

    public void produceRemoteSdkCredentials(final boolean allowSynchronousInteraction, final @NotNull Consumer<T> remoteSdkCredentialsConsumer) {
        if (remoteSdkCredentialsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteSdkCredentialsConsumer", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "produceRemoteSdkCredentials"));
        }
        this.myWrapper.switchType(new RemoteSdkConnectionAcceptor(){

            public void ssh(@NotNull RemoteCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl$2", "ssh"));
                }
                remoteSdkCredentialsConsumer.consume(RemoteSdkCredentialsProducerImpl.this.myTransformer.apply((Object)cred));
            }

            public void vagrant(@NotNull VagrantBasedCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl$2", "vagrant"));
                }
                RemoteCredentials credentials = null;
                if (RemoteSdkCredentialsProducerImpl.this.myUseCache && (credentials = (RemoteCredentials)ourCachedVagrantCredentials.getIfPresent((Object)cred)) != null) {
                    LOG.info("Credentials for " + cred + " found in cache.");
                }
                if (credentials == null) {
                    LOG.info("No cached credentials for " + cred);
                    credentials = RemoteSdkCredentialsProducerImpl.getAndCheckVagrantRemoteCredentials(cred, allowSynchronousInteraction);
                    if (RemoteSdkCredentialsProducerImpl.this.myUseCache) {
                        ourCachedVagrantCredentials.put((Object)cred, (Object)credentials);
                    }
                }
                remoteSdkCredentialsConsumer.consume(RemoteSdkCredentialsProducerImpl.this.myTransformer.apply((Object)credentials));
            }

            public void deployment(@NotNull WebDeploymentCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl$2", "deployment"));
                }
                RemoteCredentials sshCredentials = RemoteSdkCredentialsProducerImpl.getCredentialsBySftpServerId(cred.getWebServerConfigId());
                if (sshCredentials == null) {
                    throw new RemoteCredentialException("Can get remote credentials for deployment server " + cred.getWebServerConfigName());
                }
                remoteSdkCredentialsConsumer.consume(RemoteSdkCredentialsProducerImpl.this.myTransformer.apply((Object)sshCredentials));
            }

            public void docker(@NotNull DockerCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl$2", "docker"));
                }
                throw new UnsupportedOperationException("Docker SDK could not produce Remote SDK credentials");
            }
        });
    }

    @NotNull
    private static RemoteCredentials getAndCheckVagrantRemoteCredentials(@NotNull VagrantBasedCredentialsHolder cred, boolean allowSynchronousInteraction) {
        RemoteCredentials remoteCredentials;
        if (cred == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "getAndCheckVagrantRemoteCredentials"));
        }
        if (StringUtil.isEmpty((String)cred.getVagrantFolder())) {
            throw new IllegalStateException("Vagrant instance folder is not specified");
        }
        try {
            RemoteCredentials credentials = RemoteSdkCredentialsProducerImpl.getVagrantRemoteCredentials(cred);
            if (credentials == null) {
                throw new RemoteCredentialException("Cant obtain ssh credentials for Vagrant at " + cred.getVagrantFolder());
            }
            if (!RemoteSdkUtil.testConnection(null, null, credentials) && !RemoteSdkCredentialsProducerImpl.checkVagrantStatus(cred.getVagrantFolder(), cred.getMachineName(), allowSynchronousInteraction)) {
                throw new VagrantNotStartedException("Vagrant VM" + (cred.getMachineName() != null ? " '" + cred.getMachineName() + "'" : "") + " at " + cred.getVagrantFolder() + " is not launched", cred.getVagrantFolder(), cred.getMachineName());
            }
            remoteCredentials = credentials;
        }
        catch (IOException e) {
            throw new VagrantNotStartedException(e.getMessage(), cred.getVagrantFolder(), cred.getMachineName());
        }
        if (remoteCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "getAndCheckVagrantRemoteCredentials"));
        }
        return remoteCredentials;
    }

    public void produceRemoteSdkCredentials(@NotNull Consumer<T> remoteSdkCredentialsConsumer) {
        if (remoteSdkCredentialsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remoteSdkCredentialsConsumer", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "produceRemoteSdkCredentials"));
        }
        this.produceRemoteSdkCredentials(true, remoteSdkCredentialsConsumer);
    }

    @Deprecated
    public T getRemoteSdkCredentials() throws InterruptedException {
        try {
            return this.getRemoteSdkCredentials(true);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public T getRemoteSdkCredentials(boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        MyRemoteCredentialsConsumer c = new MyRemoteCredentialsConsumer();
        try {
            this.produceRemoteSdkCredentials(allowSynchronousInteraction, c);
        }
        catch (RuntimeException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        c.await();
        return (T)c.myRemoteSdkCredentials;
    }

    public Object getRemoteSdkDataKey() {
        return this.myWrapper.getConnectionKey();
    }

    @Nullable
    private static RemoteCredentials getVagrantRemoteCredentials(@NotNull VagrantBasedCredentialsHolder data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "getVagrantRemoteCredentials"));
        }
        VagrantSupport vs = VagrantSupport.getInstance();
        if (vs != null) {
            return vs.getCredentials(data.getVagrantFolder(), data.getMachineName());
        }
        VagrantSupport.showMissingVagrantSupportMessage(null);
        return null;
    }

    private static boolean checkVagrantStatus(@NotNull String vagrantFolder, @Nullable String machineName, boolean askToRunIfDown) {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "checkVagrantStatus"));
        }
        VagrantSupport vs = VagrantSupport.getInstance();
        if (vs != null) {
            return vs.checkVagrantRunning(vagrantFolder, machineName, askToRunIfDown);
        }
        throw new IllegalStateException("Vagrant Support unavailable");
    }

    @Nullable
    private static RemoteCredentials getCredentialsBySftpServerId(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl", "getCredentialsBySftpServerId"));
        }
        for (WebServerConfig conf : RemoteSdkUtil.getSftpServerList()) {
            if (!id.equals(conf.getId())) continue;
            return conf.getFileTransferConfig().getCredentials();
        }
        return null;
    }

    private class MyRemoteCredentialsConsumer
    implements Consumer<T> {
        private final CountDownLatch myLatch = new CountDownLatch(1);
        private T myRemoteSdkCredentials;

        private MyRemoteCredentialsConsumer() {
        }

        public void consume(T data) {
            this.myRemoteSdkCredentials = data;
            this.myLatch.countDown();
        }

        public void await() throws InterruptedException {
            this.myLatch.await();
        }
    }
}

