/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ide.DataManager;
import com.intellij.ide.passwordSafe.ui.PasswordSafePromptDialog;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.BaseRemoteProcessHandler;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteFile;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jetbrains.plugins.remotesdk.ConnectionOwnerFactory;
import com.jetbrains.plugins.remotesdk.RemoteTransfer;
import com.jetbrains.plugins.remotesdk.transport.JschExecProcess;
import com.jetbrains.plugins.remotesdk.transport.JschProcess;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import com.jetbrains.plugins.remotesdk.transport.SshUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.ui.ServerBrowserDialog;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.awt.Component;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JTextField;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkUtil {
    private static final Logger LOG = Logger.getInstance(RemoteSdkUtil.class);
    @NonNls
    private static final String JETBRAINS_REMOTE_RUN = "JETBRAINS_REMOTE_RUN";
    public static final long TEST_CONNECTION_POLL_TIMEOUT = 100L;
    private static final int MAX_CREATE_DIR_ATTEMPTS = 5;
    public static final long TEST_CONNECTION_TIMEOUT = 10L;
    public static final String DEFAULT_PYCHARM_HELPERS_PATH_ON_DOCKER = "/opt/.pycharm_helpers";

    private RemoteSdkUtil() {
    }

    @NotNull
    public static FileTransferConfig createFromRemoteCredentials(@NotNull RemoteCredentials data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createFromRemoteCredentials"));
        }
        FileTransferConfig config = new FileTransferConfig();
        config.setAccessType(AccessType.SFTP);
        config.setHost(data.getHost());
        config.setPort(data.getPort());
        config.setAnonymous(data.isAnonymous());
        config.setUserName(data.getUserName());
        config.setUseKeyPair(data.isUseKeyPair());
        if (data.isUseKeyPair()) {
            config.setPassword(null, false);
            config.setStorePassword(false);
            config.setPassphrase(data.getPassphrase(), false);
            config.setStorePassphrase(data.isStorePassphrase());
            config.setPrivateKeyFile(data.getPrivateKeyFile());
        } else {
            config.setPassword(data.getPassword(), false);
            config.setStorePassword(data.isStorePassword());
            config.setPassphrase(null, false);
            config.setStorePassphrase(false);
            config.setPrivateKeyFile(null);
        }
        config.setPrivateKeyFile(data.getPrivateKeyFile());
        config.setKnownHostsFile(data.getKnownHostsFile());
        config.setPassphrase(data.getPassphrase(), false);
        config.setStorePassphrase(data.isStorePassphrase());
        FileTransferConfig fileTransferConfig = config;
        if (fileTransferConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createFromRemoteCredentials"));
        }
        return fileTransferConfig;
    }

    public static void initRemoteSdkData(@NotNull RemoteSdkCredentials data, @NotNull FileTransferConfig config) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "initRemoteSdkData"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "initRemoteSdkData"));
        }
        data.setHost(config.getHost());
        data.setPort(config.getPort());
        data.setAnonymous(config.isAnonymous());
        data.setUserName(config.getUserName());
        data.setPassword(config.getPassword());
        data.setPrivateKeyFile(config.getPrivateKeyFile());
        data.setKnownHostsFile(config.getKnownHostsFile());
        data.setPassphrase(config.getPassphrase());
        data.setUseKeyPair(config.isUseKeyPair());
        data.setStorePassword(config.getPasswordState() == FileTransferConfig.PasswordState.Store);
        data.setStorePassphrase(config.getPassphraseState() == FileTransferConfig.PasswordState.Store);
    }

    @NotNull
    public static List<WebServerConfig> getSftpServerList() {
        List<WebServerConfig> list = RemoteSdkUtil.getSftpServerList(null);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "getSftpServerList"));
        }
        return list;
    }

    @NotNull
    public static List<WebServerConfig> getSftpServerList(@Nullable Project project) {
        List config = WebServersConfigManager.getInstance((Project)project).getServers(true);
        Predicate<WebServerConfig> filter = new Predicate<WebServerConfig>(){

            public boolean apply(WebServerConfig input) {
                return input.getFileTransferConfig().getAccessType() == AccessType.SFTP;
            }
        };
        ArrayList arrayList = Lists.newArrayList((Iterable)Iterables.filter((Iterable)config, (Predicate)filter));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "getSftpServerList"));
        }
        return arrayList;
    }

    public static boolean checkRemoteConnection(@Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials data) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "checkRemoteConnection"));
        }
        boolean result = false;
        while (RemoteSdkUtil.ensureAuthSpecified(component, data)) {
            try {
                result = RemoteSdkUtil.testConnectionAndCreateHelpersPath(project, component, data, "Connecting to remote host");
                if (!result) continue;
                break;
            }
            catch (FileSystemException e) {
                if ("Auth fail".equals(e.getMessage())) {
                    RemoteSdkUtil.setPasswordOrPhrase(data, null);
                    continue;
                }
                throw new RemoteSdkException(e.getMessage(), (Throwable)e);
            }
        }
        if (!result) {
            throw new RemoteSdkException("Can't connect to remote host.");
        }
        return true;
    }

    public static boolean ensureAuthSpecified(@Nullable Component component, @NotNull RemoteSdkCredentials data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "ensureAuthSpecified"));
        }
        FileTransferConfig fileTransferConfig = RemoteSdkUtil.createFromRemoteCredentials((RemoteCredentials)data);
        WebServerConfig config = new WebServerConfig(data.getFullInterpreterPath());
        config.setFileTransferConfig(fileTransferConfig);
        config.setName(config.getId());
        boolean result = component == null ? AuthHelper.ensureAuthSpecified((WebServerConfig)config, (Project)null) : AuthHelper.ensureAuthSpecified(null, (WebServerConfig)config, (Component)component);
        if (result) {
            data.setUserName(fileTransferConfig.getUserName());
            if (data.isUseKeyPair()) {
                data.setPassphrase(fileTransferConfig.getPassphrase());
            } else {
                data.setPassword(fileTransferConfig.getPassword());
            }
        }
        return result;
    }

    public static void setPasswordOrPhrase(@NotNull RemoteSdkCredentials data, @Nullable String passWordOrPhrase) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "setPasswordOrPhrase"));
        }
        if (data.isUseKeyPair()) {
            data.setPassphrase(passWordOrPhrase);
        } else {
            data.setPassword(passWordOrPhrase);
        }
    }

    public static boolean testConnectionAndCreateHelpersPath(@Nullable Project project, @Nullable Component component, @NotNull RemoteSdkCredentials data, String title) throws RemoteCancelledException, FileSystemException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnectionAndCreateHelpersPath"));
        }
        return RemoteSdkUtil.testConnectionAndCreateHelpersPath(project, component, data, title, null);
    }

    public static boolean testConnection(@Nullable Project project, @Nullable Component component, @NotNull RemoteCredentials data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnection"));
        }
        if (EdtInvocationManager.getInstance().isEventDispatchThread()) {
            return RemoteSdkUtil.testConnectionFromEDT(project, component, data);
        }
        return RemoteSdkUtil.testConnectionFromNonEDT(project, component, data);
    }

    private static boolean testConnectionFromEDT(@Nullable Project project, @Nullable Component component, @NotNull RemoteCredentials data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnectionFromEDT"));
        }
        try {
            return RemoteSdkUtil.doTestConnection(project, component, data, 10L, TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private static boolean testConnectionFromNonEDT(final @Nullable Project project, final @Nullable Component component, final @NotNull RemoteCredentials data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnectionFromNonEDT"));
        }
        Future result = ApplicationManager.getApplication().executeOnPooledThread((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return RemoteSdkUtil.doTestConnection(project, component, data, 10L, TimeUnit.SECONDS);
            }
        });
        try {
            return (Boolean)result.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn((Throwable)e);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
        }
        catch (TimeoutException e) {
            LOG.warn((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static boolean doTestConnection(@Nullable Project project, @Nullable Component component, @NotNull RemoteCredentials data, long timeout, @NotNull TimeUnit timeUnit) {
        void timeUnit2;
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "doTestConnection"));
        }
        if (timeUnit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeUnit", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "doTestConnection"));
        }
        SshRemoteSession session = new SshRemoteSession(ConnectionOwnerFactory.createConnectionOwner(project, component), data, null, timeout, (TimeUnit)timeUnit2);
        try {
            boolean bl = session.isConnected();
            session.disconnect();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                session.disconnect();
                throw throwable;
            }
            catch (JSchException jSchException) {
                return false;
            }
        }
    }

    public static boolean testConnectionAndCreateHelpersPath(final @Nullable Project project, final @Nullable Component component, final @NotNull RemoteSdkCredentials data, String title, final @Nullable RemoteSdkUpdatedCallback updatedCallback) throws FileSystemException, RemoteCancelledException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnectionAndCreateHelpersPath"));
        }
        final Ref error = new Ref();
        final Ref result = new Ref();
        result.set((Object)false);
        final Task.Modal task = new Task.Modal(project, title, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(final @NotNull ProgressIndicator pi) {
                if (pi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$3", "run"));
                }
                final Semaphore done = new Semaphore();
                done.down();
                EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(RemoteConnectionManager.ForceDisconnectListener.class);
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            pi.setText("Connecting to " + data.getHost() + "...");
                            RemoteSdkUtil.createSessionAndCheckSdk(ConnectionOwnerFactory.createConnectionOwner(project, component), data, (Ref<Exception>)error, (Ref<Boolean>)result, pi, updatedCallback);
                        }
                        catch (JSchException e) {
                            error.set((Object)new CustomFileSystemException(e.getMessage(), (Throwable)e));
                        }
                        finally {
                            done.up();
                        }
                    }
                });
                try {
                    while (!done.waitFor(100L)) {
                        pi.checkCanceled();
                    }
                }
                finally {
                    ((RemoteConnectionManager.ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
                }
            }

            public void onCancel() {
                error.set((Object)new RemoteCancelledException("Connection was canceled."));
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().run((Task)task);
                }
            });
        } else {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (!error.isNull()) {
            Exception exception = (Exception)error.get();
            if (exception instanceof RemoteCancelledException) {
                throw (RemoteCancelledException)exception;
            }
            if (exception instanceof FileSystemException) {
                throw (FileSystemException)((Object)exception);
            }
            throw new FileSystemException("Exception:", (Throwable)exception);
        }
        return (Boolean)result.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createSessionAndCheckSdk(@NotNull ConnectionOwner connectionOwner, @NotNull RemoteSdkCredentials data, @NotNull Ref<Exception> error, @NotNull Ref<Boolean> result, @Nullable ProgressIndicator pi, @Nullable RemoteSdkUpdatedCallback updateCallback) throws JSchException {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createSessionAndCheckSdk"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createSessionAndCheckSdk"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createSessionAndCheckSdk"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createSessionAndCheckSdk"));
        }
        SshRemoteSession session = new SshRemoteSession(connectionOwner, (RemoteCredentials)data, pi);
        try {
            if (!RemoteSdkUtil.checkInterpreterAndCreateHelpersFolder(data, error, result, updateCallback, session)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            session.disconnect();
        }
        return true;
    }

    public static boolean checkInterpreterAndCreateHelpersFolder(@NotNull RemoteSdkCredentials sdkCredentials, @NotNull Ref<Exception> error, @NotNull Ref<Boolean> result, @Nullable RemoteSdkUpdatedCallback updateCallback, SshRemoteSession session) {
        if (sdkCredentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkCredentials", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "checkInterpreterAndCreateHelpersFolder"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "checkInterpreterAndCreateHelpersFolder"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "checkInterpreterAndCreateHelpersFolder"));
        }
        try {
            ChannelSftp channel = session.sftp();
            String interpreterPath = sdkCredentials.getInterpreterPath();
            String pathForHelpers = sdkCredentials.getHelpersPath();
            if (updateCallback != null) {
                SftpATTRS attrs = SshUtil.getAttrs(channel, interpreterPath);
                if (attrs == null || attrs.isDir()) {
                    error.set((Object)new CustomFileSystemException("Interpreter '" + interpreterPath + "' doesn't exist on remote server"));
                    return false;
                }
                if (!StringUtil.isEmpty((String)pathForHelpers)) {
                    attrs = SshUtil.getAttrs(channel, pathForHelpers);
                    if (attrs == null || !attrs.isDir()) {
                        error.set((Object)new CustomFileSystemException("Folder '" + pathForHelpers + "' doesn't exist on remote server"));
                        return false;
                    }
                } else {
                    String path = new RemoteFile(channel.getHome(), sdkCredentials.getDefaultHelpersName()).getPath();
                    sdkCredentials.setHelpersPath(path);
                    attrs = SshUtil.getAttrs(channel, path);
                    int i = 0;
                    while (attrs == null || !attrs.isDir()) {
                        try {
                            channel.mkdir(path);
                            sdkCredentials.setHelpersPath(path);
                            break;
                        }
                        catch (Exception e) {
                            path = sdkCredentials.getHelpersPath() + "_" + ++i;
                            if (i <= 5) continue;
                            throw e;
                        }
                    }
                    updateCallback.updated(sdkCredentials);
                }
            }
            result.set((Object)true);
            return true;
        }
        catch (Exception e) {
            error.set((Object)new CustomFileSystemException(e.getMessage(), (Throwable)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean ensureCanWriteFile(@NotNull ConnectionOwner connectionOwner, @NotNull RemoteSdkCredentials data, @NotNull String path) {
        Session session;
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "ensureCanWriteFile"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "ensureCanWriteFile"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "ensureCanWriteFile"));
        }
        try {
            session = SshUtil.connectJSch((RemoteCredentials)data, connectionOwner, null, 60L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            return true;
        }
        try {
            ChannelSftp channel = SshUtil.createSftpChannel(session);
            SftpATTRS attrs = SshUtil.getAttrs(channel, path);
            boolean bl = attrs != null && (attrs.getPermissions() & 0x80) != 0 && attrs.getUId() != 0;
            return bl;
        }
        catch (Exception e) {
            boolean bl = true;
            return bl;
        }
        finally {
            session.disconnect();
        }
    }

    @Deprecated
    @NotNull
    public static JschProcess createRemoteProcess(@NotNull SshRemoteSession runProcessSession, @NotNull RemoteSdkCredentials data, @NotNull GeneralCommandLine commandLine, boolean allocatePty, boolean askForSudo, boolean changeDir) throws RemoteSdkException {
        if (runProcessSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProcessSession", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteProcess"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteProcess"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteProcess"));
        }
        JschProcess jschProcess = RemoteSdkUtil.createRemoteProcess(runProcessSession, commandLine, allocatePty, askForSudo, changeDir);
        if (jschProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteProcess"));
        }
        return jschProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static JschProcess createRemoteProcess(final @NotNull SshRemoteSession runProcessSession, @NotNull GeneralCommandLine commandLine, boolean allocatePty, boolean askForSudo, boolean changeDir) throws RemoteSdkException {
        JschExecProcess jschExecProcess;
        if (runProcessSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runProcessSession", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteProcess"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteProcess"));
        }
        try {
            commandLine.getEnvironment().put(JETBRAINS_REMOTE_RUN, "1");
            String command = commandLine.getCommandLineString();
            if (!RemoteFile.isWindowsPath((String)commandLine.getExePath())) {
                command = RemoteSdkUtil.addEnvCommand(commandLine, command);
                if (askForSudo) {
                    command = "sudo -S -p '' " + command;
                }
            }
            if (changeDir && commandLine.getWorkDirectory() != null) {
                String workingDir = commandLine.getWorkDirectory().getPath();
                workingDir = RemoteFile.detectSystemByPath((String)commandLine.getExePath()).createRemoteFile(workingDir).getPath();
                command = "cd " + workingDir + "; " + command;
            }
            JschExecProcess process = runProcessSession.exec(command, 60, allocatePty);
            if (askForSudo) {
                final Ref sudoPassword = Ref.create(null);
                UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String password = PasswordSafePromptDialog.askPassword((String)"Enter Root Password", (String)("Sudo password required for host: " + runProcessSession.getHost()), BaseRemoteProcessHandler.class, (String)runProcessSession.getCredentialsString(), (boolean)false);
                        sudoPassword.set((Object)password);
                    }
                });
                if (sudoPassword.get() != null) {
                    PrintWriter pw = new PrintWriter(process.getOutputStream());
                    try {
                        pw.println((String)sudoPassword.get());
                    }
                    finally {
                        pw.close();
                    }
                } else {
                    throw new RemoteCancelledException("Sudo password dialog cancelled.");
                }
            }
            jschExecProcess = process;
        }
        catch (Exception e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
        if (jschExecProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteProcess"));
        }
        return jschExecProcess;
    }

    private static String addEnvCommand(GeneralCommandLine commandLine, String command) {
        StringBuilder params = new StringBuilder();
        for (Map.Entry entry : commandLine.getEnvironment().entrySet()) {
            String value;
            if (params.length() > 0) {
                params.append(" ");
            }
            if ((value = (String)entry.getValue()) == null) continue;
            String key = RemoteSdkUtil.escapeEnvParameter((String)entry.getKey());
            value = RemoteSdkUtil.escapeEnvParameter(value);
            if (commandLine.isPassParentEnvironment() && "PATH".equalsIgnoreCase(key)) {
                value = value + ":$PATH";
            }
            params.append("\"").append(key).append("\"").append("=").append("\"").append(value).append("\"");
        }
        if (params.length() > 0) {
            String env = "env ";
            if (!commandLine.isPassParentEnvironment()) {
                env = env + "-i ";
            }
            command = env + params.toString() + " " + command;
        }
        return command;
    }

    private static String escapeEnvParameter(String value) {
        return value.replace("\"", "\\\"").replace("$", "\\$");
    }

    public static SshRemoteSession createRemoteSession(@Nullable Project project, @NotNull RemoteCredentials data) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "createRemoteSession"));
        }
        try {
            return new SshRemoteSession(project, data);
        }
        catch (JSchException e) {
            throw new RemoteSdkException(e.getMessage(), (Throwable)e);
        }
    }

    public static WebServerConfig createWebServer(RemoteCredentials data) {
        WebServerConfig config = new WebServerConfig();
        config.setName("Remote host");
        config.setFileTransferConfig(RemoteSdkUtil.createFromRemoteCredentials(data));
        return config;
    }

    public static boolean testConnection(@NotNull Component component, RemoteSdkCredentials data, boolean reportOnSuccess) {
        String error;
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnection"));
        }
        WebServerConfig config = RemoteSdkUtil.createWebServer((RemoteCredentials)data);
        String title = WDBundle.message((String)"test.connection", (Object[])new Object[]{config.getFileTransferConfig().getAccessType().getTitle()});
        String validationInfo = config.getFileTransferConfig().validateFast();
        if (validationInfo != null) {
            error = validationInfo;
        } else {
            try {
                error = RemoteSdkUtil.testConnectionAndCreateHelpersPath(null, component, data, title) ? null : "Connection failed";
            }
            catch (FileSystemException e) {
                error = StringUtil.capitalize((String)PublishUtils.getMessage((Throwable)e, (boolean)false));
            }
            catch (RemoteCancelledException e) {
                error = "Connection was cancelled";
            }
        }
        if (error == null) {
            if (reportOnSuccess) {
                Messages.showInfoMessage((Component)component, (String)WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{data.getHost()}), (String)title);
            }
            return true;
        }
        Messages.showErrorDialog((Component)component, (String)WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{data.getHost(), error}), (String)title);
        return false;
    }

    public static boolean testConnection(final @NotNull Component component, final RemoteCredentials data, boolean reportOnSuccess) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "testConnection"));
        }
        WebServerConfig config = RemoteSdkUtil.createWebServer(data);
        final String title = WDBundle.message((String)"test.connection", (Object[])new Object[]{config.getFileTransferConfig().getAccessType().getTitle()});
        String validationInfo = config.getFileTransferConfig().validateFast();
        Object error = validationInfo != null ? validationInfo : (RemoteSdkUtil.testConnection(null, component, data) ? null : "Connection failed");
        if (error == null) {
            if (reportOnSuccess) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Messages.showInfoMessage((Component)component, (String)WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{data.getHost()}), (String)title);
                    }
                });
            }
            return true;
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable((String)error, title){
            final /* synthetic */ String val$error;
            final /* synthetic */ String val$title;
            {
                this.val$error = string;
                this.val$title = string2;
            }

            @Override
            public void run() {
                Messages.showErrorDialog((Component)component, (String)WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{data.getHost(), this.val$error}), (String)this.val$title);
            }
        });
        return false;
    }

    public static ServerBrowserDialog showBrowseRemoteDialog(@NotNull String title, @NotNull JTextField field, boolean foldersOnly, @NotNull WebServerConfig serverConfig) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "showBrowseRemoteDialog"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "showBrowseRemoteDialog"));
        }
        if (serverConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "showBrowseRemoteDialog"));
        }
        WebServerConfig.RemotePath initialPath = new WebServerConfig.RemotePath(field.getText());
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)field));
        ServerBrowserDialog d = project != null ? new ServerBrowserDialog(project, serverConfig, title, foldersOnly, FileTransferConfig.Origin.ForceRoot, initialPath) : new ServerBrowserDialog((Component)field, serverConfig, title, foldersOnly, FileTransferConfig.Origin.ForceRoot, initialPath);
        d.show();
        return d;
    }

    @NotNull
    public static RemoteTransfer.HelpersTransferConfig newHelpersTransferConfigFromRemoteCredentials(final @NotNull RemoteSdkCredentials myRemoteSdkCredentials) {
        if (myRemoteSdkCredentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "myRemoteSdkCredentials", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "newHelpersTransferConfigFromRemoteCredentials"));
        }
        RemoteTransfer.HelpersTransferConfig helpersTransferConfig = new RemoteTransfer.HelpersTransferConfig(){

            @Override
            @NotNull
            public String getHelpersPath() {
                String string = myRemoteSdkCredentials.getHelpersPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$8", "getHelpersPath"));
                }
                return string;
            }

            @Override
            @NotNull
            public final FileTransferConfig createFileTransferConfig() {
                FileTransferConfig fileTransferConfig = RemoteSdkUtil.createFromRemoteCredentials((RemoteCredentials)myRemoteSdkCredentials);
                if (fileTransferConfig == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil$8", "createFileTransferConfig"));
                }
                return fileTransferConfig;
            }

            @Override
            public boolean isHelpersVersionChecked() {
                return myRemoteSdkCredentials.isHelpersVersionChecked();
            }

            @Override
            public void setHelpersVersionChecked(boolean checked) {
                myRemoteSdkCredentials.setHelpersVersionChecked(checked);
            }
        };
        if (helpersTransferConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/RemoteSdkUtil", "newHelpersTransferConfigFromRemoteCredentials"));
        }
        return helpersTransferConfig;
    }

    public static interface RemoteSdkUpdatedCallback {
        public void updated(RemoteSdkCredentials var1);
    }
}

