/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.remote.RemoteCancelledException;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionManager;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkSessionManager {
    public static SshRemoteSession checkConnectionAndGetSession(final @Nullable Project project, final @NotNull RemoteSdkCredentials data) throws RemoteSdkException {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/SdkSessionManager", "checkConnectionAndGetSession"));
        }
        final Ref error = new Ref();
        final Ref result = new Ref();
        final Ref session = new Ref();
        result.set((Object)false);
        final Task.Modal task = new Task.Modal(project, "Connecting to " + data.getHost(), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(final @NotNull ProgressIndicator pi) {
                if (pi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/remotesdk/SdkSessionManager$1", "run"));
                }
                final Semaphore done = new Semaphore();
                done.down();
                EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(RemoteConnectionManager.ForceDisconnectListener.class);
                final SshConnectionManager connectionManager = SshConnectionManager.getInstance();
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            pi.setText("Connecting to " + data.getHost() + "...");
                            SshRemoteSession s = connectionManager.getSession(project, (RemoteCredentials)data);
                            if (RemoteSdkUtil.checkInterpreterAndCreateHelpersFolder(data, (Ref<Exception>)error, (Ref<Boolean>)result, null, s)) {
                                session.set((Object)s);
                            }
                        }
                        catch (Exception e) {
                            error.set((Object)new CustomFileSystemException(e.getMessage(), (Throwable)e));
                        }
                        finally {
                            done.up();
                        }
                    }
                });
                try {
                    while (!done.waitFor(100L)) {
                        pi.checkCanceled();
                    }
                }
                finally {
                    ((RemoteConnectionManager.ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
                }
            }

            public void onCancel() {
                error.set((Object)new RemoteCancelledException("Connection was canceled."));
            }
        };
        if (!ProgressManager.getInstance().hasProgressIndicator()) {
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ProgressManager.getInstance().run((Task)task);
                }
            });
        } else {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        }
        if (!error.isNull()) {
            Exception exception = (Exception)error.get();
            throw new RemoteSdkException("Error connecting to remote host:" + data.getHost(), (Throwable)exception);
        }
        if (session.isNull()) {
            throw new RemoteSdkException("Couldn't create remote session for " + data.getHost());
        }
        return (SshRemoteSession)session.get();
    }
}

