/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteConnector;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.SshConnectionProvider;
import com.jetbrains.plugins.remotesdk.console.RemoteConnectionSettingsForm;
import com.jetbrains.plugins.remotesdk.console.WebServerConnector;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class RemoteConnectionUtil {
    public static List<RemoteConnector> getUniqueRemoteConnectors(@Nullable Project project) {
        HashMap remoteConnectors = Maps.newHashMap();
        List<RemoteConnector> allRemoteConnectors = RemoteConnectionUtil.getAllRemoteConnectors(project);
        for (RemoteConnector connector : allRemoteConnectors) {
            remoteConnectors.put(connector.getConnectorKey(), connector);
        }
        ArrayList result = Lists.newArrayList();
        result.add(RemoteConnectionSettingsForm.NONE_CONNECTOR);
        result.addAll(remoteConnectors.values());
        return result;
    }

    public static List<RemoteConnector> getAllRemoteConnectors(@Nullable Project project) {
        ArrayList result = Lists.newArrayList();
        result.addAll(RemoteConnectionUtil.collectWebServers(project));
        result.addAll(RemoteConnectionUtil.collectAdditionalInterpreters());
        return result;
    }

    private static List<RemoteConnector> collectAdditionalInterpreters() {
        ArrayList result = Lists.newArrayList();
        for (SshConnectionProvider provider : (SshConnectionProvider[])SshConnectionProvider.EP_NAME.getExtensions()) {
            result.addAll(provider.collectRemoteConnectors());
        }
        return result;
    }

    private static Collection<? extends RemoteConnector> collectWebServers(@Nullable Project project) {
        ArrayList result = Lists.newArrayList();
        for (WebServerConfig config : RemoteSdkUtil.getSftpServerList(project)) {
            result.add(new WebServerConnector(config));
        }
        return result;
    }
}

