/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.transport.JschProcess;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class SshConsoleProcessHandler
extends ProcessHandler {
    private static final Logger LOG = Logger.getInstance(SshConsoleProcessHandler.class);
    protected final ProcessWaitFor myWaitFor;
    protected JschProcess myProcess;

    public SshConsoleProcessHandler(@NotNull JschProcess process) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/jetbrains/plugins/remotesdk/console/SshConsoleProcessHandler", "<init>"));
        }
        this.myProcess = process;
        this.myWaitFor = new ProcessWaitFor((Process)((Object)process));
    }

    public JschProcess getProcess() {
        return this.myProcess;
    }

    protected void destroyProcessImpl() {
        if (!this.myProcess.killProcessTree()) {
            this.baseDestroyProcessImpl();
        }
    }

    public void startNotify() {
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(ProcessEvent event) {
                try {
                    SshConsoleProcessHandler.this.myWaitFor.setTerminationCallback(new Consumer<Integer>(){

                        public void consume(Integer exitCode) {
                            try {
                                try {
                                    SshConsoleProcessHandler.this.myProcess.waitFor();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            finally {
                                SshConsoleProcessHandler.this.onOSProcessTerminated(exitCode);
                            }
                        }
                    });
                }
                finally {
                    SshConsoleProcessHandler.this.removeProcessListener((ProcessListener)this);
                }
            }
        });
        super.startNotify();
    }

    protected void onOSProcessTerminated(int exitCode) {
        this.notifyProcessTerminated(exitCode);
    }

    protected void baseDestroyProcessImpl() {
        try {
            this.closeStreams();
        }
        finally {
            this.doDestroyProcess();
        }
    }

    protected void doDestroyProcess() {
        this.getProcess().destroy();
    }

    protected void detachProcessImpl() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SshConsoleProcessHandler.this.closeStreams();
                SshConsoleProcessHandler.this.myWaitFor.detach();
                SshConsoleProcessHandler.this.notifyProcessDetached();
            }
        };
        SshConsoleProcessHandler.executeOnPooledThread(runnable);
    }

    protected void closeStreams() {
        try {
            this.myProcess.getOutputStream().close();
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean detachIsDefault() {
        return false;
    }

    public OutputStream getProcessInput() {
        return this.myProcess.getOutputStream();
    }

    protected static Future<?> executeOnPooledThread(Runnable task) {
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            return application.executeOnPooledThread(task);
        }
        return ExecutorServiceHolder.ourThreadExecutorsService.submit(task);
    }

    protected class ProcessWaitFor {
        private final Future<?> myWaitForThreadFuture;
        private final BlockingQueue<Consumer<Integer>> myTerminationCallback = new ArrayBlockingQueue<Consumer<Integer>>(1);

        public void detach() {
            this.myWaitForThreadFuture.cancel(true);
        }

        public ProcessWaitFor(final Process process) {
            this.myWaitForThreadFuture = SshConsoleProcessHandler.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    int exitCode = 0;
                    try {
                        while (true) {
                            try {
                                exitCode = process.waitFor();
                            }
                            catch (InterruptedException e) {
                                LOG.debug((Throwable)e);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        try {
                            ((Consumer)ProcessWaitFor.this.myTerminationCallback.take()).consume((Object)exitCode);
                        }
                        catch (InterruptedException e) {
                            LOG.info((Throwable)e);
                        }
                    }
                }
            });
        }

        public void setTerminationCallback(Consumer<Integer> r) {
            this.myTerminationCallback.offer(r);
        }
    }

    private static class ExecutorServiceHolder {
        private static final ExecutorService ourThreadExecutorsService = ExecutorServiceHolder.createServiceImpl();

        private ExecutorServiceHolder() {
        }

        private static ThreadPoolExecutor createServiceImpl() {
            return new ThreadPoolExecutor(10, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), ConcurrencyUtil.newNamedThreadFactory((String)"OSProcessHandler pooled thread"));
        }
    }
}

