/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.console;

import com.intellij.openapi.project.Project;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkException;
import com.jediterm.terminal.TtyConnector;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.console.JschProcessTtyConnector;
import com.jetbrains.plugins.remotesdk.console.SshConsoleProcessHandler;
import com.jetbrains.plugins.remotesdk.transport.JschShellProcess;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;

public class SshTerminalDirectRunner
extends AbstractTerminalRunner<JschShellProcess> {
    private final RemoteCredentials myCredentials;
    private final Charset myDefaultCharset;

    public SshTerminalDirectRunner(Project project, RemoteCredentials credentials, Charset charset) {
        super(project);
        this.myCredentials = credentials;
        this.myDefaultCharset = charset;
    }

    protected JschShellProcess createProcess(@Nullable String directory) throws ExecutionException {
        try {
            SshRemoteSession session = this.createSshSession(this.myCredentials);
            return session.shell();
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage(), e);
        }
    }

    protected SshRemoteSession createSshSession(RemoteCredentials credentials) throws RemoteSdkException {
        return RemoteSdkUtil.createRemoteSession(this.myProject, credentials);
    }

    protected SshConsoleProcessHandler createProcessHandler(JschShellProcess process) {
        return new SshConsoleProcessHandler(process);
    }

    protected TtyConnector createTtyConnector(JschShellProcess process) {
        return new JschProcessTtyConnector(process, this.myDefaultCharset);
    }

    public String runningTargetName() {
        return this.myCredentials.getHost() + ":" + this.myCredentials.getPort();
    }

    protected String getTerminalConnectionName(JschShellProcess process) {
        return process.getSession().toString();
    }
}

