/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.ui;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.DockerCredentialsHolder;
import com.intellij.remote.DockerSupport;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.PathMappingValidator;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkConnectionAcceptor;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantSupport;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.labels.ActionLink;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.AsyncProducer;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkDialog;
import com.jetbrains.plugins.remotesdk.ui.RemoteBrowseActionListener;
import com.jetbrains.plugins.remotesdk.ui.RemoteCredentialsEditor;
import com.jetbrains.plugins.remotesdk.ui.RemoteSdkEditorContainer;
import com.jetbrains.plugins.remotesdk.ui.StatusPanel;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.ErrorMessageAndField;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.RemoteCredentialsVerifiableHolder;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateRemoteSdkForm<T extends RemoteSdkAdditionalData>
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkForm");
    public static final String DEFAULT_DOCKER_PROJECT_PATH = "/opt/project";
    private static final String DEFAULT_DOCKER_IMAGE_NAME = "python:3";
    private JPanel myMainPanel;
    private JBLabel myInterpreterPathLabel;
    protected TextFieldWithBrowseButton myInterpreterPathField;
    protected TextFieldWithBrowseButton myHelpersPathField;
    private JTextField myNameField;
    private JBLabel myNameLabel;
    private JBLabel myHelpersPathLabel;
    protected RemoteCredentialsEditor myCredentialsForm;
    private JBRadioButton myPlainSshRadio;
    private JBRadioButton myVagrantRadio;
    private JBRadioButton myDeploymentRadio;
    private TextFieldWithBrowseButton myVagrantInstanceTextField;
    private JLabel myVagrantHostUrl;
    private JPanel myVagrantCredentialsPanel;
    private JPanel mySshCredentialsPanel;
    private JPanel myDeploymentPanel;
    private JLabel myDeploymentUrl;
    private ComboBox myDeploymentConfigurationsCombo;
    private JLabel myDeploymentHostLabel;
    private JPanel myHostHolder;
    private JPanel myStatusPanelHolder;
    private final StatusPanel myStatusPanel;
    private JLabel myVagrantInstanceLabel;
    private JLabel myDeploymentConfigurationLabel;
    private ComboBox myMachineNameCombo;
    private JLabel myMachineNameLabel;
    private JBLabel myPathMappingsInfoLabel;
    private JPanel myDeploymentProjectLevelServerSetupPanel;
    private ActionLink myDeploymentCreateAppLevelSeverLink;
    private ActionLink myDeploymentMoveServerLink;
    private JBRadioButton myDockerRadio;
    private JPanel myDockerPanel;
    private JBLabel myDockerImageLabel;
    private ComboBox myDockerImageCombo;
    private String myDockerImageNameToBeSelected;
    private JBLabel myDockerRemoteApiUrlLabel;
    private JTextField myDockerRemoteApiUrlField;
    private JBLabel myDockerMachineNameLabel;
    private ComboBox myDockerMachineNameCombo;
    private boolean mySkipActionHandlingForDockerMachineNameCombo;
    private JBLabel myDockerCertificatesFolderLabel;
    private JTextField myDockerCertificatesFolderField;
    private JBLabel myDockerMachineExecutableLabel;
    private TextFieldWithBrowseButton myDockerMachineExecutableField;
    private JButton myDockerMachineNamesRefresh;
    private JPanel myAsyncHolder;
    private boolean myNameVisible;
    private final Project myProject;
    private Runnable myValidator;
    @NotNull
    private final BundleAccessor myBundleAccessor;
    private boolean myTempFilesPathVisible;
    private CredentialsType myConnectionType;
    private VagrantBasedCredentialsHolder myVagrantCredentials;
    private WebDeploymentCredentialsHolder myDeploymentCredentials;
    private RemoteCredentials myReferencedCredentials;
    private final VagrantSupport myVagrantSupport;
    @NotNull
    private final CollectionComboBoxModel<DockerMachineItem> myDockerMachineNameModel;
    private final Map<CredentialsType, String> myStoredInterpreterPaths;
    private CredentialsType mySelectedConnectionType;

    public CreateRemoteSdkForm(final @NotNull CreateRemoteSdkDialog<T> dialog, @NotNull BundleAccessor bundleAccessor) {
        if (dialog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialog", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "<init>"));
        }
        if (bundleAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleAccessor", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "<init>"));
        }
        this(dialog.getProject(), dialog, new Runnable(){

            @Override
            public void run() {
                dialog.onValidationPress();
            }
        }, bundleAccessor);
    }

    public CreateRemoteSdkForm(@Nullable Project project, @NotNull RemoteSdkEditorContainer container, @Nullable Runnable validator, @NotNull BundleAccessor bundleAccessor) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "<init>"));
        }
        if (bundleAccessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundleAccessor", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "<init>"));
        }
        super(new BorderLayout());
        this.mySkipActionHandlingForDockerMachineNameCombo = false;
        this.myConnectionType = CredentialsType.SSH_HOST;
        this.$$$setupUI$$$();
        this.myDockerMachineNameModel = new CollectionComboBoxModel();
        this.myStoredInterpreterPaths = ContainerUtil.newHashMap();
        this.mySelectedConnectionType = CredentialsType.SSH_HOST;
        this.myProject = project;
        this.myCredentialsForm.setContainer(container);
        this.myBundleAccessor = bundleAccessor;
        this.myValidator = validator;
        this.add((Component)this.myMainPanel, "Center");
        this.myStatusPanel = new StatusPanel();
        this.myStatusPanelHolder.setLayout(new BorderLayout());
        this.myStatusPanelHolder.add((Component)((Object)this.myStatusPanel), "Center");
        this.setNameVisible(false);
        this.setTempFilesPathVisible(false);
        this.myInterpreterPathLabel.setLabelFor((Component)this.myInterpreterPathField.getTextField());
        this.myInterpreterPathLabel.setText(this.myBundleAccessor.message("remote.interpreter.configure.path.label", new Object[0]));
        this.myHelpersPathLabel.setText(this.myBundleAccessor.message("remote.interpreter.configure.temp.files.path.label", new Object[0]));
        RemoteBrowseActionListener.addShowBrowseRemoteDialogAction(this.myInterpreterPathField, this.myBundleAccessor.message("remote.interpreter.configure.path.title", new Object[0]), this.getRemoteCredentialsProducer());
        RemoteBrowseActionListener.addShowBrowseRemoteDialogAction(this.myHelpersPathField, this.myBundleAccessor.message("remote.interpreter.configure.temp.files.path.title", new Object[0]), this.getRemoteCredentialsProducer());
        this.initWithDefaultValues();
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CreateRemoteSdkForm.this.radioSelected(true);
            }
        };
        this.myVagrantRadio.addActionListener(l);
        this.myDeploymentRadio.addActionListener(l);
        this.myPlainSshRadio.addActionListener(l);
        this.myDockerRadio.addActionListener(l);
        this.myDeploymentProjectLevelServerSetupPanel.setVisible(false);
        if (RemoteSdkUtil.getSftpServerList(this.myProject).isEmpty()) {
            this.myDeploymentRadio.setVisible(false);
        } else {
            this.setupDeploymentCombo(null);
            this.myDeploymentConfigurationsCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateRemoteSdkForm.this.deploymentSelected();
                }
            });
            this.myDeploymentConfigurationsCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer(){

                protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    WebServerConfig c = (WebServerConfig)value;
                    this.append(c.getName()).setIcon(AccessType.SFTP.getIcon());
                }
            });
        }
        this.myVagrantSupport = VagrantSupport.getInstance();
        if (this.myVagrantSupport == null) {
            this.myVagrantRadio.setVisible(false);
        } else {
            String vagrantFolder;
            FileChooserDescriptor folderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            this.myVagrantInstanceTextField.addBrowseFolderListener(new TextBrowseFolderListener(folderDescriptor){

                protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                    if (chosenFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$5", "onFileChosen"));
                    }
                    super.onFileChosen(chosenFile);
                    CreateRemoteSdkForm.this.setVagrantMachineSelectionVisible(false);
                    CreateRemoteSdkForm.this.vagrantSelected(chosenFile.getPath(), null);
                }
            });
            this.myVagrantInstanceTextField.setEditable(false);
            this.setVagrantMachineSelectionVisible(false);
            if (project != null && (vagrantFolder = this.myVagrantSupport.findVagrantFolder(project)) != null) {
                this.myVagrantInstanceTextField.setText(FileUtil.toSystemDependentName((String)vagrantFolder));
            }
        }
        DockerSupport dockerSupport = DockerSupport.getInstance();
        if (dockerSupport != null && this.isDockerOptionAvailable()) {
            this.setupDockerComponents(dockerSupport);
        } else {
            this.myDockerRadio.setVisible(false);
        }
        this.initInterpreterPathsWithDefaults(dockerSupport);
        this.radioSelected(true);
        this.myDockerMachineNamesRefresh.setIcon(AllIcons.Actions.Refresh);
    }

    protected boolean isDockerOptionAvailable() {
        return false;
    }

    private void initInterpreterPathsWithDefaults(@Nullable DockerSupport dockerSupport) {
        String defaultInterpreterPath = this.myBundleAccessor.message("remote.interpreter.default.interpreter.path", new Object[0]);
        this.myStoredInterpreterPaths.put(CredentialsType.SSH_HOST, defaultInterpreterPath);
        this.myStoredInterpreterPaths.put(CredentialsType.WEB_DEPLOYMENT, defaultInterpreterPath);
        this.myStoredInterpreterPaths.put(CredentialsType.VAGRANT, defaultInterpreterPath);
        if (dockerSupport != null) {
            this.myStoredInterpreterPaths.put(CredentialsType.DOCKER, this.myBundleAccessor.message("remote.interpreter.docker.default.interpreter.path", new Object[0]));
        }
    }

    private void setupDeploymentCombo(@Nullable WebServerConfig configToSelect) {
        this.myDeploymentConfigurationsCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(RemoteSdkUtil.getSftpServerList(this.myProject)));
        if (configToSelect != null) {
            this.myDeploymentConfigurationsCombo.setSelectedItem((Object)configToSelect);
            this.myDeploymentProjectLevelServerSetupPanel.setVisible(configToSelect.isProjectLevel());
        }
    }

    private void setupDockerComponents(final @NotNull DockerSupport dockerSupport) {
        if (dockerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerSupport", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "setupDockerComponents"));
        }
        this.myDockerMachineNameCombo.setModel(this.myDockerMachineNameModel);
        this.myDockerMachineExecutableLabel.setVisible(dockerSupport.hasDockerMachine());
        this.myDockerMachineExecutableField.setVisible(dockerSupport.hasDockerMachine());
        this.myDockerMachineNameLabel.setVisible(dockerSupport.hasDockerMachine());
        this.myDockerMachineNameCombo.setVisible(dockerSupport.hasDockerMachine());
        if (dockerSupport.hasDockerMachine()) {
            this.myDockerMachineExecutableField.setText(dockerSupport.getDockerMachineExecutable());
            this.myDockerMachineExecutableField.getTextField().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    CreateRemoteSdkForm.this.updateDockerMachineExecutable(dockerSupport);
                }
            });
            FileChooserDescriptor singleExecutableDescriptor = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
            this.myDockerMachineExecutableField.addBrowseFolderListener(new TextBrowseFolderListener(singleExecutableDescriptor){

                protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                    if (chosenFile == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$7", "onFileChosen"));
                    }
                    super.onFileChosen(chosenFile);
                    CreateRemoteSdkForm.this.updateDockerMachineExecutable(dockerSupport);
                }
            });
            this.myDockerMachineNameCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!CreateRemoteSdkForm.this.mySkipActionHandlingForDockerMachineNameCombo) {
                        CreateRemoteSdkForm.this.myStatusPanel.resetState();
                        CreateRemoteSdkForm.this.updateDockerApiUrlField(dockerSupport, true);
                    }
                }
            });
            this.myDockerMachineNamesRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CreateRemoteSdkForm.this.updateDockerMachineNameCombo(dockerSupport);
                }
            });
        }
    }

    private void setVagrantMachineSelectionVisible(boolean visible) {
        this.myMachineNameCombo.setVisible(visible);
        this.myMachineNameLabel.setVisible(visible);
    }

    private void vagrantSelected(@NotNull String vagrantFolder, @Nullable String machineName) {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "vagrantSelected"));
        }
        StatusPanel.Action loadConfigAction = this.myStatusPanel.progress("Loading Vagrant config");
        this.myInterpreterPathLabel.setAnchor((JComponent)this.myVagrantInstanceLabel);
        if (StringUtil.isNotEmpty((String)machineName)) {
            if (!this.isVagrantMultipleMachines()) {
                this.initVagrantMachineSelection(vagrantFolder, machineName);
            }
        } else {
            List machineNames;
            if (!this.isVagrantMultipleMachines() && (machineNames = this.myVagrantSupport.getMachineNames(vagrantFolder)).size() > 1) {
                this.setMultipleMachinesMode(vagrantFolder, machineName, machineNames);
            }
            if (this.isVagrantMultipleMachines()) {
                loadConfigAction.failed("Multiple machine configuration detected: please select machine name");
                return;
            }
        }
        this.updateStatus(vagrantFolder, machineName, loadConfigAction, 0);
    }

    private void updateStatus(final @NotNull String vagrantFolder, final @Nullable String machineName, final StatusPanel.Action loadConfigAction, final int recursion) {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "updateStatus"));
        }
        if (recursion > 5) {
            loadConfigAction.failed("Couldn't connect to Vagrant");
            return;
        }
        Futures.addCallback((ListenableFuture)this.myVagrantSupport.computeVagrantSettings(this.myProject, vagrantFolder, machineName), (FutureCallback)new FutureCallback<RemoteCredentials>(){

            public void onSuccess(final @Nullable RemoteCredentials credentials) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        loadConfigAction.done();
                        CreateRemoteSdkForm.this.useVagrantSettings(credentials, vagrantFolder, machineName);
                    }
                });
            }

            public void onFailure(final Throwable t) {
                if (t instanceof VagrantSupport.MultipleMachinesException) {
                    if (CreateRemoteSdkForm.this.initVagrantMachineSelection(vagrantFolder, machineName)) {
                        loadConfigAction.done();
                        return;
                    }
                } else if (CreateRemoteSdkForm.this.myVagrantSupport.isNotReadyForSsh(t) && CreateRemoteSdkForm.this.myVagrantSupport.checkVagrantRunning(vagrantFolder, machineName, true)) {
                    CreateRemoteSdkForm.this.updateStatus(vagrantFolder, machineName, loadConfigAction, recursion + 1);
                    return;
                }
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CreateRemoteSdkForm.this.myVagrantHostUrl.setText("");
                        loadConfigAction.failed("Can't Get Vagrant Settings: \n" + t.getMessage());
                    }
                });
            }
        });
    }

    private boolean initVagrantMachineSelection(@NotNull String vagrantFolder, @Nullable String machineName) {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "initVagrantMachineSelection"));
        }
        List machineNames = this.myVagrantSupport.getMachineNames(vagrantFolder);
        if (machineNames.size() > 1) {
            this.setMultipleMachinesMode(vagrantFolder, machineName, machineNames);
            return true;
        }
        return false;
    }

    private void setMultipleMachinesMode(final @NotNull String vagrantFolder, final @Nullable String machineName, List<String> machineNames) {
        if (vagrantFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantFolder", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "setMultipleMachinesMode"));
        }
        for (ItemListener l : Lists.newArrayList((Object[])this.myMachineNameCombo.getItemListeners())) {
            this.myMachineNameCombo.removeItemListener(l);
        }
        this.myMachineNameCombo.setModel((ComboBoxModel)new CollectionComboBoxModel((List)Lists.newArrayList((Iterable)Iterables.concat(Collections.singletonList(null), machineNames))));
        this.myMachineNameCombo.setSelectedItem((Object)machineName);
        this.myMachineNameCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CreateRemoteSdkForm.this.vagrantSelected(vagrantFolder, CreateRemoteSdkForm.this.getVagrantMachineName());
            }
        });
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                CreateRemoteSdkForm.this.setVagrantMachineSelectionVisible(true);
                CreateRemoteSdkForm.this.vagrantSelected(vagrantFolder, machineName);
            }
        });
    }

    private void deploymentSelected() {
        this.myInterpreterPathLabel.setAnchor((JComponent)this.myDeploymentConfigurationLabel);
        WebServerConfig config = (WebServerConfig)this.myDeploymentConfigurationsCombo.getSelectedItem();
        if (config != null) {
            this.useDeploymentSettings(config);
        }
    }

    private void radioSelected(boolean propagateEvent) {
        this.myVagrantCredentialsPanel.setVisible(this.myVagrantRadio.isSelected());
        this.mySshCredentialsPanel.setVisible(this.myPlainSshRadio.isSelected());
        this.myDeploymentPanel.setVisible(this.myDeploymentRadio.isSelected());
        this.myDockerPanel.setVisible(this.myDockerRadio.isSelected());
        this.setBrowseButtonsVisible(!this.myDockerRadio.isSelected());
        if (propagateEvent) {
            this.myStatusPanel.resetState();
            if (this.myVagrantRadio.isSelected()) {
                this.restoreInterpreterPath(CredentialsType.VAGRANT);
                if (!StringUtil.isEmpty((String)this.myVagrantInstanceTextField.getText())) {
                    this.vagrantSelected(this.myVagrantInstanceTextField.getText(), this.getVagrantMachineName());
                }
            } else if (this.myDeploymentRadio.isSelected()) {
                this.restoreInterpreterPath(CredentialsType.WEB_DEPLOYMENT);
                if (this.myDeploymentConfigurationsCombo.getSelectedItem() != null) {
                    this.deploymentSelected();
                }
            } else if (this.myPlainSshRadio.isSelected()) {
                this.restoreInterpreterPath(CredentialsType.SSH_HOST);
                this.plainSshSelected();
            } else if (this.myDockerRadio.isSelected()) {
                this.restoreInterpreterPath(CredentialsType.DOCKER);
                this.dockerSelected();
            }
        }
    }

    private void dockerSelected() {
        this.myConnectionType = CredentialsType.DOCKER;
        DockerSupport dockerSupport = DockerSupport.getInstance();
        if (dockerSupport != null && dockerSupport.hasDockerMachine()) {
            this.updateDockerMachineNameCombo(dockerSupport);
        }
    }

    private void restoreInterpreterPath(@NotNull CredentialsType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "restoreInterpreterPath"));
        }
        String interpreterPath = this.myInterpreterPathField.getText();
        if (StringUtil.isNotEmpty((String)interpreterPath)) {
            this.myStoredInterpreterPaths.put(this.mySelectedConnectionType, interpreterPath);
        }
        this.myInterpreterPathField.setText(this.myStoredInterpreterPaths.get(type));
        this.mySelectedConnectionType = type;
    }

    private void setBrowseButtonsVisible(boolean visible) {
        this.myInterpreterPathField.getButton().setVisible(visible);
        this.myHelpersPathField.getButton().setVisible(visible);
    }

    private void updateDockerMachineNameCombo(final @NotNull DockerSupport dockerSupport) {
        if (dockerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerSupport", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "updateDockerMachineNameCombo"));
        }
        final StatusPanel.Action listDockerMachinesAction = this.myStatusPanel.progress("Listing Docker Machines...");
        this.myDockerMachineNameModel.removeAll();
        this.myDockerMachineNameCombo.setEnabled(false);
        this.setVisibleDockerConnectionInfo(false);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    List machines = CreateRemoteSdkForm.getDockerMachines(dockerSupport);
                    listDockerMachinesAction.done();
                    CreateRemoteSdkForm.this.updateLaterDockerMachineNameCombo(dockerSupport, machines, true);
                }
                catch (RuntimeException e) {
                    listDockerMachinesAction.failed(e.getMessage());
                    CreateRemoteSdkForm.this.updateLaterDockerMachineNameCombo(dockerSupport, Collections.emptyList(), false);
                }
            }
        });
    }

    private void updateLaterDockerMachineNameCombo(final @NotNull DockerSupport dockerSupport, final List<DockerMachineItem> machines, final boolean enabled) {
        if (dockerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerSupport", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "updateLaterDockerMachineNameCombo"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                CreateRemoteSdkForm.this.updateDockerMachineNameCombo(dockerSupport, machines, enabled);
            }
        }, ModalityState.stateForComponent((Component)this));
    }

    private void updateDockerMachineNameCombo(@NotNull DockerSupport dockerSupport, @NotNull List<DockerMachineItem> machines, boolean enabled) {
        if (dockerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerSupport", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "updateDockerMachineNameCombo"));
        }
        if (machines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machines", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "updateDockerMachineNameCombo"));
        }
        this.myDockerMachineNameModel.removeAll();
        this.myDockerMachineNameModel.add(machines);
        this.myDockerMachineNameCombo.setEnabled(enabled);
        this.updateSelectedDockerMachineName();
        this.updateDockerApiUrlField(dockerSupport, false);
    }

    @NotNull
    private static List<DockerMachineItem> getDockerMachines(final @NotNull DockerSupport dockerSupport) {
        if (dockerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerSupport", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "getDockerMachines"));
        }
        List machineNames = dockerSupport.getVMs();
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)Iterables.transform((Iterable)machineNames, (Function)new Function<String, DockerMachineItem>(){

            public DockerMachineItem apply(@Nullable String input) {
                if (input != null) {
                    String status = dockerSupport.getStatus(input);
                    if ("Running".equals(status)) {
                        return DockerMachineItem.running(input);
                    }
                    if ("Stopped".equals(status)) {
                        return DockerMachineItem.stopped(input);
                    }
                }
                return null;
            }
        }));
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "getDockerMachines"));
        }
        return arrayList;
    }

    private void updateSelectedDockerMachineName() {
        DockerMachineItem selectedMachine = (DockerMachineItem)this.myDockerMachineNameModel.getSelectedItem();
        if (selectedMachine != null) {
            DockerMachineItem dockerMachine = CreateRemoteSdkForm.getOrCreateDockerMachine(this.myDockerMachineNameModel.getItems(), selectedMachine.getName());
            this.mySkipActionHandlingForDockerMachineNameCombo = true;
            try {
                this.myDockerMachineNameModel.setSelectedItem((Object)dockerMachine);
            }
            finally {
                this.mySkipActionHandlingForDockerMachineNameCombo = false;
            }
        }
    }

    @NotNull
    private static DockerMachineItem getOrCreateDockerMachine(@NotNull List<DockerMachineItem> items, final @NotNull String machineName) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "getOrCreateDockerMachine"));
        }
        if (machineName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "getOrCreateDockerMachine"));
        }
        DockerMachineItem dockerMachineItem = (DockerMachineItem)Iterables.tryFind(items, (Predicate)new Predicate<DockerMachineItem>(){

            public boolean apply(@Nullable DockerMachineItem input) {
                return input != null && machineName.equals(input.getName());
            }
        }).or((Supplier)new Supplier<DockerMachineItem>(){

            public DockerMachineItem get() {
                return DockerMachineItem.absent(machineName);
            }
        });
        if (dockerMachineItem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "getOrCreateDockerMachine"));
        }
        return dockerMachineItem;
    }

    private void updateDockerMachineExecutable(@NotNull DockerSupport dockerSupport) {
        String previousExecutable;
        if (dockerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerSupport", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "updateDockerMachineExecutable"));
        }
        String executable = this.myDockerMachineExecutableField.getText();
        if (!StringUtil.equals((CharSequence)executable, (CharSequence)(previousExecutable = dockerSupport.getDockerMachineExecutable()))) {
            dockerSupport.setDockerMachineExecutable(executable);
            this.updateDockerMachineNameCombo(dockerSupport);
        }
    }

    private void updateDockerApiUrlField(final @NotNull DockerSupport dockerSupport, boolean askToStart) {
        if (dockerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerSupport", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "updateDockerApiUrlField"));
        }
        this.setVisibleDockerConnectionInfo(false);
        final DockerMachineItem machine = (DockerMachineItem)this.myDockerMachineNameModel.getSelectedItem();
        if (!dockerSupport.hasDockerMachine() || machine != null && machine.isRunning()) {
            final StatusPanel.Action retrieveConnectionInfoAction = this.myStatusPanel.progress("Retrieving Docker Machine URL and certificates...");
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        final DockerSupport.ConnectionInfo connectionInfo = machine != null ? dockerSupport.getConnectionInfo(machine.getName()) : dockerSupport.getConnectionInfo();
                        retrieveConnectionInfoAction.done();
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CreateRemoteSdkForm.this.myDockerRemoteApiUrlField.setText(connectionInfo.getApiUrl());
                                CreateRemoteSdkForm.this.myDockerCertificatesFolderField.setText(connectionInfo.getCertificatesPath());
                                CreateRemoteSdkForm.this.setVisibleDockerConnectionInfo(true);
                                if (machine != null) {
                                    CreateRemoteSdkForm.this.updateDockerImagesCombo(dockerSupport, machine.getName());
                                }
                            }
                        }, ModalityState.stateForComponent((Component)CreateRemoteSdkForm.this));
                    }
                    catch (RuntimeException e) {
                        retrieveConnectionInfoAction.failed(e.getMessage());
                    }
                }
            });
        } else if (machine != null && this.makeDockerMachineRunning(dockerSupport, machine, askToStart)) {
            this.updateDockerMachineNameCombo(dockerSupport);
        } else {
            this.setVisibleDockerConnectionInfo(false);
        }
    }

    private void updateDockerImagesCombo(final @NotNull DockerSupport dockerSupport, final @NotNull String machineName) {
        if (dockerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerSupport", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "updateDockerImagesCombo"));
        }
        if (machineName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "updateDockerImagesCombo"));
        }
        final StatusPanel.Action listImagesAction = this.myStatusPanel.progress("Listing Docker images...");
        if (this.myDockerImageNameToBeSelected == null) {
            this.myDockerImageNameToBeSelected = (String)this.myDockerImageCombo.getSelectedItem();
        }
        this.myDockerImageCombo.setEnabled(false);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    List images = dockerSupport.getImages(machineName);
                    final ArrayList collectedImages = ContainerUtil.newArrayList();
                    for (String[] repoTags : images) {
                        collectedImages.addAll(Arrays.asList(repoTags));
                    }
                    listImagesAction.done();
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CreateRemoteSdkForm.this.myDockerImageCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(collectedImages));
                            if (CreateRemoteSdkForm.this.myDockerImageNameToBeSelected != null) {
                                CreateRemoteSdkForm.this.myDockerImageCombo.setSelectedItem((Object)CreateRemoteSdkForm.this.myDockerImageNameToBeSelected);
                                CreateRemoteSdkForm.this.myDockerImageNameToBeSelected = null;
                            } else if (collectedImages.isEmpty()) {
                                CreateRemoteSdkForm.this.myDockerImageCombo.setSelectedItem((Object)CreateRemoteSdkForm.DEFAULT_DOCKER_IMAGE_NAME);
                            }
                            CreateRemoteSdkForm.this.myDockerImageCombo.setEnabled(true);
                        }
                    }, ModalityState.stateForComponent((Component)CreateRemoteSdkForm.this));
                }
                catch (RuntimeException e) {
                    listImagesAction.failed(e.getMessage());
                }
            }
        });
    }

    private boolean makeDockerMachineRunning(final @NotNull DockerSupport dockerSupport, final @NotNull DockerMachineItem machine, boolean askToStart) {
        if (dockerSupport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerSupport", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "makeDockerMachineRunning"));
        }
        if (machine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machine", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "makeDockerMachineRunning"));
        }
        if (askToStart) {
            ModalityState modalityState = ModalityState.stateForComponent((Component)this.myDockerMachineNameCombo);
            if (machine.isStopped()) {
                final Ref listNeedsUpdate = Ref.create((Object)false);
                ApplicationManager.getApplication().invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (Messages.showYesNoDialog((Project)CreateRemoteSdkForm.this.myProject, (String)("Do you want to start Docker Machine '" + machine.getName() + "'?"), (String)"Docker Machine Not Running", (Icon)Messages.getQuestionIcon()) == 0) {
                            dockerSupport.startMachineWithProgressIndicator(CreateRemoteSdkForm.this.myProject, machine.getName());
                            listNeedsUpdate.set((Object)true);
                        }
                    }
                }, modalityState);
                return (Boolean)listNeedsUpdate.get();
            }
        }
        return false;
    }

    private void setVisibleDockerConnectionInfo(boolean visible) {
        this.myDockerRemoteApiUrlLabel.setVisible(visible);
        this.myDockerRemoteApiUrlField.setVisible(visible);
        this.myDockerCertificatesFolderLabel.setVisible(visible);
        this.myDockerCertificatesFolderField.setVisible(visible);
        this.setVisibleDockerImageCombo(visible);
    }

    private void setVisibleDockerImageCombo(boolean visible) {
        this.myDockerImageLabel.setVisible(visible);
        this.myDockerImageCombo.setVisible(visible);
    }

    protected void plainSshSelected() {
        this.myHelpersPathLabel.setAnchor(null);
        this.myConnectionType = CredentialsType.SSH_HOST;
    }

    @NotNull
    public final RemoteSdkCredentials computeSdkCredentials() throws ExecutionException, InterruptedException {
        T sdkData = this.createSdkDataInner();
        RemoteSdkCredentials remoteSdkCredentials = sdkData.getRemoteSdkCredentials(true);
        if (remoteSdkCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "computeSdkCredentials"));
        }
        return remoteSdkCredentials;
    }

    @NotNull
    public final NullableComputable<RemoteSdkCredentials> getRemoteSdkCredentialsComputable() {
        NullableComputable<RemoteSdkCredentials> nullableComputable = new NullableComputable<RemoteSdkCredentials>(){

            public RemoteSdkCredentials compute() {
                try {
                    return CreateRemoteSdkForm.this.computeSdkCredentials();
                }
                catch (Exception e) {
                    return null;
                }
            }
        };
        if (nullableComputable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "getRemoteSdkCredentialsComputable"));
        }
        return nullableComputable;
    }

    public final AsyncProducer<RemoteSdkCredentials> getRemoteSdkCredentialsProducer() {
        return new AsyncProducer<RemoteSdkCredentials>(){

            public void produce(Consumer<RemoteSdkCredentials> consumer) {
                RemoteSdkCredentials credentials = (RemoteSdkCredentials)CreateRemoteSdkForm.this.getRemoteSdkCredentialsComputable().compute();
                if (credentials != null) {
                    consumer.consume((Object)credentials);
                }
            }
        };
    }

    public final AsyncProducer<RemoteCredentials> getRemoteCredentialsProducer() {
        return new AsyncProducer<RemoteCredentials>(){

            public void produce(Consumer<RemoteCredentials> consumer) {
                RemoteSdkCredentials credentials = (RemoteSdkCredentials)CreateRemoteSdkForm.this.getRemoteSdkCredentialsComputable().compute();
                if (credentials != null) {
                    consumer.consume((Object)credentials);
                }
            }
        };
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.myNameVisible) {
            return this.myNameField;
        }
        return this.myCredentialsForm.getPreferredFocusedComponent();
    }

    public final T createSdkData() {
        T sdkData = this.createSdkDataInner();
        sdkData.completeInitialization();
        return sdkData;
    }

    protected T createSdkDataInner() {
        T sdkData = this.doCreateSdkData(this.getInterpreterPath());
        if (this.myConnectionType == CredentialsType.SSH_HOST) {
            RemoteCredentialsHolder cred = new RemoteCredentialsHolder();
            this.applyEditorCredentialsTo((MutableRemoteCredentials)cred);
            sdkData.setSshCredentials(cred);
        } else if (this.myConnectionType == CredentialsType.VAGRANT) {
            sdkData.setVagrantConnectionType(this.getVagrantCredentials());
        } else if (this.myConnectionType == CredentialsType.WEB_DEPLOYMENT) {
            sdkData.setDeploymentConnectionType(this.getDeploymentCredentials());
        } else if (this.myConnectionType == CredentialsType.DOCKER) {
            DockerMachineItem machine = (DockerMachineItem)this.myDockerMachineNameCombo.getSelectedItem();
            String imageName = (String)this.myDockerImageCombo.getSelectedItem();
            String containerName = null;
            sdkData.setDockerConnectionType(new DockerCredentialsHolder(machine.getName(), imageName, containerName, DEFAULT_DOCKER_PROJECT_PATH));
        } else {
            throw RemoteConnectionCredentialsWrapper.unknownConnectionType();
        }
        sdkData.setHelpersPath(this.getTempFilesPath());
        return sdkData;
    }

    @NotNull
    protected abstract T doCreateSdkData(@NotNull String var1);

    private void createUIComponents() {
        this.myDeploymentCreateAppLevelSeverLink = new ActionLink("Create", new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                WebDeploymentCredentialsHolder credentials = CreateRemoteSdkForm.this.getDeploymentCredentials();
                WebServersConfigManager instance = WebServersConfigManager.getInstance((Project)CreateRemoteSdkForm.this.myProject);
                WebServerConfig server = instance.findServer(credentials.getWebServerConfigId());
                LOG.assertTrue(server != null, (Object)("Server with id " + credentials.getWebServerConfigId() + " not found"));
                LOG.assertTrue(server.isProjectLevel(), (Object)"App-level server with actions shown");
                WebServerConfig global = server.clone();
                global.setId(WebServerConfig.getNextId());
                global.setIsProjectLevel(false);
                global.setName("Copy of project-level server '" + global.getName() + "'");
                instance.setUniqueName(global);
                PublishConfig publishConfig = PublishConfig.getInstance((Project)(CreateRemoteSdkForm.this.myProject == null ? ProjectManager.getInstance().getDefaultProject() : CreateRemoteSdkForm.this.myProject));
                List oldPaths = publishConfig.getExcludedPaths(server.getId());
                publishConfig.setExcludedPaths(global.getId(), oldPaths);
                List oldMappings = publishConfig.getPathMappings(server.getId());
                publishConfig.setPathMappings(global.getId(), oldMappings);
                instance.addServer(global);
                CreateRemoteSdkForm.this.setupDeploymentCombo(global);
            }
        });
        this.myDeploymentMoveServerLink = new ActionLink("Move", new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                WebDeploymentCredentialsHolder credentials = CreateRemoteSdkForm.this.getDeploymentCredentials();
                WebServersConfigManager instance = WebServersConfigManager.getInstance((Project)CreateRemoteSdkForm.this.myProject);
                WebServerConfig server = instance.findServer(credentials.getWebServerConfigId());
                LOG.assertTrue(server != null, (Object)("Server with id " + credentials.getWebServerConfigId() + " not found"));
                LOG.assertTrue(server.isProjectLevel(), (Object)"App-level server with actions shown");
                WebServerConfig movedServer = instance.moveServer(server);
                CreateRemoteSdkForm.this.setupDeploymentCombo(movedServer);
            }
        });
    }

    private void initWithDefaultValues() {
        this.myInterpreterPathField.setText(this.myBundleAccessor.message("remote.interpreter.default.interpreter.path", new Object[0]));
        RemoteCredentialsHolder credentials = new RemoteCredentialsHolder();
        credentials.setPort(22);
        credentials.setStorePassphrase(true);
        credentials.setStorePassword(true);
        this.myCredentialsForm.resetEditorFrom((MutableRemoteCredentials)credentials);
    }

    private void setNameVisible(boolean visible) {
        this.myNameField.setVisible(visible);
        this.myNameLabel.setVisible(visible);
        this.myNameVisible = visible;
    }

    public void setSdkName(String name) {
        if (name != null) {
            this.setNameVisible(true);
            this.myNameField.setText(name);
        }
    }

    public void init(@NotNull T data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "init"));
        }
        this.myConnectionType = data.getRemoteConnectionType();
        data.switchOnConnectionType(new RemoteSdkConnectionAcceptor(){

            public void ssh(@NotNull RemoteCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$26", "ssh"));
                }
                CreateRemoteSdkForm.this.myPlainSshRadio.setSelected(true);
                CreateRemoteSdkForm.this.initSettings(RemoteSdkUtil.createFromRemoteCredentials((RemoteCredentials)cred));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void vagrant(@NotNull VagrantBasedCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$26", "vagrant"));
                }
                VagrantSupport vagrantSupport = VagrantSupport.getInstance();
                RemoteCredentials credentials = null;
                StatusPanel.Action initAction = CreateRemoteSdkForm.this.myStatusPanel.progress("Initializing...");
                try {
                    CreateRemoteSdkForm.this.myVagrantRadio.setSelected(true);
                    if (vagrantSupport != null) {
                        try {
                            credentials = StringUtil.isEmpty((String)cred.getVagrantFolder()) ? null : vagrantSupport.getCredentials(cred.getVagrantFolder(), cred.getMachineName());
                        }
                        catch (IOException e) {
                            initAction.failed(e.getMessage());
                        }
                    } else {
                        VagrantSupport.showMissingVagrantSupportMessage((Project)CreateRemoteSdkForm.this.myProject);
                    }
                    CreateRemoteSdkForm.this.useVagrantSettings(credentials, cred.getVagrantFolder(), cred.getMachineName());
                }
                finally {
                    initAction.done();
                }
            }

            public void deployment(@NotNull WebDeploymentCredentialsHolder cred) {
                if (cred == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cred", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$26", "deployment"));
                }
                CreateRemoteSdkForm.this.myDeploymentRadio.setSelected(true);
                CreateRemoteSdkForm.this.setDeploymentCredentials(new WebDeploymentCredentialsHolder(cred.getWebServerConfigId(), cred.getWebServerConfigName(), cred.getSshCredentials()));
                WebServerConfig server = WebServersConfigManager.getInstance((Project)CreateRemoteSdkForm.this.myProject).findServer(cred.getWebServerConfigId());
                if (server != null) {
                    CreateRemoteSdkForm.this.myDeploymentConfigurationsCombo.setSelectedItem((Object)server);
                    CreateRemoteSdkForm.this.myDeploymentProjectLevelServerSetupPanel.setVisible(server.isProjectLevel());
                } else {
                    LOG.warn("Can not find selected deployment server: " + cred.getWebServerConfigName());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void docker(@NotNull DockerCredentialsHolder credentials) {
                if (credentials == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$26", "docker"));
                }
                DockerSupport dockerSupport = DockerSupport.getInstance();
                if (dockerSupport != null) {
                    CreateRemoteSdkForm.this.myDockerImageNameToBeSelected = credentials.getImageName();
                    if (dockerSupport.hasDockerMachine()) {
                        String machineName = credentials.getMachineName();
                        if (machineName != null) {
                            DockerMachineItem dockerMachine = DockerMachineItem.running(machineName);
                            CreateRemoteSdkForm.this.mySkipActionHandlingForDockerMachineNameCombo = true;
                            try {
                                CreateRemoteSdkForm.this.myDockerMachineNameModel.setSelectedItem((Object)dockerMachine);
                            }
                            finally {
                                CreateRemoteSdkForm.this.mySkipActionHandlingForDockerMachineNameCombo = false;
                            }
                        }
                        CreateRemoteSdkForm.this.updateDockerMachineNameCombo(dockerSupport);
                    } else {
                        CreateRemoteSdkForm.this.updateDockerApiUrlField(dockerSupport, false);
                    }
                    CreateRemoteSdkForm.this.myDockerRadio.setSelected(true);
                }
            }
        });
        this.radioSelected(false);
        String interpreterPath = data.getInterpreterPath();
        this.myInterpreterPathField.setText(interpreterPath);
        this.myStoredInterpreterPaths.put(this.myConnectionType, interpreterPath);
        this.mySelectedConnectionType = this.myConnectionType;
        this.setTempFilesPath((RemoteSdkAdditionalData)data);
        this.validatePathMappings(data);
    }

    public void validatePathMappings(@NotNull T data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "validatePathMappings"));
        }
        if (this.myProject == null || this.myProject.isDefault()) {
            this.myPathMappingsInfoLabel.setVisible(false);
            return;
        }
        if (!this.shouldValidateMappings()) {
            this.myPathMappingsInfoLabel.setVisible(false);
            return;
        }
        String error = PathMappingValidator.validatePathMappings((Project)this.myProject, data);
        boolean hasError = StringUtil.isNotEmpty((String)error);
        this.myPathMappingsInfoLabel.setVisible(hasError);
        if (hasError) {
            this.myPathMappingsInfoLabel.setText(error);
            this.myPathMappingsInfoLabel.setIcon(UIUtil.getBalloonErrorIcon());
        }
    }

    private boolean shouldValidateMappings() {
        Object config;
        if (this.myConnectionType == CredentialsType.WEB_DEPLOYMENT && (config = this.myDeploymentConfigurationsCombo.getSelectedItem()) instanceof WebServerConfig) {
            return !((WebServerConfig)config).isProjectLevel();
        }
        return true;
    }

    private void setTempFilesPath(RemoteSdkAdditionalData data) {
        this.myHelpersPathField.setText(data.getHelpersPath());
        if (!StringUtil.isEmpty((String)data.getHelpersPath())) {
            this.setTempFilesPathVisible(true);
        }
    }

    protected void setTempFilesPathVisible(boolean visible) {
        this.myHelpersPathField.setVisible(visible);
        this.myHelpersPathLabel.setVisible(visible);
        this.myTempFilesPathVisible = visible;
    }

    protected void setInterpreterPathVisible(boolean visible) {
        this.myInterpreterPathField.setVisible(visible);
        this.myInterpreterPathLabel.setVisible(visible);
    }

    private void initSettings(FileTransferConfig config) {
        RemoteCredentialsVerifiableHolder credentials = config.getCredentials();
        credentials.setStorePassword(config.getPasswordState() == FileTransferConfig.PasswordState.Store);
        credentials.setStorePassphrase(config.getPassphraseState() == FileTransferConfig.PasswordState.Store);
        this.myCredentialsForm.resetFrom(credentials);
    }

    public String getInterpreterPath() {
        return this.myInterpreterPathField.getText();
    }

    public String getTempFilesPath() {
        return this.myHelpersPathField.getText();
    }

    public FileTransferConfig getEditorCredentialsAsFileTransferConfig() {
        FileTransferConfig config = new FileTransferConfig();
        this.applyEditorCredentialsTo(config);
        return config;
    }

    public FileTransferConfig credentialsAsFileTransferConfig(RemoteCredentials remoteCredentials) {
        FileTransferConfig config = new FileTransferConfig();
        RemoteCredentialsHolder.copyRemoteCredentials((RemoteCredentials)remoteCredentials, (MutableRemoteCredentials)config.getCredentials());
        return config;
    }

    private void applyEditorCredentialsTo(FileTransferConfig config) {
        RemoteCredentialsVerifiableHolder credentials = config.getCredentials();
        this.applyEditorCredentialsTo((MutableRemoteCredentials)credentials);
        config.setAccessType(AccessType.SFTP);
    }

    private VagrantBasedCredentialsHolder getVagrantCredentials() {
        return this.myVagrantCredentials;
    }

    private WebDeploymentCredentialsHolder getDeploymentCredentials() {
        return this.myDeploymentCredentials;
    }

    private void applyEditorCredentialsTo(MutableRemoteCredentials credentials) {
        try {
            this.myCredentialsForm.applyTo(credentials);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @Nullable
    private ValidationInfo validateConnection(FileTransferConfig config) {
        ErrorMessageAndField error = config.validateUiFast();
        return error == null ? null : this.myCredentialsForm.createValidationInfo(error);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public ValidationInfo validateRemoteInterpreter() {
        String validation;
        block23: {
            FileTransferConfig config;
            block22: {
                if (this.myPlainSshRadio.isSelected()) {
                    config = this.getEditorCredentialsAsFileTransferConfig();
                    ValidationInfo validationInfo = this.validateConnection(config);
                    if (validationInfo != null) {
                        return validationInfo;
                    }
                    if (StringUtil.isEmpty((String)this.getInterpreterPath())) {
                        return new ValidationInfo(this.myBundleAccessor.message("remote.interpreter.unspecified.interpreter.path", new Object[0]), (JComponent)this.myInterpreterPathField);
                    }
                    if (this.myTempFilesPathVisible && StringUtil.isEmpty((String)this.getTempFilesPath())) {
                        return new ValidationInfo(this.myBundleAccessor.message("remote.interpreter.unspecified.temp.files.path", new Object[0]), (JComponent)this.myHelpersPathField);
                    }
                } else {
                    if (this.myVagrantRadio.isSelected()) {
                        if (StringUtil.isEmpty((String)this.myVagrantInstanceTextField.getText())) {
                            return new ValidationInfo("Vagrant instance folder is not specified", (JComponent)this.myVagrantInstanceTextField);
                        }
                        if (this.myReferencedCredentials != null) {
                            config = this.credentialsAsFileTransferConfig(this.myReferencedCredentials);
                            break block22;
                        } else {
                            if (this.myVagrantCredentials == null) {
                                return new ValidationInfo("Cant obtain ssh credentials for Vagrant at " + this.myVagrantInstanceTextField.getText());
                            }
                            try {
                                VagrantSupport vagrantSupport = VagrantSupport.getInstance();
                                if (vagrantSupport == null) {
                                    return new ValidationInfo("Vagrant support is disabled");
                                }
                                this.myReferencedCredentials = vagrantSupport.getCredentials(this.myVagrantCredentials.getVagrantFolder(), this.myVagrantCredentials.getMachineName());
                                return null;
                            }
                            catch (Exception e) {
                                String string;
                                if (e.getMessage() != null) {
                                    string = e.getMessage();
                                    return new ValidationInfo(string);
                                }
                                string = "Error create Vagrant remote interpreter:" + e.getClass().toString();
                                return new ValidationInfo(string);
                            }
                        }
                    }
                    if (this.myDockerRadio.isSelected()) {
                        if (this.myDockerMachineNameCombo.isVisible()) {
                            DockerMachineItem machine = (DockerMachineItem)this.myDockerMachineNameCombo.getSelectedItem();
                            if (machine == null) {
                                return new ValidationInfo("Docker machine is not selected", (JComponent)this.myDockerMachineNameCombo);
                            }
                            if (machine.isAbsent()) {
                                return new ValidationInfo("Docker machine \"" + machine.getName() + "\" does not exist", (JComponent)this.myDockerMachineNameCombo);
                            }
                        }
                        if (!StringUtil.isEmpty((String)((String)this.myDockerImageCombo.getSelectedItem()))) return null;
                        return new ValidationInfo("Docker image name is not specified", (JComponent)this.myDockerImageCombo);
                    }
                    Object server = this.myDeploymentConfigurationsCombo.getSelectedItem();
                    if (server == null) {
                        return new ValidationInfo("Deployment configuration is not selected", (JComponent)this.myDeploymentConfigurationsCombo);
                    }
                    if (server instanceof WebServerConfig && ((WebServerConfig)server).isProjectLevel()) {
                        return new ValidationInfo("Only application-level servers are currently supported. Please create one using any of the two links above.", (JComponent)this.myDeploymentConfigurationsCombo);
                    }
                    config = this.credentialsAsFileTransferConfig(this.myReferencedCredentials);
                }
            }
            try {
                validation = config.validateSlow(500L, false);
            }
            catch (TimeoutException e) {
                validation = "Connection timeout";
                if (e.getMessage() == null) break block23;
                validation = validation + ":" + e.getMessage();
            }
        }
        if (validation == null) return null;
        return new ValidationInfo(validation);
    }

    @Nullable
    public String getSdkName() {
        if (this.myNameVisible) {
            return this.myNameField.getText().trim();
        }
        return null;
    }

    private void useVagrantSettings(@Nullable RemoteCredentials credentials, @NotNull String instanceFolder, @Nullable String machineName) {
        if (instanceFolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instanceFolder", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "useVagrantSettings"));
        }
        this.myConnectionType = CredentialsType.VAGRANT;
        this.setVagrantCredentials(credentials, new VagrantBasedCredentialsHolder(instanceFolder, machineName));
        this.myVagrantInstanceTextField.setText(instanceFolder);
        if (StringUtil.isNotEmpty((String)machineName) && !this.isVagrantMultipleMachines()) {
            this.initVagrantMachineSelection(instanceFolder, machineName);
        }
    }

    private void setVagrantCredentials(@Nullable RemoteCredentials credentials, final @NotNull VagrantBasedCredentialsHolder vagrantCredentials) {
        if (vagrantCredentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vagrantCredentials", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "setVagrantCredentials"));
        }
        this.myVagrantCredentials = vagrantCredentials;
        this.useReferencedCredentials(credentials, this.myVagrantHostUrl, new Runnable(){

            @Override
            public void run() {
                if (!CreateRemoteSdkForm.this.myVagrantSupport.checkVagrantRunning(vagrantCredentials.getVagrantFolder(), vagrantCredentials.getMachineName(), true) && CreateRemoteSdkForm.this.myValidator != null) {
                    CreateRemoteSdkForm.this.myValidator.run();
                }
            }
        });
    }

    private void useDeploymentSettings(@NotNull WebServerConfig config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "useDeploymentSettings"));
        }
        this.myDeploymentProjectLevelServerSetupPanel.setVisible(config.isProjectLevel());
        this.setDeploymentCredentials(new WebDeploymentCredentialsHolder(config.getId(), config.getName(), (RemoteCredentials)config.getFileTransferConfig().getCredentials()));
    }

    private void setDeploymentCredentials(WebDeploymentCredentialsHolder deploymentCredentials) {
        this.myDeploymentCredentials = deploymentCredentials;
        this.myConnectionType = CredentialsType.WEB_DEPLOYMENT;
        this.useReferencedCredentials(this.myDeploymentCredentials.getSshCredentials(), this.myDeploymentUrl, null);
    }

    private void useReferencedCredentials(final @Nullable RemoteCredentials credentials, @NotNull JLabel hostUrl, final @Nullable Runnable testConnectionCallBack) {
        if (hostUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostUrl", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "useReferencedCredentials"));
        }
        this.myReferencedCredentials = credentials;
        if (credentials != null) {
            hostUrl.setVisible(true);
            this.myDeploymentHostLabel.setVisible(true);
            hostUrl.setText("<html><a href=\"#\">" + RemoteCredentialsHolder.getCredentialsString((RemoteCredentials)credentials));
            hostUrl.setCursor(Cursor.getPredefinedCursor(12));
            for (MouseListener ml : hostUrl.getMouseListeners()) {
                hostUrl.removeMouseListener(ml);
            }
            new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$28", "onClick"));
                    }
                    if (clickCount == 1) {
                        final StatusPanel.Action testConnectionAction = CreateRemoteSdkForm.this.myStatusPanel.progress("Testing connection...");
                        if (testConnectionCallBack != null) {
                            testConnectionCallBack.run();
                        }
                        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                            @Override
                            public void run() {
                                if (CreateRemoteSdkForm.this.doTestConnection(credentials)) {
                                    testConnectionAction.doneWithResult(WDBundle.message((String)"connection.to.successful", (Object[])new Object[]{credentials.getHost()}));
                                } else {
                                    testConnectionAction.failed(WDBundle.message((String)"connection.to.failed", (Object[])new Object[]{credentials.getHost(), ""}));
                                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (CreateRemoteSdkForm.this.myValidator != null) {
                                                CreateRemoteSdkForm.this.myValidator.run();
                                            }
                                        }
                                    }, ModalityState.stateForComponent((Component)CreateRemoteSdkForm.this));
                                }
                            }
                        });
                        return true;
                    }
                    return false;
                }
            }.installOn((Component)hostUrl);
        } else {
            hostUrl.setVisible(false);
            this.myDeploymentHostLabel.setVisible(false);
        }
    }

    private boolean doTestConnection(@NotNull RemoteCredentials credentials) {
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm", "doTestConnection"));
        }
        try {
            return RemoteSdkUtil.doTestConnection(null, this, credentials, 10L, TimeUnit.SECONDS);
        }
        catch (RuntimeException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public void updateModifiedValues(RemoteSdkCredentials data) {
        this.myHelpersPathField.setText(data.getHelpersPath());
    }

    public void updateHelpersPath(String helpersPath) {
        this.myHelpersPathField.setText(helpersPath);
    }

    @Nullable
    public String getVagrantMachineName() {
        if (!this.isVagrantMultipleMachines()) {
            return null;
        }
        return this.myMachineNameCombo.getSelectedItem() != null ? this.myMachineNameCombo.getSelectedItem().toString() : null;
    }

    public boolean isVagrantMultipleMachines() {
        return this.myMachineNameLabel.isVisible();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JTextField jTextField;
        JTextField jTextField2;
        ComboBox comboBox;
        JBLabel jBLabel2;
        ComboBox comboBox2;
        JBLabel jBLabel3;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JPanel jPanel;
        JBLabel jBLabel6;
        JPanel jPanel2;
        JPanel jPanel3;
        JLabel jLabel;
        JLabel jLabel2;
        ComboBox comboBox3;
        JLabel jLabel3;
        JPanel jPanel4;
        ComboBox comboBox4;
        JLabel jLabel4;
        JLabel jLabel5;
        JPanel jPanel5;
        JLabel jLabel6;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel6;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JBRadioButton jBRadioButton4;
        JTextField jTextField3;
        JBLabel jBLabel7;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JBLabel jBLabel8;
        RemoteCredentialsEditor remoteCredentialsEditor;
        JPanel jPanel7;
        TextFieldWithBrowseButton textFieldWithBrowseButton4;
        JBLabel jBLabel9;
        JPanel jPanel8;
        this.createUIComponents();
        this.myMainPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(13, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel8.add((Component)spacer, new GridConstraints(12, 0, 1, 1, 0, 2, 1, 6, new Dimension(-1, 10), null, null));
        this.myInterpreterPathLabel = jBLabel9 = new JBLabel();
        jBLabel9.setText("Python interpreter path:");
        jPanel8.add((Component)jBLabel9, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInterpreterPathField = textFieldWithBrowseButton4 = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton4, new GridConstraints(7, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySshCredentialsPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel8.add((Component)jPanel7, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myCredentialsForm = remoteCredentialsEditor = new RemoteCredentialsEditor();
        JComponent jComponent = remoteCredentialsEditor.$$$getRootComponent$$$();
        jPanel7.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHelpersPathLabel = jBLabel8 = new JBLabel();
        jBLabel8.setText("Helpers path:");
        jPanel8.add((Component)jBLabel8, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHelpersPathField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton3, new GridConstraints(8, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myNameLabel = jBLabel7 = new JBLabel();
        jBLabel7.setText("Name:");
        jBLabel7.setDisplayedMnemonic('N');
        jBLabel7.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField3 = new JTextField();
        jPanel8.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel10, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPlainSshRadio = jBRadioButton4 = new JBRadioButton();
        jBRadioButton4.setSelected(true);
        jBRadioButton4.setText("SSH Credentials");
        jBRadioButton4.setMnemonic('S');
        jBRadioButton4.setDisplayedMnemonicIndex(0);
        jPanel10.add((Component)jBRadioButton4, new GridConstraints(0, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myVagrantRadio = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setText("Vagrant");
        jBRadioButton3.setMnemonic('V');
        jBRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel10.add((Component)jBRadioButton3, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myDeploymentRadio = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("Deployment configuration");
        jBRadioButton2.setMnemonic('D');
        jBRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel10.add((Component)jBRadioButton2, new GridConstraints(0, 2, 1, 1, 0, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel10.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDockerRadio = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("Docker");
        jPanel10.add((Component)jBRadioButton, new GridConstraints(0, 3, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myVagrantCredentialsPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myVagrantInstanceTextField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel6.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myVagrantInstanceLabel = jLabel6 = new JLabel();
        jLabel6.setText("Vagrant Instance Folder:");
        jLabel6.setDisplayedMnemonic('F');
        jLabel6.setDisplayedMnemonicIndex(17);
        jPanel6.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setText("Vagrant Host URL:");
        jPanel6.add((Component)jLabel7, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostHolder = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(2, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myVagrantHostUrl = jLabel5 = new JLabel();
        jLabel5.setText("");
        jPanel5.add((Component)jLabel5, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel5.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 1, new Dimension(7, -1), null, new Dimension(7, -1)));
        this.myMachineNameLabel = jLabel4 = new JLabel();
        jLabel4.setText("Machine name:");
        jPanel6.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMachineNameCombo = comboBox4 = new ComboBox();
        jPanel6.add((Component)comboBox4, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myDeploymentPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel4, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentConfigurationLabel = jLabel3 = new JLabel();
        jLabel3.setText("Deployment configuration:");
        jLabel3.setDisplayedMnemonic('C');
        jLabel3.setDisplayedMnemonicIndex(11);
        jPanel4.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeploymentConfigurationsCombo = comboBox3 = new ComboBox();
        jPanel4.add((Component)comboBox3, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myDeploymentHostLabel = jLabel2 = new JLabel();
        jLabel2.setText("Deployment Host URL:");
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel11, new GridConstraints(1, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDeploymentUrl = jLabel = new JLabel();
        jLabel.setText("");
        jPanel11.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel11.add((Component)spacer4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 1, new Dimension(7, -1), null, new Dimension(7, -1)));
        this.myDeploymentProjectLevelServerSetupPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel10 = new JBLabel();
        jBLabel10.setText("Remote SDK is an application-level entity, so it needs the deployment server to be application-level too. Which do you prefer?");
        jPanel3.add((Component)jBLabel10, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 1));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new FlowLayout(0, 5, 5));
        jPanel12.add((Component)jPanel13, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ActionLink actionLink = this.myDeploymentCreateAppLevelSeverLink;
        actionLink.setText("Create");
        Component component = jPanel13.add((Component)actionLink);
        JBLabel jBLabel11 = new JBLabel();
        jBLabel11.setText("application level copy of this server");
        Component component2 = jPanel13.add((Component)jBLabel11);
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new FlowLayout(0, 5, 5));
        jPanel12.add((Component)jPanel14, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        ActionLink actionLink2 = this.myDeploymentMoveServerLink;
        actionLink2.setText("Move");
        Component component3 = jPanel14.add((Component)actionLink2);
        JBLabel jBLabel12 = new JBLabel();
        jBLabel12.setText("this server to application level");
        Component component4 = jPanel14.add((Component)jBLabel12);
        Spacer spacer5 = new Spacer();
        jPanel3.add((Component)spacer5, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myStatusPanelHolder = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel2, new GridConstraints(11, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel2.add((Component)spacer6, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel15, new GridConstraints(10, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel15.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0), null, 0, 0, null, null));
        this.myPathMappingsInfoLabel = jBLabel6 = new JBLabel();
        jPanel15.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel15.add((Component)spacer7, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDockerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myDockerRemoteApiUrlLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Remote API URL:");
        jPanel.add((Component)jBLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDockerCertificatesFolderLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Certificates folder:");
        jPanel.add((Component)jBLabel4, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDockerImageLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Image name:");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDockerImageCombo = comboBox2 = new ComboBox();
        comboBox2.setEditable(true);
        jPanel.add((Component)comboBox2, new GridConstraints(2, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myDockerMachineNameLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Machine name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDockerMachineNameCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myDockerRemoteApiUrlField = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        ((Component)jTextField2).setEnabled(true);
        jPanel.add((Component)jTextField2, new GridConstraints(3, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDockerCertificatesFolderField = jTextField = new JTextField();
        jTextField.setEditable(false);
        ((Component)jTextField).setEnabled(true);
        jPanel.add((Component)jTextField, new GridConstraints(4, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDockerMachineExecutableLabel = jBLabel = new JBLabel();
        jBLabel.setText("Docker Machine executable:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDockerMachineExecutableField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        this.myDockerMachineNamesRefresh = jButton = new JButton();
        jButton.setText("");
        jPanel.add((Component)jButton, new GridConstraints(1, 2, 1, 1, 0, 1, 1, 0, null, null, null));
        jBLabel7.setLabelFor(jTextField3);
        jLabel6.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel3.setLabelFor((Component)comboBox3);
        jBLabel3.setLabelFor((Component)comboBox2);
        jBLabel2.setLabelFor((Component)comboBox);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton4);
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
        buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class DockerMachineItem {
        @NotNull
        private final String myName;
        @NotNull
        private final State myState;

        private DockerMachineItem(@NotNull String name, @NotNull State state) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$DockerMachineItem", "<init>"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$DockerMachineItem", "<init>"));
            }
            this.myName = name;
            this.myState = state;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$DockerMachineItem", "getName"));
            }
            return string;
        }

        @NotNull
        public State getState() {
            State state = this.myState;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$DockerMachineItem", "getState"));
            }
            return state;
        }

        public boolean isAbsent() {
            return this.myState == State.ABSENT;
        }

        public boolean isRunning() {
            return this.myState == State.RUNNING;
        }

        public boolean isStopped() {
            return this.myState == State.STOPPED;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.myName);
            if (this.isAbsent()) {
                sb.append(" (inaccessible)");
            } else if (this.isStopped()) {
                sb.append(" (stopped)");
            }
            return sb.toString();
        }

        @NotNull
        public static DockerMachineItem running(@NotNull String machineName) {
            if (machineName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$DockerMachineItem", "running"));
            }
            DockerMachineItem dockerMachineItem = new DockerMachineItem(machineName, State.RUNNING);
            if (dockerMachineItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$DockerMachineItem", "running"));
            }
            return dockerMachineItem;
        }

        @NotNull
        public static DockerMachineItem stopped(@NotNull String machineName) {
            if (machineName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$DockerMachineItem", "stopped"));
            }
            DockerMachineItem dockerMachineItem = new DockerMachineItem(machineName, State.STOPPED);
            if (dockerMachineItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$DockerMachineItem", "stopped"));
            }
            return dockerMachineItem;
        }

        @NotNull
        public static DockerMachineItem absent(@NotNull String machineName) {
            if (machineName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "machineName", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$DockerMachineItem", "absent"));
            }
            DockerMachineItem dockerMachineItem = new DockerMachineItem(machineName, State.ABSENT);
            if (dockerMachineItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/remotesdk/ui/CreateRemoteSdkForm$DockerMachineItem", "absent"));
            }
            return dockerMachineItem;
        }

        public static enum State {
            ABSENT,
            RUNNING,
            STOPPED;

        }
    }

    public static interface BundleAccessor {
        @NotNull
        public String message(@NotNull String var1, Object ... var2);
    }
}

