/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.TestEnvironment;
import org.jetbrains.dekaf.core.BaseFederatedProvider;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTestHelper;
import org.jetbrains.dekaf.core.DBTestHelperFactory;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFederatedProvider;
import org.jetbrains.dekaf.util.Providers;

public abstract class TestDB {
    @NotNull
    public static DBFacade DB = TestDB.prepareDB(false);
    @NotNull
    public static DBTestHelper TH = TestDB.prepareTH(DB);

    public static void reinitDB(boolean pseudoRemote) {
        DB.disconnect();
        DB = TestDB.prepareDB(pseudoRemote);
        TH = TestDB.prepareTH(DB);
    }

    private static DBFacade prepareDB(boolean pseudoRemote) {
        BaseFederatedProvider provider = new BaseFederatedProvider();
        if (pseudoRemote) {
            PrimeIntermediateFederatedProvider remoteProvider = Providers.loadProvider(PrimeIntermediateFederatedProvider.class);
            provider.initRemotely(remoteProvider);
        } else {
            provider.initLocally();
        }
        return provider.openFacade(TestEnvironment.obtainConnectionString(), null, 10, false);
    }

    public static void connect() {
        DB.connect();
    }

    public static void disconnect() {
        DB.disconnect();
    }

    @NotNull
    private static DBTestHelper prepareTH(@NotNull DBFacade db) {
        Collection<DBTestHelperFactory> helperFactories = Providers.loadAllProviders(DBTestHelperFactory.class);
        for (DBTestHelperFactory helperFactory : helperFactories) {
            if (!helperFactory.supportRdbms().contains(db.rdbms())) continue;
            return helperFactory.createTestHelperFor(db);
        }
        throw new IllegalStateException("No test DB helper factory that can support " + db.rdbms());
    }

    public static void printEnvironmentHeader() {
    }
}

