/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.lang.reflect.Array;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.BaseSeanceRunner;
import org.jetbrains.dekaf.core.DBQueryRunner;
import org.jetbrains.dekaf.core.ResultLayout;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateCursor;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSeance;

public class BaseQueryRunner<S>
implements DBQueryRunner<S>,
BaseSeanceRunner {
    @NotNull
    protected final IntegralIntermediateSeance myInterSeance;
    @NotNull
    private final ResultLayout<S> myResultLayout;
    @Nullable
    private IntegralIntermediateCursor<S> myCursor;
    private int myPackLimit = 1000000000;
    private boolean myMultiPackMode = false;

    protected BaseQueryRunner(@NotNull IntegralIntermediateSeance interSeance, @NotNull ResultLayout<S> resultLayout) {
        this.myInterSeance = interSeance;
        this.myResultLayout = resultLayout;
    }

    @Override
    @NotNull
    public synchronized BaseQueryRunner<S> withParams(Object ... params) {
        if (this.myCursor != null) {
            throw new IllegalStateException("Cursor is open. Close (or completely fetch) it before run the query again.");
        }
        if (params != null && params.length > 0) {
            this.myInterSeance.setInParameters(params);
        }
        return this;
    }

    @Override
    @NotNull
    public synchronized BaseQueryRunner<S> packBy(int rowsPerPack) {
        this.endFetching();
        this.myPackLimit = rowsPerPack;
        this.myMultiPackMode = true;
        return this;
    }

    @Override
    public synchronized S run() {
        this.endFetching();
        this.myInterSeance.execute();
        this.myCursor = this.myInterSeance.openCursor(0, this.myResultLayout);
        return this.fetchPack();
    }

    @Override
    public synchronized S nextPack() {
        if (this.myCursor != null) {
            return this.fetchPack();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private S fetchPack() {
        assert (this.myCursor != null);
        boolean ok = false;
        try {
            this.myCursor.setFetchLimit(this.myPackLimit);
            Object result = this.myCursor.fetch();
            ok = true;
            Object object = result != null ? result : this.emptyResult();
            return (S)object;
        }
        finally {
            if (!(ok && this.myMultiPackMode && this.myCursor.hasRows())) {
                this.myCursor.close();
                this.myCursor = null;
            }
        }
    }

    private S emptyResult() {
        switch (this.myResultLayout.kind) {
            case ARRAY: {
                return (S)Array.newInstance(this.myResultLayout.row.rowClass, 0);
            }
            case ARRAY_OF_PRIMITIVES: {
                return (S)Array.newInstance(this.myResultLayout.row.rowClass, 0);
            }
            case LIST: {
                return (S)Collections.emptyList();
            }
            case SET: {
                return (S)Collections.emptySet();
            }
            case MAP: {
                return (S)Collections.emptyMap();
            }
        }
        return null;
    }

    public synchronized void endFetching() {
        if (this.myCursor != null) {
            this.myCursor.close();
            this.myCursor = null;
        }
    }

    @Override
    public synchronized void close() {
        this.endFetching();
        this.myInterSeance.close();
    }
}

