/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.BaseCommandRunner;
import org.jetbrains.dekaf.core.BaseQueryRunner;
import org.jetbrains.dekaf.core.BaseScriptRunner;
import org.jetbrains.dekaf.core.BaseSeanceRunner;
import org.jetbrains.dekaf.core.DBCommandRunner;
import org.jetbrains.dekaf.core.DBLeasedSession;
import org.jetbrains.dekaf.core.DBScriptRunner;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.core.ResultLayout;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSeance;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSession;
import org.jetbrains.dekaf.sql.SqlCommand;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.sql.SqlScript;
import org.jetbrains.dekaf.util.Objects;

public class BaseSession
implements DBSession,
DBLeasedSession,
DBTransaction {
    @NotNull
    private final IntegralIntermediateSession myInterSession;
    private final Queue<BaseSeanceRunner> myRunners = new LinkedList<BaseSeanceRunner>();

    protected BaseSession(@NotNull IntegralIntermediateSession interSession) {
        this.myInterSession = interSession;
    }

    @Override
    public void beginTransaction() {
        this.myInterSession.beginTransaction();
    }

    @Override
    public boolean isInTransaction() {
        return this.myInterSession.isInTransaction();
    }

    @Override
    public void commit() {
        this.myInterSession.commit();
    }

    @Override
    public void rollback() {
        this.myInterSession.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <R> R inTransaction(InTransaction<R> operation) {
        R result;
        this.closeRunners();
        boolean ok = false;
        this.beginTransaction();
        try {
            result = operation.run(this);
            this.commit();
            ok = true;
        }
        finally {
            this.closeRunners();
            if (!ok) {
                this.rollback();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void inTransaction(InTransactionNoResult operation) {
        this.closeRunners();
        boolean ok = false;
        this.beginTransaction();
        try {
            operation.run(this);
            this.commit();
            ok = true;
        }
        finally {
            this.closeRunners();
            if (!ok) {
                this.rollback();
            }
        }
    }

    @Override
    @NotNull
    public synchronized DBCommandRunner command(@NotNull SqlCommand command) {
        IntegralIntermediateSeance interSeance = this.myInterSession.openSeance(command.getSourceText(), null);
        BaseCommandRunner commandRunner = new BaseCommandRunner(interSeance);
        this.myRunners.add(commandRunner);
        return commandRunner;
    }

    @Override
    @NotNull
    public synchronized DBCommandRunner command(@NotNull String commandText) {
        IntegralIntermediateSeance interSeance = this.myInterSession.openSeance(commandText, null);
        BaseCommandRunner commandRunner = new BaseCommandRunner(interSeance);
        this.myRunners.add(commandRunner);
        return commandRunner;
    }

    @NotNull
    public synchronized <S> BaseQueryRunner<S> query(@NotNull SqlQuery<S> query) {
        IntegralIntermediateSeance interSeance = this.myInterSession.openSeance(query.getSourceText(), null);
        BaseQueryRunner<S> queryRunner = new BaseQueryRunner<S>(interSeance, query.getLayout());
        this.myRunners.add(queryRunner);
        return queryRunner;
    }

    @NotNull
    public synchronized <S> BaseQueryRunner<S> query(@NotNull String queryText, @NotNull ResultLayout<S> layout) {
        SqlQuery<S> query = new SqlQuery<S>(queryText, layout);
        return this.query((SqlQuery)query);
    }

    @Override
    @NotNull
    public synchronized DBScriptRunner script(@NotNull SqlScript script) {
        return new BaseScriptRunner(this, script);
    }

    protected synchronized void closeRunners() {
        while (!this.myRunners.isEmpty()) {
            BaseSeanceRunner runner = this.myRunners.poll();
            runner.close();
        }
    }

    @Override
    @Nullable
    public synchronized <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        if (serviceName.equalsIgnoreCase("intermediate-service")) {
            return Objects.castTo(serviceClass, this.myInterSession);
        }
        return this.myInterSession.getSpecificService(serviceClass, serviceName);
    }

    @Override
    public long ping() {
        return this.myInterSession.ping();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.myInterSession.isClosed();
    }

    @Override
    public synchronized void close() {
        this.closeRunners();
        this.myInterSession.close();
    }
}

