/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.core;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.BaseTestHelper;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBSession;
import org.jetbrains.dekaf.core.InSession;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.sql.Scriptum;
import org.jetbrains.dekaf.sql.SqlQuery;

public class SybaseTestHelper
extends BaseTestHelper<DBFacade> {
    private final SqlQuery<Boolean> myTableOrViewExistenceQuery;

    public SybaseTestHelper(@NotNull DBFacade db) {
        super(db, Scriptum.of(SybaseTestHelper.class));
        this.myTableOrViewExistenceQuery = this.scriptum.query("TableOrViewExistence", Layouts.existence());
    }

    private boolean tableExists(final @NotNull String name) {
        return this.db.inSession(new InSession<Boolean>(){

            @Override
            public Boolean run(@NotNull DBSession session) {
                return (Boolean)session.query(SybaseTestHelper.this.myTableOrViewExistenceQuery).withParams(name).run();
            }
        });
    }

    @Override
    public void prepareX1() {
        if (this.tableExists("X1")) {
            return;
        }
        this.performScript(this.scriptum, "X1");
    }

    public void prepareX10() {
        if (this.tableExists("X10")) {
            return;
        }
        this.performScript(this.scriptum, "X10");
    }

    @Override
    public void prepareX1000() {
        if (this.tableExists("X1000")) {
            return;
        }
        this.prepareX10();
        this.performScript(this.scriptum, "X1000");
    }

    @Override
    public void prepareX1000000() {
        if (this.tableExists("X1000000")) {
            return;
        }
        this.prepareX1000();
        this.performCommand(this.scriptum, "X1000000");
    }

    @Override
    protected void ensureNoTableOrView4(Object[] params) {
        this.performMetaQueryCommands(this.scriptum, "EnsureNoForeignKeysMetaQuery", params);
        this.performMetaQueryCommands(this.scriptum, "EnsureNoTableOrViewMetaQuery", params);
    }

    @Override
    protected void zapSchemaInternally(ConnectionInfo connectionInfo) {
        this.performMetaQueryCommands(this.scriptum, "ZapForeignKeysMetaQuery", new Object[0]);
        this.performMetaQueryCommands(this.scriptum, "ZapSchemaMetaQuery", new Object[0]);
    }
}

