/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.exceptions.DBInitializationException;
import org.jetbrains.dekaf.exceptions.DBSessionIsClosedException;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateRdbmsProvider;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.util.Objects;

public abstract class JdbcIntermediateRdbmsProvider
implements IntegralIntermediateRdbmsProvider {
    private static final String DAMN_JDBC_DRIVER_NOT_REGISTERED_ERROR_STATE = "08001";

    @Override
    @NotNull
    public JdbcIntermediateFacade openFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit) {
        Driver driver = this.getDriver(connectionString);
        return this.instantiateFacade(connectionString, connectionProperties, connectionsLimit, driver);
    }

    @NotNull
    public JdbcIntermediateSession wrapConnection(@NotNull Connection connection, boolean takeOwnership) {
        BaseExceptionRecognizer exceptionRecognizer = this.getExceptionRecognizer();
        try {
            if (connection.isClosed()) {
                throw new DBSessionIsClosedException("The given connection is closed.");
            }
            return new JdbcIntermediateSession(null, exceptionRecognizer, connection, takeOwnership);
        }
        catch (SQLException sqle) {
            throw exceptionRecognizer.recognizeException(sqle, "JdbcIntermediateRdbmsProvider.wrapConnection()");
        }
    }

    @NotNull
    protected JdbcIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        BaseExceptionRecognizer exceptionRecognizer = this.getExceptionRecognizer();
        return new JdbcIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, exceptionRecognizer);
    }

    protected Driver getDriver(@NotNull String connectionString) {
        this.tryToLoadDriverIfNeeded();
        try {
            return DriverManager.getDriver(connectionString);
        }
        catch (SQLException sqle) {
            throw this.getExceptionRecognizer().recognizeException(sqle, "DriverManager.getDriver for: " + connectionString);
        }
    }

    protected void tryToLoadDriverIfNeeded() {
        Driver driver;
        String connectionStringExample = this.getConnectionStringExample();
        if (connectionStringExample != null && !this.whetherApplicableDriverAlreadyRegistered(connectionStringExample) && (driver = this.loadDriver()) != null) {
            this.registerDriver(driver);
        }
    }

    @Nullable
    protected abstract String getConnectionStringExample();

    @Nullable
    protected abstract Driver loadDriver();

    protected boolean whetherApplicableDriverAlreadyRegistered(@NotNull String connectionString) {
        try {
            DriverManager.getDriver(connectionString);
            return true;
        }
        catch (SQLException sqle) {
            if (!sqle.getSQLState().equals(DAMN_JDBC_DRIVER_NOT_REGISTERED_ERROR_STATE)) {
                // empty if block
            }
            return false;
        }
    }

    protected void registerDriver(Driver driver) {
        try {
            DriverManager.registerDriver(driver);
        }
        catch (SQLException sqle) {
            throw new DBInitializationException("Failed to register JDBC Driver", sqle);
        }
    }

    protected Class<Driver> getSimpleAccessibleDriverClass(@NotNull String driverClassName) {
        try {
            return Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public abstract BaseExceptionRecognizer getExceptionRecognizer();

    @Override
    @NotNull
    public Class<? extends DBExceptionRecognizer> getExceptionRecognizerClass() {
        BaseExceptionRecognizer er = this.getExceptionRecognizer();
        return er.getClass();
    }

    @Override
    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
        if (serviceName.equalsIgnoreCase("intermediate-service")) {
            return Objects.castTo(serviceClass, this);
        }
        return null;
    }
}

