/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.ParameterDef;
import org.jetbrains.dekaf.exceptions.DBException;
import org.jetbrains.dekaf.exceptions.DBSessionIsClosedException;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSession;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateCallableSeance;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateCursor;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateFacade;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSeance;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSimpleSeance;
import org.jetbrains.dekaf.jdbc.JdbcUtil;
import org.jetbrains.dekaf.util.Objects;

public class JdbcIntermediateSession
implements IntegralIntermediateSession {
    @Nullable
    private final JdbcIntermediateFacade myFacade;
    @NotNull
    private final DBExceptionRecognizer myExceptionRecognizer;
    @NotNull
    private final Connection myConnection;
    private final boolean myOwnConnection;
    private boolean myInTransaction;
    private boolean myClosed;
    @NotNull
    private final Queue<JdbcIntermediateSeance> mySeances = new LinkedBlockingQueue<JdbcIntermediateSeance>();
    static final int DEFAULT_FETCH_SIZE = 1000;

    protected JdbcIntermediateSession(@Nullable JdbcIntermediateFacade facade, @NotNull DBExceptionRecognizer exceptionRecognizer, @NotNull Connection connection, boolean ownConnection) {
        this.myFacade = facade;
        this.myExceptionRecognizer = exceptionRecognizer;
        this.myConnection = connection;
        this.myOwnConnection = ownConnection;
        this.myClosed = false;
    }

    @Override
    public synchronized void beginTransaction() {
        this.checkNotClosed();
        if (!this.myInTransaction) {
            try {
                this.myConnection.setAutoCommit(false);
            }
            catch (SQLException sqle) {
                throw this.recognizeException(sqle, "set autocommit = false");
            }
        } else {
            throw new IllegalStateException("The sessions is already in a transaction");
        }
        this.myInTransaction = true;
    }

    @Override
    public boolean isInTransaction() {
        return this.myInTransaction;
    }

    @Override
    public synchronized void commit() {
        if (this.myInTransaction) {
            this.myInTransaction = false;
            try {
                this.myConnection.commit();
            }
            catch (SQLException sqle) {
                this.rollback();
                throw this.myExceptionRecognizer.recognizeException(sqle, "commit");
            }
        } else {
            throw new IllegalStateException("The sessions is not in a transaction");
        }
    }

    @Override
    public synchronized void rollback() {
        if (this.myClosed) {
            return;
        }
        this.myInTransaction = false;
        try {
            this.myConnection.rollback();
            this.myConnection.setAutoCommit(true);
        }
        catch (SQLException sqle) {
            JdbcUtil.printOperationException(sqle, "rollback");
            this.close();
        }
    }

    @Override
    @NotNull
    public synchronized JdbcIntermediateSeance openSeance(@NotNull String statementText, @Nullable ParameterDef[] outParameterDefs) {
        this.checkNotClosed();
        JdbcIntermediateSeance seance = outParameterDefs == null ? this.openSimpleStatementSeance(statementText) : this.openPreparedStatementSeance(statementText, outParameterDefs);
        this.mySeances.add(seance);
        return seance;
    }

    @NotNull
    protected JdbcIntermediateSimpleSeance openSimpleStatementSeance(@NotNull String statementText) {
        return new JdbcIntermediateSimpleSeance(this, statementText);
    }

    @NotNull
    protected JdbcIntermediateCallableSeance openPreparedStatementSeance(@NotNull String statementText, @NotNull ParameterDef[] outParameterDefs) {
        return new JdbcIntermediateCallableSeance(this, statementText, outParameterDefs);
    }

    @Override
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) {
        if (serviceName.equalsIgnoreCase("intermediate-service")) {
            return Objects.castTo(serviceClass, this);
        }
        if (serviceName.equalsIgnoreCase("jdbc-connection")) {
            return Objects.castTo(serviceClass, this.myConnection);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long ping() {
        if (this.myClosed) {
            throw new DBSessionIsClosedException("The session is closed.");
        }
        long time1 = System.currentTimeMillis();
        boolean ok = false;
        try {
            if (this.myConnection.isClosed()) {
                throw new DBSessionIsClosedException("The JDBC connection is closed.");
            }
            Statement statement = this.myConnection.createStatement();
            try {
                this.performPing(statement);
                ok = true;
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException sqle) {
            throw this.myExceptionRecognizer.recognizeException(sqle, "ping");
        }
        finally {
            if (!ok) {
                this.close();
            }
        }
        long duration = System.currentTimeMillis() - time1;
        if (duration == 0L) {
            duration = 1L;
        }
        return duration;
    }

    protected void performPing(Statement statement) throws SQLException {
        String pingQuery = "select 1";
        statement.execute("select 1");
    }

    @Override
    public synchronized void close() {
        if (this.myClosed) {
            return;
        }
        this.closeSeances();
        if (this.myInTransaction) {
            this.rollback();
        }
        this.myClosed = true;
        if (this.myFacade != null) {
            this.myFacade.sessionIsClosed(this, this.myConnection);
        }
        if (this.myOwnConnection) {
            JdbcUtil.close(this.myConnection);
        }
    }

    private void closeSeances() {
        while (!this.mySeances.isEmpty()) {
            JdbcIntermediateSeance seanceToClose = this.mySeances.poll();
            seanceToClose.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.myClosed;
    }

    @NotNull
    PreparedStatement prepareSimpleStatement(@NotNull String statementText) throws SQLException {
        PreparedStatement statement = this.myConnection.prepareStatement(statementText, 1003, 1007);
        statement.setFetchSize(1000);
        return statement;
    }

    @NotNull
    CallableStatement prepareCallableStatement(@NotNull String statementText) throws SQLException {
        return this.myConnection.prepareCall(statementText);
    }

    @NotNull
    ResultSet getDefaultResultSet(@NotNull Statement statement) throws SQLException {
        return statement.getResultSet();
    }

    void tuneResultSet(@NotNull ResultSet rset) throws SQLException {
        this.tuneResultSetWithFetchSize(rset, 1000);
    }

    void tuneResultSetWithFetchSize(@NotNull ResultSet rset, int fetchLimit) throws SQLException {
        if (rset.getFetchDirection() != 1000) {
            rset.setFetchDirection(1000);
        }
        rset.setFetchSize(fetchLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V[] queryOneRow(@NotNull String queryText, int columnCount, @NotNull Class<V> columnClass) {
        JdbcIntermediateSeance seance1 = this.openSeance(queryText, null);
        try {
            JdbcIntermediateCursor<V[]> cursor1;
            block8: {
                seance1.execute();
                cursor1 = seance1.openDefaultCursor(Layouts.rowOf(Layouts.arrayOf(columnCount, columnClass)));
                try {
                    if (!cursor1.hasRows()) break block8;
                    V[] VArray = cursor1.fetch();
                    cursor1.close();
                    return VArray;
                }
                catch (Throwable throwable) {
                    cursor1.close();
                    throw throwable;
                }
            }
            V[] VArray = null;
            cursor1.close();
            return VArray;
        }
        finally {
            seance1.close();
        }
    }

    public int countOpenedSeances() {
        int count = 0;
        for (JdbcIntermediateSeance seance : this.mySeances) {
            if (!seance.isStatementOpened()) continue;
            ++count;
        }
        return count;
    }

    public int countOpenedCursors() {
        int count = 0;
        for (JdbcIntermediateSeance seance : this.mySeances) {
            count += seance.countOpenedCursors();
        }
        return count;
    }

    @NotNull
    protected Connection getConnection() {
        return this.myConnection;
    }

    private void checkNotClosed() {
        if (this.myClosed) {
            throw new DBSessionIsClosedException("The session is closed");
        }
    }

    @NotNull
    protected DBException recognizeException(@NotNull SQLException sqle) {
        return this.myExceptionRecognizer.recognizeException(sqle, null);
    }

    @NotNull
    protected DBException recognizeException(@NotNull SQLException sqle, @Nullable String statementText) {
        return this.myExceptionRecognizer.recognizeException(sqle, statementText);
    }
}

