/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.sql.Driver;
import java.util.Properties;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.exceptions.DBInitializationException;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.jdbc.BaseExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateRdbmsProvider;
import org.jetbrains.dekaf.jdbc.PostgresExceptionRecognizer;
import org.jetbrains.dekaf.jdbc.PostgresIntermediateFacade;

public class PostgresIntermediateProvider
extends JdbcIntermediateRdbmsProvider {
    public static final PostgresIntermediateProvider INSTANCE = new PostgresIntermediateProvider();
    static final Pattern POSTGRES_CONNECTION_STRING_PATTERN = Pattern.compile("^jdbc:postgresql://.+$");
    static final String POSTGRES_CONNECTION_STRING_EXAMPLE = "jdbc:postgresql:///";
    private static final String POSTGRES_DRIVER_CLASS_NAME = "org.postgresql.Driver";

    @Override
    @NotNull
    protected String getConnectionStringExample() {
        return POSTGRES_CONNECTION_STRING_EXAMPLE;
    }

    @Override
    protected Driver loadDriver() {
        Driver driver;
        Class<Driver> driverClass = this.getSimpleAccessibleDriverClass(POSTGRES_DRIVER_CLASS_NAME);
        if (driverClass == null) {
            // empty if block
        }
        if (driverClass == null) {
            throw new DBInitializationException("PostgreSQL Driver class not found");
        }
        try {
            driver = driverClass.newInstance();
        }
        catch (Exception e) {
            throw new DBPreparingException("Failed to instantiate driver: " + e.getMessage(), e);
        }
        return driver;
    }

    @Override
    @NotNull
    public Rdbms rdbms() {
        return Postgres.RDBMS;
    }

    @Override
    @NotNull
    public Pattern connectionStringPattern() {
        return POSTGRES_CONNECTION_STRING_PATTERN;
    }

    @Override
    public byte specificity() {
        return 10;
    }

    @Override
    @NotNull
    protected PostgresIntermediateFacade instantiateFacade(@NotNull String connectionString, @Nullable Properties connectionProperties, int connectionsLimit, @NotNull Driver driver) {
        return new PostgresIntermediateFacade(connectionString, connectionProperties, driver, connectionsLimit, PostgresExceptionRecognizer.INSTANCE);
    }

    @Override
    @NotNull
    public BaseExceptionRecognizer getExceptionRecognizer() {
        return PostgresExceptionRecognizer.INSTANCE;
    }
}

