/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class Numbers {
    public static boolean valuesAreEqual(@Nullable Number x, @Nullable Number y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.getClass() == y.getClass() ? x.equals(y) : x.toString().equals(y.toString());
    }

    @Contract(value="_,!null -> !null; _,null -> null")
    public static <N extends Number> N convertNumber(Class<N> numberClass, Number number) {
        if (number == null) {
            return null;
        }
        if (numberClass.isAssignableFrom(number.getClass())) {
            return (N)number;
        }
        if (numberClass == Byte.class || numberClass == Byte.TYPE) {
            return (N)new Byte(number.byteValue());
        }
        if (numberClass == Short.class || numberClass == Short.TYPE) {
            return (N)new Short(number.shortValue());
        }
        if (numberClass == Integer.class || numberClass == Integer.TYPE) {
            return (N)new Integer(number.intValue());
        }
        if (numberClass == Long.class || numberClass == Long.TYPE) {
            return (N)new Long(number.longValue());
        }
        if (numberClass == Float.class || numberClass == Float.TYPE) {
            return (N)new Float(number.floatValue());
        }
        if (numberClass == Double.class || numberClass == Double.TYPE) {
            return (N)new Double(number.doubleValue());
        }
        if (numberClass == BigInteger.class) {
            return (N)new BigInteger(number.toString());
        }
        if (numberClass == BigDecimal.class) {
            return (N)new BigDecimal(number.toString());
        }
        String message = String.format("Unknown how to convert value (%s) of type %s to %s.", number.toString(), number.getClass().getCanonicalName(), numberClass.getCanonicalName());
        throw new IllegalArgumentException(message);
    }

    public static int parseIntSafe(@Nullable String str) {
        if (str == null) {
            return 0;
        }
        try {
            String s = str.trim();
            if (s.isEmpty()) {
                return 0;
            }
            if (s.charAt(0) == '+') {
                return Integer.parseInt(s.substring(1));
            }
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long parseLongSafe(@Nullable String str) {
        if (str == null) {
            return 0L;
        }
        try {
            String s = str.trim();
            if (s.isEmpty()) {
                return 0L;
            }
            if (s.charAt(0) == '+') {
                return Long.parseLong(s.substring(1));
            }
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }
}

