/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.moveattributein;

import com.intellij.openapi.help.HelpManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.border.IdeaTitledBorder;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.Document;

class MoveAttributeInDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final JTextField tagNameField;
    private final XmlAttribute attribute;
    private final XmlTag tag;

    MoveAttributeInDialog(XmlAttribute attribute) {
        super(attribute.getProject(), true);
        this.attribute = attribute;
        String attributeName = attribute.getName();
        this.tag = attribute.getParent();
        XmlFile containingFile = (XmlFile)this.tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.setTitle("Move Attribute In");
        this.attributeNameLabel.setText("Move Attribute to Subtag:");
        this.tagNameField = new JTextField("");
        Document document = this.tagNameField.getDocument();
        document.addDocumentListener(this.docListener);
        this.init();
        this.validateButtons();
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.MoveAttributeIn";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.tagNameField;
    }

    public String getTagName() {
        String text = this.tagNameField.getText();
        return text.trim();
    }

    protected JComponent createNorthPanel() {
        String tagName = this.tag.getName();
        String attributeName = this.attribute.getName();
        JPanel panel = new JPanel(new BorderLayout());
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)("Move attribute " + attributeName + " of tag " + tagName + " in to subtag"), (boolean)true);
        panel.add((Component)this.attributeNameLabel, "North");
        Box box = Box.createVerticalBox();
        panel.setBorder((Border)border);
        this.tagNameField.setEditable(true);
        box.add(this.tagNameField);
        panel.add((Component)box, "Center");
        return panel;
    }

    @Override
    protected boolean isValid() {
        String tagName = this.getTagName();
        boolean tagNameEntered = XMLUtil.tagNameIsValid(tagName);
        boolean scopeIsValid = this.scopePanel.isScopeValid();
        return tagNameEntered && scopeIsValid;
    }

    @Override
    protected String calculateXSLT() {
        String attributeName = this.attribute.getName();
        String parentTagName = this.attribute.getParent().getName();
        String childTagName = this.getTagName();
        return "<xsl:template match=\"" + parentTagName + "[@" + attributeName + "]/" + childTagName + "\">\n" + "\t<xsl:copy> \n" + "\t\t<xsl:attribute name = \"" + attributeName + "\">\n" + "\t\t\t<xsl:value-of select=\"../@" + attributeName + "\"/>\n" + "\t\t</xsl:attribute>\n" + "\t\t<xsl:apply-templates select=\"@*|node()\"/>\n" + "\t</xsl:copy>          \n" + "</xsl:template>  \n" + "<xsl:template match = \"@" + attributeName + "[parent::" + parentTagName + "]\"/>";
    }

    @Override
    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactoring.moveAttributeIn");
    }
}

