/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.tagtoattribute;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringActionHandler;
import com.sixrr.xrp.base.ErrorMessageUtil;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.tagtoattribute.TagToAttributeDialog;
import com.sixrr.xrp.tagtoattribute.TagToAttributeProcessor;
import org.jetbrains.annotations.NotNull;

class TagToAttributeHandler
implements RefactoringActionHandler {
    private static final String REFACTORING_NAME = "Tag To Attribute";

    TagToAttributeHandler() {
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/sixrr/xrp/tagtoattribute/TagToAttributeHandler", "invoke"));
        }
        XmlTag selectedTag = TagToAttributeHandler.findSelectedTag(editor, file);
        if (selectedTag == null) {
            String message = "Cannot perform the refactoring.\nThe caret should be positioned at a tag to be refactored.";
            ErrorMessageUtil.showErrorMessage(REFACTORING_NAME, "Cannot perform the refactoring.\nThe caret should be positioned at a tag to be refactored.", "refactoring.tagToAttribute", project);
        } else if (selectedTag.getParentTag() == null) {
            String message = "Cannot perform the refactoring.\nThis refactoring is not available for top-level tags.";
            ErrorMessageUtil.showErrorMessage(REFACTORING_NAME, "Cannot perform the refactoring.\nThis refactoring is not available for top-level tags.", "refactoring.tagToAttribute", project);
        } else {
            TagToAttributeHandler.handleDeleteAttribute(selectedTag, project);
        }
    }

    private static XmlTag findSelectedTag(Editor editor, PsiFile file) {
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        CaretModel caretModel = editor.getCaretModel();
        int position = caretModel.getOffset();
        for (PsiElement element = file.findElementAt(position); element != null; element = element.getParent()) {
            if (!(element instanceof XmlTag)) continue;
            return (XmlTag)element;
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/sixrr/xrp/tagtoattribute/TagToAttributeHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/sixrr/xrp/tagtoattribute/TagToAttributeHandler", "invoke"));
        }
        if (elements.length == 1 && elements[0] instanceof XmlTag) {
            TagToAttributeHandler.handleDeleteAttribute((XmlTag)elements[0], project);
        }
    }

    private static void handleDeleteAttribute(final XmlTag tag, Project project) {
        TagToAttributeDialog dialog = new TagToAttributeDialog(tag);
        if (!dialog.showAndGet()) {
            return;
        }
        final Context context = dialog.getContext();
        final String attributeName = dialog.getAttributeName();
        final boolean previewUsages = dialog.isPreviewUsages();
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, new Runnable(){

            @Override
            public void run() {
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        TagToAttributeProcessor processor = new TagToAttributeProcessor(tag, attributeName, context, previewUsages);
                        processor.run();
                    }
                };
                Application application = ApplicationManager.getApplication();
                application.runWriteAction(action);
            }
        }, "Replace Tag With Attribute", null);
    }
}

