/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.ui.LayeredIcon;
import icons.SpringBootApiIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootIconProvider
extends IconProvider {
    private static final LayeredIcon ADDITIONAL_JSON_ICON = new LayeredIcon(new Icon[]{SpringBootApiIcons.SpringBoot, AllIcons.Javaee.InheritedAttributeOverlay});

    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        PsiClass psiClass;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/SpringBootIconProvider", "getIcon"));
        }
        if (element instanceof PropertiesFile) {
            if (SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile((PropertiesFile)element)) {
                return SpringBootApiIcons.SpringBoot;
            }
        } else if (element instanceof JsonFile) {
            JsonFile jsonFile = (JsonFile)element;
            String filename = jsonFile.getName();
            if ("additional-spring-configuration-metadata.json".equals(filename)) {
                return ADDITIONAL_JSON_ICON;
            }
        } else if (element instanceof PsiClass && SpringBootApplicationUtil.isSpringApplication((PsiClass)(psiClass = (PsiClass)element))) {
            return new LayeredIcon(new Icon[]{PsiClassImplUtil.getClassIcon((int)flags, (PsiClass)psiClass), SpringBootApiIcons.SpringBoot_Overlay});
        }
        return null;
    }
}

