/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringBootUsagesCollector
extends AbstractApplicationUsagesCollector {
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(final @NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/SpringBootUsagesCollector", "getProjectUsages"));
        }
        HashSet usages = new HashSet();
        ApplicationManager.getApplication().runReadAction(new Runnable((Set)usages){
            final /* synthetic */ Set val$usages;
            {
                this.val$usages = set;
            }

            @Override
            public void run() {
                if (!SpringBootLibraryUtil.hasSpringBootLibrary(project)) {
                    return;
                }
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    Collection annotatedClasses;
                    if (!SpringBootLibraryUtil.hasSpringBootLibrary(module)) continue;
                    GlobalSearchScope scope = module.getModuleScope(false);
                    SpringBootUsagesCollector.recordConfigFileUsages(this.val$usages, project, scope, "application.properties");
                    SpringBootUsagesCollector.recordConfigFileUsages(this.val$usages, project, scope, "bootstrap.properties");
                    SpringBootUsagesCollector.recordConfigFileUsages(this.val$usages, project, scope, "additional-spring-configuration-metadata.json");
                    SpringBootUsagesCollector.recordConfigFileUsages(this.val$usages, project, scope, "application.yml");
                    SpringBootUsagesCollector.recordConfigFileUsages(this.val$usages, project, scope, "application.yaml");
                    SpringBootUsagesCollector.recordConfigFileUsages(this.val$usages, project, scope, "bootstrap.yml");
                    SpringBootUsagesCollector.recordConfigFileUsages(this.val$usages, project, scope, "bootstrap.yaml");
                    PsiClass configurationPropertiesClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.context.properties.ConfigurationProperties");
                    if (configurationPropertiesClass == null || (annotatedClasses = AnnotatedElementsSearch.searchPsiClasses((PsiClass)configurationPropertiesClass, (SearchScope)scope).findAll()).isEmpty()) continue;
                    this.val$usages.add(new UsageDescriptor("ConfigurationProperties_" + annotatedClasses.size(), 1));
                }
                List springBootRunConfigurations = RunManager.getInstance((Project)project).getConfigurationsList((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
                this.val$usages.add(new UsageDescriptor("RunConfigsPerProject_" + springBootRunConfigurations.size(), 1));
            }
        });
        HashSet hashSet = usages;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/SpringBootUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)"Spring Boot");
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/SpringBootUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }

    private static void recordConfigFileUsages(Set<UsageDescriptor> usages, Project project, GlobalSearchScope scope, String configFileName) {
        PsiFile[] files = FilenameIndex.getFilesByName((Project)project, (String)configFileName, (GlobalSearchScope)scope);
        if (files.length > 0) {
            usages.add(new UsageDescriptor(configFileName, files.length));
        }
    }
}

