/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.refactoring.rename.naming.NameSuggester;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.profiles.SpringProfile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootProfileConfigFileAutomaticRenamerFactory
implements AutomaticRenamerFactory {
    private static final ExtensionPointName<Contributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.spring.boot.profileRenameConfigFileContributor");

    public boolean isApplicable(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/SpringBootProfileConfigFileAutomaticRenamerFactory", "isApplicable"));
        }
        return element instanceof SpringProfile && SpringBootLibraryUtil.hasSpringBootLibrary(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    @Nullable
    public String getOptionName() {
        return "Spring Boot configuration files";
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }

    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        String oldName = ((SpringProfile)element).getName();
        String configFileSuffix = "-" + oldName;
        SmartList configFiles = new SmartList();
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            configFiles.addAll(contributor.getConfigFiles(element, configFileSuffix));
        }
        return new MyAutomaticRenamer((List)configFiles, oldName, newName);
    }

    private static class MyAutomaticRenamer
    extends AutomaticRenamer {
        private final String myOldName;

        private MyAutomaticRenamer(List<PsiFile> configFiles, String oldName, String newName) {
            for (PsiFile file : configFiles) {
                this.myElements.add(file);
                this.suggestAllNames(oldName, newName);
            }
            this.myOldName = oldName;
        }

        public String getDialogTitle() {
            return "Rename Spring Boot Configuration Files";
        }

        public String getDialogDescription() {
            return "Rename Spring Boot configuration files matching Spring Profile '" + this.myOldName + "'";
        }

        public String entityName() {
            return "File";
        }

        protected String suggestNameForElement(PsiNamedElement element, NameSuggester suggester, String newClassName, String oldClassName) {
            String name = element.getName();
            assert (name != null) : element;
            return StringUtil.replace((String)name, (String)("-" + oldClassName), (String)("-" + newClassName));
        }

        public boolean isSelectedByDefault() {
            return true;
        }

        public boolean allowChangeSuggestedName() {
            return false;
        }
    }

    public static abstract class Contributor {
        public abstract List<PsiFile> getConfigFiles(PsiElement var1, String var2);
    }
}

