/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.hints.BeanReferenceProvider;
import com.intellij.spring.boot.application.config.hints.EncodingReferenceProvider;
import com.intellij.spring.boot.application.config.hints.EnumReferenceProvider;
import com.intellij.spring.boot.application.config.hints.FloatReferenceProvider;
import com.intellij.spring.boot.application.config.hints.IntegerReferenceProvider;
import com.intellij.spring.boot.application.config.hints.LoggerNameReferenceProvider;
import com.intellij.spring.boot.application.config.hints.LongReferenceProvider;
import com.intellij.spring.boot.application.config.hints.MultiStaticValuesReferenceProvider;
import com.intellij.spring.boot.application.config.hints.RegExReferenceProvider;
import com.intellij.spring.boot.application.config.hints.ResourceReferenceProvider;
import com.intellij.spring.boot.application.config.hints.SpringBootHintRegistryInfo;
import com.intellij.spring.boot.application.config.hints.SpringBootHintRegistryKey;
import com.intellij.spring.boot.application.config.hints.StaticValuesReferenceProvider;
import com.intellij.spring.boot.application.config.hints.ValueHintReferenceProvider;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootValueProvider;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.converters.PatternFileReferenceSet;
import com.intellij.spring.profiles.SpringProfilesReferenceProvider;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xml.util.HtmlUtil;
import gnu.trove.THashMap;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootHintReferencesProviderImpl
extends SpringBootHintReferencesProvider {
    private static final String STATIC = "static";
    private static final String ENUM_VALUES = "enumValues";
    private static final String REGEX = "regex";
    private static final String RESOURCE = "resource";
    private static final String PATH_PATTERN = "pathPattern";
    private static final String SPRING_PROFILE_NAME = SpringBootValueProvider.SPRING_PROFILE_NAME.getId();
    private final PsiReferenceProvider myDummyProvider = new PsiReferenceProvider(){

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$1", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$1", "getReferencesByElement"));
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{PsiReferenceBase.createSelfReference((PsiElement)element, (PsiElement)element)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$1", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
    };
    private final StaticValuesReferenceProvider myLocaleProvider = new StaticValuesReferenceProvider(true, true, (String[])ContainerUtil.map2Array((Object[])Locale.getAvailableLocales(), String.class, (Function)new Function<Locale, String>(){

        public String fun(Locale locale) {
            String country = locale.getCountry();
            String language = locale.getLanguage();
            return country.isEmpty() ? language : language + "_" + country;
        }
    }));
    private final StaticValuesReferenceProvider myContentTypeProvider = new StaticValuesReferenceProvider(true, true, HtmlUtil.CONTENT_TYPES);
    private final StaticValuesReferenceProvider myContentTypeMultiValueProvider = new MultiStaticValuesReferenceProvider(true, true, HtmlUtil.CONTENT_TYPES);
    private final EncodingReferenceProvider myEncodingProvider = new EncodingReferenceProvider();
    private final SpringProfilesReferenceProvider mySpringProfileProvider = new SpringProfilesReferenceProvider(){

        protected String getStringValue(PsiElement element) {
            return element.getText();
        }

        protected boolean isDefinition() {
            return false;
        }
    };
    private final Map<String, String> myExplicitMappings = new THashMap();
    private final Map<String, PsiReferenceProvider> myExplicitProviders = new THashMap();
    private final Map<String, PsiReferenceProvider> myBuiltinProviders = new THashMap();
    private final Map<String, PsiReferenceProvider> myByTypeProviders = ContainerUtil.immutableMapBuilder().put((Object)"java.lang.Boolean", (Object)new StaticValuesReferenceProvider(false, false, "true", "false")).put((Object)"java.lang.Integer", (Object)new IntegerReferenceProvider()).put((Object)"java.lang.Long", (Object)new LongReferenceProvider()).put((Object)"java.lang.Float", (Object)new FloatReferenceProvider()).put((Object)"java.nio.charset.Charset", (Object)this.myEncodingProvider).put((Object)"org.springframework.util.MimeType", (Object)this.myContentTypeProvider).put((Object)"org.springframework.core.io.Resource", (Object)new ResourceReferenceProvider()).put((Object)"java.util.Locale", (Object)this.myLocaleProvider).build();

    protected SpringBootHintReferencesProviderImpl() {
        this.myBuiltinProviders.put(SPRING_PROFILE_NAME, (PsiReferenceProvider)this.mySpringProfileProvider);
        this.myBuiltinProviders.put(RESOURCE, new ResourceReferenceProvider());
        this.myBuiltinProviders.put(PATH_PATTERN, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$4", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$4", "getReferencesByElement"));
                }
                FileReference[] fileReferenceArray = new PatternFileReferenceSet(element.getText(), element, 0).getAllReferences();
                if (fileReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl$4", "getReferencesByElement"));
                }
                return fileReferenceArray;
            }
        });
        this.loadExplicitMappings();
    }

    private void loadExplicitMappings() {
        URL url = SpringBootHintReferencesProviderImpl.class.getResource("spring-boot-hint-registry.xml");
        SpringBootHintRegistryInfo info = (SpringBootHintRegistryInfo)XmlSerializer.deserialize((URL)url, SpringBootHintRegistryInfo.class);
        for (SpringBootHintRegistryKey key : ((SpringBootHintRegistryInfo)ObjectUtils.assertNotNull((Object)info)).myKeys) {
            String providerId = key.myProvider;
            if (providerId.equals(STATIC) || providerId.equals(ENUM_VALUES)) {
                this.myExplicitProviders.put(key.myId, SpringBootHintReferencesProviderImpl.createStaticOrEnumReferenceProvider(key));
                continue;
            }
            if (providerId.equals(SpringBootValueProvider.SPRING_BEAN_REFERENCE.getId())) {
                this.myExplicitProviders.put(key.myId, SpringBootHintReferencesProviderImpl.createBeanReferenceProvider(key.myValue));
                continue;
            }
            if (providerId.equals(SpringBootValueProvider.CLASS_REFERENCE.getId())) {
                this.myExplicitProviders.put(key.myId, (PsiReferenceProvider)SpringBootHintReferencesProviderImpl.createClassReferenceProvider(key.myValue, key.myAllowOtherValues, true));
                continue;
            }
            if (providerId.equals(REGEX)) {
                this.myExplicitProviders.put(key.myId, new RegExReferenceProvider(key.myValue));
                continue;
            }
            if (providerId.equals(RESOURCE) || providerId.equals(PATH_PATTERN) || providerId.equals(SPRING_PROFILE_NAME)) {
                this.myExplicitMappings.put(key.myId, providerId);
                continue;
            }
            throw new IllegalArgumentException(providerId);
        }
    }

    @NotNull
    public PsiReference[] getReferences(Module module, SpringBootApplicationMetaConfigKey configKey, SpringBootHintReferencesProvider.ItemHintType itemHintType, PsiElement element, ProcessingContext context) {
        if (!SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0)) {
            PsiReference[] psiReferenceArray = this.getFallbackProvider(configKey).getReferencesByElement(element, context);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl", "getReferences"));
            }
            return psiReferenceArray;
        }
        if (configKey.getItemHint() != SpringBootApplicationMetaConfigKey.ItemHint.NONE) {
            PsiReference[] psiReferenceArray = this.getItemHintReferences(configKey, itemHintType, element, context);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl", "getReferences"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = this.getByTypeOrExplicitProvider(configKey).getReferencesByElement(element, context);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @NotNull
    private PsiReferenceProvider getByTypeOrExplicitProvider(SpringBootApplicationMetaConfigKey configKey) {
        PsiReferenceProvider byTypeProvider = this.getByTypeProvider(configKey);
        if (byTypeProvider != null) {
            PsiReferenceProvider psiReferenceProvider = byTypeProvider;
            if (psiReferenceProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl", "getByTypeOrExplicitProvider"));
            }
            return psiReferenceProvider;
        }
        PsiReferenceProvider explicitValuesProvider = this.getExplicitProvider(configKey);
        if (explicitValuesProvider != null) {
            PsiReferenceProvider psiReferenceProvider = explicitValuesProvider;
            if (psiReferenceProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl", "getByTypeOrExplicitProvider"));
            }
            return psiReferenceProvider;
        }
        PsiReferenceProvider psiReferenceProvider = this.myDummyProvider;
        if (psiReferenceProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl", "getByTypeOrExplicitProvider"));
        }
        return psiReferenceProvider;
    }

    @NotNull
    private PsiReference[] getItemHintReferences(SpringBootApplicationMetaConfigKey configKey, SpringBootHintReferencesProvider.ItemHintType itemHintType, PsiElement element, ProcessingContext context) {
        List<PsiReferenceProvider> providers = this.getItemHintProviders(element, configKey, itemHintType);
        if (providers.isEmpty()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl", "getItemHintReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] allReferences = new PsiReference[]{};
        for (PsiReferenceProvider provider : providers) {
            allReferences = (PsiReference[])ArrayUtil.mergeArrays((Object[])allReferences, (Object[])provider.getReferencesByElement(element, context), (ArrayFactory)PsiReference.ARRAY_FACTORY);
        }
        if (allReferences == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl", "getItemHintReferences"));
        }
        return allReferences;
    }

    private List<PsiReferenceProvider> getItemHintProviders(PsiElement element, SpringBootApplicationMetaConfigKey configKey, SpringBootHintReferencesProvider.ItemHintType itemHintType) {
        SpringBootApplicationMetaConfigKey.ItemHint keyOrValueHint = itemHintType == SpringBootHintReferencesProvider.ItemHintType.VALUE ? configKey.getItemHint() : configKey.getKeyItemHint();
        String prefix = itemHintType == SpringBootHintReferencesProvider.ItemHintType.VALUE ? "" : configKey.getName() + ".";
        List valueProviders = keyOrValueHint.getValueProviders();
        boolean hasAnyProvider = ContainerUtil.exists((Iterable)valueProviders, (Condition)new Condition<SpringBootApplicationMetaConfigKey.ValueProvider>(){

            public boolean value(SpringBootApplicationMetaConfigKey.ValueProvider provider) {
                SpringBootValueProvider byId = SpringBootValueProvider.findById(provider.getName());
                return byId == SpringBootValueProvider.ANY;
            }
        });
        SmartList providers = new SmartList();
        List valueHints = keyOrValueHint.getValueHints();
        if (!valueHints.isEmpty()) {
            providers.add(new ValueHintReferenceProvider(configKey, valueHints, prefix, hasAnyProvider));
        }
        if (valueProviders.isEmpty()) {
            return providers;
        }
        SpringBootValueProvider valueProvider = null;
        Map parameters = null;
        for (SpringBootApplicationMetaConfigKey.ValueProvider provider : valueProviders) {
            valueProvider = SpringBootValueProvider.findById(provider.getName());
            if (valueProvider == null) continue;
            parameters = provider.getParameters();
            break;
        }
        if (valueProvider == null) {
            return providers;
        }
        if (itemHintType == SpringBootHintReferencesProvider.ItemHintType.VALUE) {
            String target;
            if (valueProvider == SpringBootValueProvider.CLASS_REFERENCE) {
                target = (String)parameters.get("target");
                String concreteParameter = (String)parameters.get("concrete");
                Boolean concrete = concreteParameter == null ? Boolean.TRUE : Boolean.valueOf(concreteParameter);
                providers.add(SpringBootHintReferencesProviderImpl.createClassReferenceProvider(target, false, concrete));
            } else if (valueProvider == SpringBootValueProvider.SPRING_PROFILE_NAME) {
                providers.add(this.mySpringProfileProvider);
            } else if (valueProvider == SpringBootValueProvider.SPRING_BEAN_REFERENCE) {
                target = (String)parameters.get("target");
                providers.add(SpringBootHintReferencesProviderImpl.createBeanReferenceProvider(target));
            } else if (valueProvider == SpringBootValueProvider.HANDLE_AS && parameters.containsKey("target")) {
                target = (String)parameters.get("target");
                PsiReferenceProvider byTypeProvider = this.myByTypeProviders.get(target);
                if (byTypeProvider != null) {
                    providers.add(byTypeProvider);
                } else {
                    Project project = element.getProject();
                    PsiClass enumClass = JavaPsiFacade.getInstance((Project)project).findClass(target, GlobalSearchScope.allScope((Project)project));
                    if (enumClass != null && enumClass.isEnum()) {
                        providers.add(new EnumReferenceProvider(enumClass));
                    }
                }
            }
        }
        if (valueProvider == SpringBootValueProvider.LOGGER_NAME) {
            providers.add(new LoggerNameReferenceProvider(prefix));
        }
        return providers;
    }

    @Nullable
    private PsiReferenceProvider getByTypeProvider(SpringBootApplicationMetaConfigKey configKey) {
        PsiClass typeClass = configKey.getEffectiveValueClass();
        if (typeClass == null) {
            return null;
        }
        if (typeClass.isEnum()) {
            return new EnumReferenceProvider(typeClass);
        }
        String typeFqn = typeClass.getQualifiedName();
        if (typeFqn == null) {
            return null;
        }
        if ("java.lang.Class".equals(typeFqn)) {
            PsiType type = configKey.getType();
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiType[] parameters = ((PsiClassType)type).getParameters();
            if (parameters.length != 1) {
                return null;
            }
            PsiType typeParameter = parameters[0];
            if (!(typeParameter instanceof PsiWildcardType)) {
                return null;
            }
            PsiWildcardType parameter = (PsiWildcardType)typeParameter;
            return SpringBootHintReferencesProviderImpl.createClassReferenceProvider(parameter.getExtendsBound().getCanonicalText(), false, Boolean.TRUE);
        }
        return this.myByTypeProviders.get(typeFqn);
    }

    @Nullable
    private PsiReferenceProvider getExplicitProvider(SpringBootApplicationMetaConfigKey configKey) {
        PsiReferenceProvider byKey = this.myExplicitProviders.get(configKey.getName());
        if (byKey != null) {
            return byKey;
        }
        String configKeyName = configKey.getName();
        String explicitProviderId = this.myExplicitMappings.get(configKeyName);
        if (explicitProviderId != null) {
            PsiReferenceProvider provider = this.myBuiltinProviders.get(explicitProviderId);
            if (provider == null) {
                throw new IllegalStateException("provider id '" + explicitProviderId + "' not found, configured for " + configKey);
            }
            return provider;
        }
        return null;
    }

    private PsiReferenceProvider getFallbackProvider(SpringBootApplicationMetaConfigKey configKey) {
        PsiReferenceProvider byTypeProvider = this.getByTypeProvider(configKey);
        if (byTypeProvider != null) {
            return byTypeProvider;
        }
        PsiReferenceProvider explicitReferenceProvider = this.getExplicitProvider(configKey);
        if (explicitReferenceProvider != null) {
            return explicitReferenceProvider;
        }
        String configKeyName = configKey.getName();
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"encoding") || StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"charset")) {
            return this.myEncodingProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"content-type")) {
            return this.myContentTypeProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"mime-types")) {
            return this.myContentTypeMultiValueProvider;
        }
        if (StringUtil.endsWith((CharSequence)configKeyName, (CharSequence)"locale")) {
            return this.myLocaleProvider;
        }
        return this.myDummyProvider;
    }

    private static PsiReferenceProvider createStaticOrEnumReferenceProvider(SpringBootHintRegistryKey key) {
        String[] values = (String[])ContainerUtil.map2Array((Collection)StringUtil.split((String)key.myValue, (String)","), String.class, (Function)StringUtil.TRIMMER);
        return new StaticValuesReferenceProvider(key.myAllowOtherValues, key.myProvider.equals(ENUM_VALUES), values);
    }

    @NotNull
    private static JavaClassReferenceProvider createClassReferenceProvider(String baseClass, boolean allowOtherValues, Boolean concrete) {
        JavaClassReferenceProvider provider = new JavaClassReferenceProvider();
        if (StringUtil.isNotEmpty((String)baseClass)) {
            provider.setOption(JavaClassReferenceProvider.EXTEND_CLASS_NAMES, (Object)new String[]{baseClass});
        }
        if (allowOtherValues) {
            provider.setSoft(true);
        }
        if (concrete.booleanValue()) {
            provider.setOption(JavaClassReferenceProvider.CONCRETE, (Object)Boolean.TRUE);
        }
        provider.setOption(JavaClassReferenceProvider.RESOLVE_QUALIFIED_CLASS_NAME, (Object)Boolean.TRUE);
        provider.setOption(JavaClassReferenceProvider.ADVANCED_RESOLVE, (Object)Boolean.TRUE);
        JavaClassReferenceProvider javaClassReferenceProvider = provider;
        if (javaClassReferenceProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl", "createClassReferenceProvider"));
        }
        return javaClassReferenceProvider;
    }

    @NotNull
    private static PsiReferenceProvider createBeanReferenceProvider(@Nullable String baseClass) {
        BeanReferenceProvider beanReferenceProvider = new BeanReferenceProvider(baseClass);
        if (beanReferenceProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/SpringBootHintReferencesProviderImpl", "createBeanReferenceProvider"));
        }
        return beanReferenceProvider;
    }
}

