/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringBootApiIcons;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ValueHintReferenceProvider
extends PsiReferenceProvider {
    private final List<SpringBootApplicationMetaConfigKey.ValueHint> myValueHints;
    private final SpringBootApplicationMetaConfigKey myConfigKey;
    private final int myStartInElement;
    private final boolean myAllowOtherValues;

    ValueHintReferenceProvider(SpringBootApplicationMetaConfigKey configKey, List<SpringBootApplicationMetaConfigKey.ValueHint> valueHints, String prefix, boolean allowOtherValues) {
        this.myConfigKey = configKey;
        this.myValueHints = valueHints;
        this.myStartInElement = prefix.length();
        this.myAllowOtherValues = allowOtherValues;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/config/hints/ValueHintReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/config/hints/ValueHintReferenceProvider", "getReferencesByElement"));
        }
        TextRange valueRange = ElementManipulators.getValueTextRange((PsiElement)element);
        if (valueRange.getLength() < this.myStartInElement) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/ValueHintReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange shiftTextRange = valueRange.shiftRight(this.myStartInElement).grown(-this.myStartInElement);
        PsiReference[] psiReferenceArray = new PsiReference[]{new HintReferenceBase(element, shiftTextRange){

            public boolean isSoft() {
                return ValueHintReferenceProvider.this.myAllowOtherValues;
            }

            @Override
            @Nullable
            protected PsiElement doResolve() {
                final String value = this.getValue();
                boolean isValid = ContainerUtil.exists((Iterable)ValueHintReferenceProvider.this.myValueHints, (Condition)new Condition<SpringBootApplicationMetaConfigKey.ValueHint>(){

                    public boolean value(SpringBootApplicationMetaConfigKey.ValueHint hint) {
                        return hint.getValue().equals(value);
                    }
                });
                return isValid ? this.getElement() : null;
            }

            @NotNull
            public Object[] getVariants() {
                Object[] objectArray = ContainerUtil.map2Array((Collection)ValueHintReferenceProvider.this.myValueHints, LookupElementBuilder.class, (Function)new Function<SpringBootApplicationMetaConfigKey.ValueHint, LookupElementBuilder>(){

                    public LookupElementBuilder fun(SpringBootApplicationMetaConfigKey.ValueHint hint) {
                        LookupElementBuilder builder = LookupElementBuilder.create((String)hint.getValue()).withBoldness(hint.getValue().equals(ValueHintReferenceProvider.this.myConfigKey.getDefaultValue()));
                        String shortDescriptionText = hint.getDescriptionText().getShortText();
                        if (StringUtil.isNotEmpty((String)shortDescriptionText)) {
                            builder = builder.appendTailText(" (" + shortDescriptionText + ")", true);
                        }
                        return builder.withIcon(SpringBootApiIcons.SpringBoot);
                    }
                });
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/ValueHintReferenceProvider$1", "getVariants"));
                }
                return objectArray;
            }

            @Override
            @NotNull
            public String getUnresolvedMessagePattern() {
                String[] valueHintNames = (String[])ContainerUtil.map2Array((Collection)ValueHintReferenceProvider.this.myValueHints, String.class, (Function)new Function<SpringBootApplicationMetaConfigKey.ValueHint, String>(){

                    public String fun(SpringBootApplicationMetaConfigKey.ValueHint hint) {
                        return "''" + hint.getValue() + "''";
                    }
                });
                String string = "Invalid value ''{0}'', must be one of " + StringUtil.join((String[])valueHintNames, (String)"|");
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/ValueHintReferenceProvider$1", "getUnresolvedMessagePattern"));
                }
                return string;
            }
        }};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/config/hints/ValueHintReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }
}

