/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.metadata.ConfigKeyDeclarationPsiElement;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigKeyDocumentationProviderBase
extends AbstractDocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element instanceof ConfigKeyDeclarationPsiElement) {
            ConfigKeyDeclarationPsiElement configKey = (ConfigKeyDeclarationPsiElement)element;
            return "<b>" + configKey.getName() + "</b>" + " [" + XmlUtil.escape((String)configKey.getLibraryName()) + "]\n" + XmlUtil.escape((String)configKey.getLocationString());
        }
        return super.getQuickNavigateInfo(element, originalElement);
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof ConfigKeyDeclarationPsiElement) {
            ConfigKeyDeclarationPsiElement configKeyDeclarationPsiElement = (ConfigKeyDeclarationPsiElement)element;
            String keyName = configKeyDeclarationPsiElement.getName();
            return ConfigKeyDocumentationProviderBase.getDocumentationTextForKey(originalElement, keyName);
        }
        return this.generateDocForProperty(element);
    }

    @Nullable
    protected abstract String getConfigKey(PsiElement var1);

    private String generateDocForProperty(PsiElement element) {
        String configKey = this.getConfigKey(element);
        if (configKey == null) {
            return ConfigKeyDocumentationProviderBase.generateDocForBeanProperty(element);
        }
        return ConfigKeyDocumentationProviderBase.getDocumentationTextForKey(element, configKey);
    }

    @Nullable
    private static String generateDocForBeanProperty(PsiElement element) {
        if (!(element instanceof BeanPropertyElement)) {
            return null;
        }
        BeanPropertyElement property = (BeanPropertyElement)element;
        PsiElement originalElement = ConfigKeyDocumentationProviderBase.getOriginalDocumentationElement((PsiElement)property.getMethod());
        return ConfigKeyDocumentationProviderBase.getOriginalDocForPsiMember(originalElement);
    }

    @Nullable
    private static String getDocumentationTextForKey(@Nullable PsiElement originalElement, @Nullable String keyName) {
        PsiElement docElement;
        String originalDoc;
        String defaultValue;
        if (originalElement == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        SpringBootApplicationMetaConfigKey key = SpringBootApplicationMetaConfigKeyManager.getInstance().findApplicationMetaConfigKey(module, keyName);
        if (key == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<b>").append(keyName).append("</b><br/>");
        JavaDocInfoGenerator.generateType((StringBuilder)sb, (PsiType)key.getType(), (PsiElement)originalElement, (boolean)true);
        sb.append("<br/>");
        if (key.isDeprecated()) {
            String replacement;
            sb.append("<br/><b><em>Deprecated</em></b>");
            SpringBootApplicationMetaConfigKey.Deprecation deprecation = key.getDeprecation();
            String reasonText = deprecation.getReason().getFullText();
            if (StringUtil.isNotEmpty((String)reasonText)) {
                sb.append("  ").append(reasonText);
            }
            if ((replacement = deprecation.getReplacement()) != null) {
                sb.append("<br/><em>See:</em> ").append(replacement);
            }
            sb.append("<br/>");
        }
        if ((defaultValue = key.getDefaultValue()) != null) {
            sb.append("<br/>Default: <em>").append(defaultValue).append("</em>");
        }
        sb.append("<br/><br/>");
        SpringBootApplicationMetaConfigKey.ItemHint itemHint = key.getItemHint();
        String fullDescription = key.getDescriptionText().getFullText();
        boolean hasDescription = StringUtil.isNotEmpty((String)fullDescription);
        if (hasDescription) {
            sb.append(fullDescription);
        }
        List valueHints = itemHint.getValueHints();
        ConfigKeyDocumentationProviderBase.appendValueDescriptionTable(sb, valueHints, new Function<SpringBootApplicationMetaConfigKey.ValueHint, String>(){

            public String fun(SpringBootApplicationMetaConfigKey.ValueHint hint) {
                return hint.getValue();
            }
        }, new Function<SpringBootApplicationMetaConfigKey.ValueHint, String>(){

            public String fun(SpringBootApplicationMetaConfigKey.ValueHint hint) {
                return hint.getDescriptionText().getFullText();
            }
        });
        PsiClass typeClass = PsiTypesUtil.getPsiClass((PsiType)key.getType());
        if (typeClass != null && typeClass.isEnum()) {
            List enumConstants = ContainerUtil.findAll((Object[])typeClass.getFields(), (Condition)Conditions.instanceOf(PsiEnumConstant.class));
            ConfigKeyDocumentationProviderBase.appendValueDescriptionTable(sb, enumConstants, new Function<PsiField, String>(){

                public String fun(PsiField field) {
                    return field.getName().toLowerCase(Locale.US);
                }
            }, new Function<PsiField, String>(){

                public String fun(PsiField field) {
                    PsiElement navigationElement = field.getNavigationElement();
                    if (!(navigationElement instanceof PsiDocCommentOwner)) {
                        return "";
                    }
                    PsiDocComment comment = ((PsiDocCommentOwner)navigationElement).getDocComment();
                    if (comment == null) {
                        return "";
                    }
                    StringBuilder doc = new StringBuilder();
                    for (PsiElement element : comment.getDescriptionElements()) {
                        doc.append(StringUtil.replaceUnicodeEscapeSequences((String)element.getText()));
                    }
                    return doc.toString();
                }
            });
        }
        if (StringUtil.isEmpty((String)fullDescription) && StringUtil.isNotEmpty((String)(originalDoc = ConfigKeyDocumentationProviderBase.getOriginalDocForPsiMember(docElement = ConfigKeyDocumentationProviderBase.getOriginalDocumentationElement(key.getDeclaration().getNavigationElement()))))) {
            sb.append("<em>Original documentation:</em><br/>");
            sb.append(originalDoc);
        }
        return sb.toString();
    }

    private static <V> void appendValueDescriptionTable(StringBuilder sb, List<V> elements, Function<V, String> valueFunction, Function<V, String> descriptionFunction) {
        if (elements.isEmpty()) {
            return;
        }
        sb.append("<br/><br/>");
        sb.append("<table cellpadding=\"5\">");
        sb.append("<tr>").append("<td><em>Value</em></td><td><em>Description</em></td>").append("</tr>");
        for (V value : elements) {
            sb.append("<tr>");
            sb.append("<td><pre>").append((String)valueFunction.fun(value)).append("</pre></td>");
            sb.append("<td>").append((String)descriptionFunction.fun(value)).append("</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
    }

    @Nullable
    private static String getOriginalDocForPsiMember(PsiElement docElement) {
        if (!(docElement instanceof PsiMember)) {
            return null;
        }
        DocumentationProvider provider = DocumentationManager.getProviderFromElement((PsiElement)docElement);
        return provider.generateDoc(docElement, docElement);
    }

    @NotNull
    private static PsiElement getOriginalDocumentationElement(PsiElement navigationElement) {
        PsiField field;
        if (navigationElement instanceof PsiMethod && (field = PropertyUtil.findPropertyFieldByMember((PsiMember)((PsiMember)navigationElement))) != null && field.getDocComment() != null) {
            PsiField psiField = field;
            if (psiField == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/ConfigKeyDocumentationProviderBase", "getOriginalDocumentationElement"));
            }
            return psiField;
        }
        PsiElement psiElement = navigationElement;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/ConfigKeyDocumentationProviderBase", "getOriginalDocumentationElement"));
        }
        return psiElement;
    }
}

