/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaConfigKeyReference
extends PsiReferenceBase.Poly<PsiElement> {
    private static final Function<SpringBootApplicationMetaConfigKey, PsiElement> CONFIG_KEY_DECLARATION = new Function<SpringBootApplicationMetaConfigKey, PsiElement>(){

        public PsiElement fun(SpringBootApplicationMetaConfigKey key) {
            return key.getDeclaration();
        }
    };
    private final NotNullLazyValue<List<SpringBootApplicationMetaConfigKey>> myKeys;

    protected MetaConfigKeyReference(PsiElement element, final String keyText) {
        super(element);
        this.myKeys = new AtomicNotNullLazyValue<List<SpringBootApplicationMetaConfigKey>>(){

            @NotNull
            protected List<SpringBootApplicationMetaConfigKey> compute() {
                List<SpringBootApplicationMetaConfigKey> list = MetaConfigKeyReference.this.getAllKeys(keyText);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference$2", "compute"));
                }
                return list;
            }
        };
    }

    @NotNull
    protected List<SpringBootApplicationMetaConfigKey> getAllKeys(String keyText) {
        List list = SpringBootApplicationMetaConfigKeyManager.getInstance().findAllApplicationMetaConfigKeys(this.getElement(), keyText);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference", "getAllKeys"));
        }
        return list;
    }

    @Nullable
    public static SpringBootApplicationMetaConfigKey getResolvedMetaConfigKey(@NotNull PsiElement keyElement) {
        if (keyElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyElement", "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference", "getResolvedMetaConfigKey"));
        }
        for (PsiReference reference : keyElement.getReferences()) {
            if (!(reference instanceof MetaConfigKeyReference)) continue;
            return ((MetaConfigKeyReference)reference).getResolvedKey();
        }
        return null;
    }

    @Nullable
    protected SpringBootApplicationMetaConfigKey getResolvedKey() {
        return (SpringBootApplicationMetaConfigKey)ContainerUtil.getFirstItem((List)((List)this.myKeys.getValue()));
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)ContainerUtil.map((Collection)((Collection)this.myKeys.getValue()), CONFIG_KEY_DECLARATION));
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/MetaConfigKeyReference", "multiResolve"));
        }
        return resolveResultArray;
    }
}

