/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata.additional;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.spring.boot.application.metadata.SpringBootValueProvider;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigMetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.additional.SpringBootAdditionalConfigValueProviderReference;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootAdditionalConfigInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection", "checkFile"));
        }
        if (!(file instanceof JsonFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (!file.getName().equals("additional-spring-configuration-metadata.json")) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (!SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        JsonFile jsonFile = (JsonFile)file;
        JsonValue topValue = jsonFile.getTopLevelValue();
        if (topValue == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        final ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        boolean isAtLeast13 = SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_3_0);
        PropertyVisitor visitor = new PropertyVisitor(holder, isAtLeast13);
        topValue.acceptChildren((PsiElementVisitor)visitor);
        SpringBootAdditionalConfigInspection.visitTopLevelValues(topValue, (Condition<JsonProperty>)Conditions.alwaysTrue(), new NotNullProducer<JsonElementVisitor>(){

            @NotNull
            public JsonElementVisitor produce() {
                NameAttributeVisitor nameAttributeVisitor = new NameAttributeVisitor(holder);
                if (nameAttributeVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$1", "produce"));
                }
                return nameAttributeVisitor;
            }
        });
        SpringBootAdditionalConfigInspection.visitTopLevelValues(topValue, new Condition<JsonProperty>(){

            public boolean value(JsonProperty jsonProperty) {
                return jsonProperty.getName().equals("hints");
            }
        }, new NotNullProducer<JsonElementVisitor>(){

            @NotNull
            public JsonElementVisitor produce() {
                HintsVisitor hintsVisitor = new HintsVisitor(holder);
                if (hintsVisitor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$3", "produce"));
                }
                return hintsVisitor;
            }
        });
        return holder.getResultsArray();
    }

    private static void visitTopLevelValues(JsonValue topValue, Condition<JsonProperty> runVisitorCondition, NotNullProducer<JsonElementVisitor> visitorProducer) {
        if (!(topValue instanceof JsonObject)) {
            return;
        }
        JsonObject jsonObject = (JsonObject)topValue;
        for (JsonProperty property : jsonObject.getPropertyList()) {
            JsonValue propertyValue = property.getValue();
            if (!(propertyValue instanceof JsonArray) || !runVisitorCondition.value((Object)property)) continue;
            JsonElementVisitor elementVisitor = (JsonElementVisitor)visitorProducer.produce();
            propertyValue.acceptChildren((PsiElementVisitor)elementVisitor);
        }
    }

    @NotNull
    private static String getStringValue(JsonStringLiteral value) {
        String string = JsonPsiUtil.stripQuotes((String)value.getValue());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection", "getStringValue"));
        }
        return string;
    }

    private static class HintsVisitor
    extends JsonRecursiveElementVisitor {
        private final ProblemsHolder myHolder;

        private HintsVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitProperty(@NotNull JsonProperty jsonProperty) {
            JsonObject provider;
            JsonArray providersArray;
            JsonValue providersValue;
            if (jsonProperty == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonProperty", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$HintsVisitor", "visitProperty"));
            }
            if (jsonProperty.getName().equals("providers")) {
                providersValue = jsonProperty.getValue();
                providersArray = (JsonArray)ObjectUtils.tryCast((Object)providersValue, JsonArray.class);
                if (providersArray == null) {
                    return;
                }
                for (JsonValue value : providersArray.getValueList()) {
                    provider = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
                    if (provider == null) continue;
                    JsonProperty providerName = provider.findProperty("name");
                    if (providerName == null) {
                        this.myHolder.registerProblem((PsiElement)provider, "Missing required 'name'", new LocalQuickFix[0]);
                        continue;
                    }
                    JsonValue providerNameValue = providerName.getValue();
                    if (!(providerNameValue instanceof JsonStringLiteral)) continue;
                    SpringBootValueProvider valueProvider = null;
                    for (PsiReference reference : providerNameValue.getReferences()) {
                        if (!(reference instanceof SpringBootAdditionalConfigValueProviderReference)) continue;
                        valueProvider = ((SpringBootAdditionalConfigValueProviderReference)reference).getValueProvider();
                        break;
                    }
                    if (valueProvider == null || !valueProvider.hasRequiredParameters()) continue;
                    JsonProperty parameters = provider.findProperty("parameters");
                    JsonObject parametersValue = parameters == null ? null : (JsonObject)ObjectUtils.tryCast((Object)parameters.getValue(), JsonObject.class);
                    SmartList missingParameters = new SmartList();
                    for (SpringBootValueProvider.Parameter parameter : valueProvider.getParameters()) {
                        if (!parameter.isRequired() || parametersValue != null && parametersValue.findProperty(parameter.getName()) != null) continue;
                        missingParameters.add(parameter.getName());
                    }
                    if (missingParameters.isEmpty()) continue;
                    this.myHolder.registerProblem((PsiElement)providerNameValue, ElementManipulators.getValueTextRange((PsiElement)providerNameValue), "Missing required " + StringUtil.pluralize((String)"parameter", (int)missingParameters.size()) + ": " + StringUtil.join((Collection)missingParameters, (String)", "), new LocalQuickFix[0]);
                }
            }
            if (jsonProperty.getName().equals("values")) {
                providersValue = jsonProperty.getValue();
                providersArray = (JsonArray)ObjectUtils.tryCast((Object)providersValue, JsonArray.class);
                if (providersArray == null) {
                    return;
                }
                for (JsonValue value : providersArray.getValueList()) {
                    JsonProperty valueProperty;
                    provider = (JsonObject)ObjectUtils.tryCast((Object)value, JsonObject.class);
                    if (provider == null || (valueProperty = provider.findProperty("value")) != null) continue;
                    this.myHolder.registerProblem((PsiElement)provider, "Missing required 'value'", new LocalQuickFix[0]);
                }
            }
        }
    }

    private static class NameAttributeVisitor
    extends JsonRecursiveElementVisitor {
        private final ProblemsHolder myHolder;
        private final Map<String, JsonValue> myExistingNames = new HashMap<String, JsonValue>();

        private NameAttributeVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitObject(@NotNull JsonObject jsonObject) {
            if (jsonObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonObject", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$NameAttributeVisitor", "visitObject"));
            }
            if (jsonObject.findProperty("name") == null) {
                this.myHolder.registerProblem((PsiElement)jsonObject, "Missing required 'name'", new LocalQuickFix[0]);
            }
            super.visitObject(jsonObject);
        }

        public void visitProperty(@NotNull JsonProperty jsonProperty) {
            if (jsonProperty == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonProperty", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$NameAttributeVisitor", "visitProperty"));
            }
            if (jsonProperty.getName().equals("name")) {
                JsonValue value = jsonProperty.getValue();
                if (!(value instanceof JsonStringLiteral)) {
                    return;
                }
                String nameValue = SpringBootAdditionalConfigInspection.getStringValue((JsonStringLiteral)value);
                if (!this.myExistingNames.containsKey(nameValue)) {
                    this.myExistingNames.put(nameValue, value);
                    return;
                }
                String message = "Duplicate entry for '" + nameValue + "'";
                this.registerDuplicate(value, message);
                JsonValue existingValue = this.myExistingNames.get(nameValue);
                this.registerDuplicate(existingValue, message);
            }
        }

        private void registerDuplicate(JsonValue valueElement, String message) {
            this.myHolder.registerProblem((PsiElement)valueElement, ElementManipulators.getValueTextRange((PsiElement)valueElement), message, new LocalQuickFix[0]);
        }
    }

    private static class PropertyVisitor
    extends JsonRecursiveElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsAtLeast13;

        private PropertyVisitor(ProblemsHolder holder, boolean isAtLeast13) {
            this.myHolder = holder;
            this.myIsAtLeast13 = isAtLeast13;
        }

        public void visitProperty(@NotNull JsonProperty jsonProperty) {
            if (jsonProperty == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsonProperty", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$PropertyVisitor", "visitProperty"));
            }
            JsonValue value = jsonProperty.getValue();
            if (value != null) {
                String text;
                String propertyName = jsonProperty.getName();
                for (PsiReference reference : value.getReferences()) {
                    boolean unresolved;
                    if (reference.isSoft()) continue;
                    boolean bl = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length == 0 : (unresolved = reference.resolve() == null);
                    if (!unresolved) continue;
                    this.myHolder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), PropertyVisitor.getUnresolvedReferenceProblemHighlightType(propertyName, reference));
                }
                if (value instanceof JsonStringLiteral && (propertyName.equals("description") || propertyName.equals("reason")) && !StringUtil.endsWith((CharSequence)(text = SpringBootAdditionalConfigInspection.getStringValue((JsonStringLiteral)value)), (CharSequence)".")) {
                    this.myHolder.registerProblem((PsiElement)value, "Text should end with '.'", ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
                }
                if (this.myIsAtLeast13 && propertyName.equals("deprecated")) {
                    this.myHolder.registerProblem((PsiElement)jsonProperty, "Property 'deprecated' should be replaced with 'deprecation'", ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }
            super.visitProperty(jsonProperty);
        }

        @NotNull
        private static ProblemHighlightType getUnresolvedReferenceProblemHighlightType(String propertyName, PsiReference reference) {
            if (reference instanceof SpringBootAdditionalConfigMetaConfigKeyReference) {
                ProblemHighlightType problemHighlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
                if (problemHighlightType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$PropertyVisitor", "getUnresolvedReferenceProblemHighlightType"));
                }
                return problemHighlightType;
            }
            if (!(reference instanceof JavaClassReference)) {
                ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                if (problemHighlightType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$PropertyVisitor", "getUnresolvedReferenceProblemHighlightType"));
                }
                return problemHighlightType;
            }
            if (propertyName.equals("target")) {
                ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
                if (problemHighlightType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$PropertyVisitor", "getUnresolvedReferenceProblemHighlightType"));
                }
                return problemHighlightType;
            }
            ProblemHighlightType problemHighlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            if (problemHighlightType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/metadata/additional/SpringBootAdditionalConfigInspection$PropertyVisitor", "getUnresolvedReferenceProblemHighlightType"));
            }
            return problemHighlightType;
        }
    }
}

