/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.boot.application.properties.MapKeyPropertyEnumReferenceSet;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MapKeyPropertyReference
extends MapKeyPropertyEnumReferenceSet.MyReference
implements EmptyResolveMessageProvider {
    private static final NullableFunction<PsiMethod, BeanProperty> BEAN_PROPERTY_MAPPER = new NullableFunction<PsiMethod, BeanProperty>(){

        @Nullable
        public BeanProperty fun(PsiMethod method) {
            return BeanProperty.createBeanProperty((PsiMethod)method);
        }
    };

    MapKeyPropertyReference(PsiElement element, TextRange textRange, MapKeyPropertyEnumReferenceSet referenceSet, int index) {
        super(element, textRange, referenceSet, index);
    }

    private static boolean stopResolvingProperty(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/boot/application/properties/MapKeyPropertyReference", "stopResolvingProperty"));
        }
        return psiClass.getQualifiedName() == null || psiClass.getQualifiedName().startsWith("java.lang.");
    }

    @Nullable
    private static PsiClass getTypeParameterIfMap(PsiMethod method, int idx) {
        if (method == null) {
            return null;
        }
        PsiType returnType = method.getReturnType();
        return MapKeyPropertyEnumReferenceSet.getTypeParameterClass(returnType, "java.util.Map", idx);
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass psiClass = this.getValueClassForLocalResolving();
        if (psiClass == null) {
            return null;
        }
        if (this.allowArbitraryKeys() && MapKeyPropertyReference.stopResolvingProperty(psiClass)) {
            return this.getElement();
        }
        return this.resolveProperty(psiClass, this.getValue());
    }

    @Nullable
    private PsiClass getValueClassForLocalResolving() {
        if (this.isUsedInIndexedConfigKeyPropertyChain()) {
            return this.getInitialValueClass();
        }
        if (this.getPrevious() instanceof MapKeyPropertyReference) {
            return this.getValueClass();
        }
        return this.getPrevious().getValueClass();
    }

    private boolean isUsedInIndexedConfigKeyPropertyChain() {
        return this.isFirst();
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = ContainerUtil.map2Array(this.getAllBeanProperties(), LookupElement.class, (Function)new Function<BeanProperty, LookupElement>(){

            public LookupElement fun(BeanProperty property) {
                PsiNamedElement element = property.getPsiElement();
                LookupElementBuilder builder = LookupElementBuilder.createWithIcon((PsiNamedElement)element).withTypeText(property.getPropertyType().getPresentableText());
                return TailTypeDecorator.withTail((LookupElement)builder, (TailType)MapKeyPropertyReference.this.getVariantTailType(property));
            }
        });
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/MapKeyPropertyReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    private TailType getVariantTailType(BeanProperty beanProperty) {
        final PsiType type = beanProperty.getPropertyType();
        if (type instanceof PsiClassType && InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.List")) {
            TailType tailType = new TailType(){

                public int processTail(Editor editor, int tailOffset) {
                    tailOffset = 3.insertChar((Editor)editor, (int)tailOffset, (char)'[');
                    tailOffset = 3.insertChar((Editor)editor, (int)tailOffset, (char)']');
                    PsiClass listElementType = MapKeyPropertyEnumReferenceSet.getTypeParameterClass(type, "java.util.List", 0);
                    boolean canHaveDotTail = listElementType != null && !MapKeyPropertyReference.stopResolvingProperty(listElementType);
                    tailOffset = 3.insertChar((Editor)editor, (int)tailOffset, (char)(canHaveDotTail ? (char)'.' : MapKeyPropertyReference.this.getKeyValueDelimiter()));
                    return 3.moveCaret((Editor)editor, (int)tailOffset, (int)-2);
                }
            };
            if (tailType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/MapKeyPropertyReference", "getVariantTailType"));
            }
            return tailType;
        }
        if (MapKeyPropertyReference.canHaveDotTail(type)) {
            TailType tailType = TailType.DOT;
            if (tailType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/MapKeyPropertyReference", "getVariantTailType"));
            }
            return tailType;
        }
        TailType tailType = TailType.createSimpleTailType((char)this.getKeyValueDelimiter());
        if (tailType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/MapKeyPropertyReference", "getVariantTailType"));
        }
        return tailType;
    }

    private static boolean canHaveDotTail(PsiType type) {
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)type);
        return psiClass != null && !MapKeyPropertyReference.stopResolvingProperty(psiClass);
    }

    private List<BeanProperty> getAllBeanProperties() {
        PsiClass psiClass = this.getValueClassForLocalResolving();
        if (psiClass == null || MapKeyPropertyReference.stopResolvingProperty(psiClass)) {
            return Collections.emptyList();
        }
        Map properties = PropertyUtil.getAllProperties((PsiClass)psiClass, (boolean)true, (!this.isLast() ? 1 : 0) != 0);
        return ContainerUtil.mapNotNull(properties.values(), BEAN_PROPERTY_MAPPER);
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String location = this.getValueClass() == null ? "" : " in " + this.getValueClass().getQualifiedName();
        String string = "Cannot resolve property '" + this.getValue() + "'" + location;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/MapKeyPropertyReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String name = PropertyUtil.getPropertyName((String)newElementName);
        return super.handleElementRename(name == null ? newElementName : name);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String propertyName;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/MapKeyPropertyReference", "bindToElement"));
        }
        if (element instanceof PsiMethod && (propertyName = PropertyUtil.getPropertyName((PsiMember)((PsiMember)element))) != null) {
            return super.handleElementRename(propertyName);
        }
        return this.getElement();
    }

    @Nullable
    private PsiNamedElement resolveProperty(@NotNull PsiClass psiClass, String propertyName) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/boot/application/properties/MapKeyPropertyReference", "resolveProperty"));
        }
        PsiMethod method = PropertyUtil.findPropertyGetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true);
        if (method == null || !method.hasModifierProperty("public")) {
            return null;
        }
        BeanProperty property = BeanProperty.createBeanProperty((PsiMethod)method);
        return property == null ? null : property.getPsiElement();
    }

    @Override
    @Nullable
    protected PsiClass getValueClass() {
        PsiMethod method;
        PsiClass type;
        if (this.isUsedInIndexedConfigKeyPropertyChain()) {
            return this.getInitialValueClass();
        }
        MapKeyPropertyEnumReferenceSet.MyReference previous = this.getPrevious();
        if (previous instanceof MapKeyPropertyReference) {
            MapKeyPropertyReference previousProp = (MapKeyPropertyReference)previous;
            PsiMethod method2 = previousProp.getResolvedMethod();
            if (method2 == null) {
                return null;
            }
            PsiType returnType = method2.getReturnType();
            PsiClass listType = MapKeyPropertyEnumReferenceSet.getTypeParameterClass(returnType, "java.util.List", 0);
            if (listType != null) {
                return listType;
            }
            return PsiTypesUtil.getPsiClass((PsiType)returnType);
        }
        PsiClass previousValueClass = previous.getValueClass();
        if (previousValueClass == null) {
            return null;
        }
        PsiNamedElement myLocalMethod = this.resolveProperty(previousValueClass, this.getValue());
        if (myLocalMethod instanceof BeanPropertyElement && (type = MapKeyPropertyReference.getTypeParameterIfMap(method = ((BeanPropertyElement)myLocalMethod).getMethod(), 1)) != null) {
            return type;
        }
        return previousValueClass;
    }

    @Override
    @Nullable
    protected PsiClass getKeyClass() {
        PsiMethod method;
        PsiClass type;
        if (this.isUsedInIndexedConfigKeyPropertyChain()) {
            return null;
        }
        MapKeyPropertyEnumReferenceSet.MyReference previous = this.getPrevious();
        PsiClass previousValueClass = previous.getValueClass();
        if (previousValueClass == null) {
            return null;
        }
        PsiNamedElement myLocalMethod = this.resolveProperty(previousValueClass, this.getValue());
        if (myLocalMethod instanceof BeanPropertyElement && (type = MapKeyPropertyReference.getTypeParameterIfMap(method = ((BeanPropertyElement)myLocalMethod).getMethod(), 0)) != null) {
            return type;
        }
        return null;
    }

    @Nullable
    private PsiMethod getResolvedMethod() {
        PsiElement resolve = this.resolve();
        if (resolve instanceof BeanPropertyElement) {
            return ((BeanPropertyElement)resolve).getMethod();
        }
        return null;
    }
}

