/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertySuppressableInspectionBase;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.additional.DefineLocalMetaConfigKeyFix;
import com.intellij.spring.boot.application.properties.MapKeyPropertyEnumReferenceSet;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesPlaceholderReference;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationPropertiesInspection
extends PropertySuppressableInspectionBase {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection", "checkFile"));
        }
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        PropertiesFile propertiesFile = (PropertiesFile)file;
        if (!SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile(propertiesFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (!SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        for (IProperty iProperty : propertiesFile.getProperties()) {
            PropertyValueImpl valueElement;
            PropertyImpl property;
            PropertyKeyImpl propertyKey;
            ProgressManager.checkCanceled();
            if (!(iProperty instanceof PropertyImpl) || (propertyKey = SpringBootApplicationPropertiesInspection.getPropertyKey(property = (PropertyImpl)iProperty)) == null) continue;
            SpringBootApplicationMetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)propertyKey);
            if (configKey == null) {
                String keyName = property.getName();
                holder.registerProblem(manager.createProblemDescriptor((PsiElement)propertyKey, "Can not resolve configuration property '" + keyName + "'", (LocalQuickFix)new DefineLocalMetaConfigKeyFix(keyName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                continue;
            }
            if (configKey.isDeprecated()) {
                PsiReference[] reasonShortText = configKey.getDeprecation().getReason().getShortText();
                String reason = StringUtil.isNotEmpty((String)reasonShortText) ? ": " + (String)reasonShortText : " configuration property '" + configKey.getName() + "'";
                holder.registerProblem(manager.createProblemDescriptor((PsiElement)propertyKey, "Deprecated" + reason, isOnTheFly, SpringBootApplicationPropertiesInspection.getDeprecationFix(property, configKey), ProblemHighlightType.LIKE_DEPRECATED));
            }
            if (configKey.isMapType() && propertyKey.getText().length() == configKey.getName().length()) {
                holder.registerProblem((PsiElement)propertyKey, "Missing map key", ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                continue;
            }
            if (configKey.isEnumMapType() || configKey.isIndexedType()) {
                for (PsiReference reference : propertyKey.getReferences()) {
                    if (!(reference instanceof MapKeyPropertyEnumReferenceSet.MyReference) || reference.isSoft() || reference.resolve() != null) continue;
                    holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.ERROR);
                }
            }
            if ((valueElement = SpringBootApplicationPropertiesInspection.getPropertyValue(property)) == null) continue;
            SpringBootApplicationPropertiesInspection.highlightValueReferences(holder, valueElement);
        }
        return holder.getResultsArray();
    }

    private static void highlightValueReferences(ProblemsHolder holder, @NotNull PropertyValueImpl valueElement) {
        if (valueElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueElement", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection", "highlightValueReferences"));
        }
        List valueReferences = ContainerUtil.filter((Object[])valueElement.getReferences(), (Condition)new Condition<PsiReference>(){

            public boolean value(PsiReference reference) {
                return !reference.isSoft() && !(reference instanceof SpringBootApplicationPropertiesPlaceholderReference);
            }
        });
        SmartList problematicReferences = new SmartList();
        boolean hasValidValueReference = false;
        for (PsiReference reference : valueReferences) {
            boolean unresolved;
            boolean bl = reference instanceof PsiPolyVariantReference ? ((PsiPolyVariantReference)reference).multiResolve(false).length == 0 : (unresolved = reference.resolve() == null);
            if (unresolved) {
                problematicReferences.add(reference);
                continue;
            }
            if (reference instanceof JavaClassReference && reference.resolve() instanceof PsiClass) {
                hasValidValueReference = true;
                SpringBootApplicationPropertiesInspection.highlightJavaClassReferenceExtends(holder, reference);
                continue;
            }
            if (reference instanceof JavaClassReference) continue;
            hasValidValueReference = true;
        }
        if (!hasValidValueReference) {
            for (PsiReference reference : problematicReferences) {
                holder.registerProblem(reference, ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), ProblemHighlightType.ERROR);
            }
        }
    }

    private static void highlightJavaClassReferenceExtends(ProblemsHolder holder, PsiReference reference) {
        JavaClassReference javaClassReference = (JavaClassReference)reference;
        String[] extendClassNames = javaClassReference.getExtendClassNames();
        if (extendClassNames == null) {
            return;
        }
        PsiElement resolve = reference.resolve();
        assert (resolve instanceof PsiClass) : resolve;
        for (String extend : extendClassNames) {
            if (!InheritanceUtil.isInheritor((PsiClass)((PsiClass)resolve), (String)extend)) continue;
            return;
        }
        holder.registerProblem(reference.getElement(), ElementManipulators.getValueText((PsiElement)reference.getElement()) + " is not assignable to " + StringUtil.join((String[])extendClassNames, (String)"|"), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
    }

    @Nullable
    private static PropertyKeyImpl getPropertyKey(PropertyImpl property) {
        ASTNode keyNode = property.getKeyNode();
        if (keyNode == null) {
            return null;
        }
        PsiElement keyElement = keyNode.getPsi();
        if (!(keyElement instanceof PropertyKeyImpl)) {
            return null;
        }
        return (PropertyKeyImpl)keyElement;
    }

    @Nullable
    private static PropertyValueImpl getPropertyValue(PropertyImpl property) {
        ASTNode valueNode = property.getValueNode();
        if (valueNode == null) {
            return null;
        }
        PsiElement valueElement = valueNode.getPsi();
        if (!(valueElement instanceof PropertyValueImpl)) {
            return null;
        }
        return (PropertyValueImpl)valueElement;
    }

    private static LocalQuickFix[] getDeprecationFix(PropertyImpl property, SpringBootApplicationMetaConfigKey configKey) {
        final String replacement = configKey.getDeprecation().getReplacement();
        if (replacement == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return new LocalQuickFix[]{new LocalQuickFixOnPsiElement((PsiElement)property){

            @NotNull
            public String getText() {
                String string = "Use replacement key '" + replacement + "'";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$2", "getText"));
                }
                return string;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$2", "invoke"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$2", "invoke"));
                }
                if (startElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$2", "invoke"));
                }
                if (endElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$2", "invoke"));
                }
                if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                    return;
                }
                PropertyImpl property = (PropertyImpl)startElement;
                property.setName(replacement);
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                if ("Use replacement key" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesInspection$2", "getFamilyName"));
                }
                return "Use replacement key";
            }
        }};
    }
}

