/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaClassReferenceCompletionContributor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationPropertiesSmartClassReferenceCompletionContributor
extends CompletionContributor {
    public void duringCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesSmartClassReferenceCompletionContributor", "duringCompletion"));
        }
        JavaClassReference reference = JavaClassReferenceCompletionContributor.findJavaClassReference((PsiFile)context.getFile(), (int)context.getStartOffset());
        if (SpringBootApplicationPropertiesSmartClassReferenceCompletionContributor.isRelevantReference(reference)) {
            JavaClassReferenceSet set = reference.getJavaClassReferenceSet();
            context.setReplacementOffset(set.getRangeInElement().getEndOffset() + set.getElement().getTextRange().getStartOffset());
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesSmartClassReferenceCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesSmartClassReferenceCompletionContributor", "fillCompletionVariants"));
        }
        if (parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        PsiFile file = parameters.getOriginalFile();
        if (!(file instanceof PropertiesFile) || !SpringBootApplicationPropertiesUtil.isApplicationPropertiesFile((PropertiesFile)file)) {
            return;
        }
        if (SpringBootApplicationPropertiesSmartClassReferenceCompletionContributor.isJavaClassReferenceWithExtendClassNames(parameters)) {
            result.runRemainingContributors(parameters.withType(CompletionType.SMART), true);
        }
    }

    private static boolean isJavaClassReferenceWithExtendClassNames(CompletionParameters parameters) {
        PsiElement position = parameters.getPosition();
        if (!(position instanceof PropertyValueImpl)) {
            return false;
        }
        JavaClassReference reference = JavaClassReferenceCompletionContributor.findJavaClassReference((PsiFile)position.getContainingFile(), (int)parameters.getOffset());
        return SpringBootApplicationPropertiesSmartClassReferenceCompletionContributor.isRelevantReference(reference);
    }

    private static boolean isRelevantReference(@Nullable JavaClassReference reference) {
        if (reference == null) {
            return false;
        }
        return reference.getExtendClassNames() != null;
    }
}

