/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationPropertiesUtil {
    public static boolean isApplicationPropertiesFile(final PropertiesFile propertiesFile) {
        final PsiFile containingFile = propertiesFile.getContainingFile();
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)containingFile, (CachedValueProvider)new CachedValueProvider<Boolean>(){

            @Nullable
            public CachedValueProvider.Result<Boolean> compute() {
                String fileName = propertiesFile.getName();
                if (!("application.properties".equals(fileName) || "bootstrap.properties".equals(fileName) || StringUtil.startsWith((CharSequence)fileName, (CharSequence)"application-") || StringUtil.startsWith((CharSequence)fileName, (CharSequence)"bootstrap-"))) {
                    return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{containingFile});
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
                boolean springBootAvailable = SpringBootLibraryUtil.hasSpringBootLibrary(module);
                return CachedValueProvider.Result.create((Object)springBootAvailable, (Object[])new Object[]{containingFile, ProjectRootManager.getInstance((Project)propertiesFile.getProject())});
            }
        });
    }
}

