/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReference;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesPlaceholderReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairFunction;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootApplicationPropertiesValueReferenceProvider
extends PsiReferenceProvider {
    private static final PairFunction<PsiElement, TextRange, PsiReference> PLACEHOLDER_PRODUCER = new PairFunction<PsiElement, TextRange, PsiReference>(){

        public PsiReference fun(PsiElement psiElement, TextRange range) {
            return new SpringBootApplicationPropertiesPlaceholderReference(psiElement, range);
        }
    };

    SpringBootApplicationPropertiesValueReferenceProvider() {
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueReferenceProvider", "getReferencesByElement"));
        }
        PropertyImpl property = (PropertyImpl)PsiTreeUtil.getParentOfType((PsiElement)element, PropertyImpl.class);
        if (property == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PropertyKeyImpl propertyKey = SpringBootApplicationPropertiesValueReferenceProvider.getPropertyKey(property);
        if (propertyKey == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueReferenceProvider", "getReferencesByElement"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        SpringBootApplicationMetaConfigKey key = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)propertyKey);
        if (key == null) {
            PsiReference[] psiReferenceArray = SpringBootPlaceholderReference.createPlaceholderReferences(element, PLACEHOLDER_PRODUCER);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        Object[] providerReferences = SpringBootHintReferencesProvider.getInstance().getReferences(module, key, SpringBootHintReferencesProvider.ItemHintType.VALUE, element, context);
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.mergeArrays((Object[])providerReferences, (Object[])SpringBootPlaceholderReference.createPlaceholderReferences(element, PLACEHOLDER_PRODUCER));
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesValueReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    @Nullable
    private static PropertyKeyImpl getPropertyKey(PropertyImpl property) {
        ASTNode keyNode = property.getKeyNode();
        if (keyNode == null) {
            return null;
        }
        PsiElement keyElement = keyNode.getPsi();
        if (!(keyElement instanceof PropertyKeyImpl)) {
            return null;
        }
        return (PropertyKeyImpl)keyElement;
    }
}

