/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.metadata.RelaxedNames;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLPsiElement;

class SpringBootApplicationYamlAccessor {
    private final YAMLDocument myDocument;

    SpringBootApplicationYamlAccessor(PsiElement context) {
        this.myDocument = (YAMLDocument)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{YAMLDocument.class});
    }

    private boolean isValid() {
        return this.myDocument != null;
    }

    @Nullable
    YAMLKeyValue findExistingKey(String qualifiedKey) {
        if (!this.isValid()) {
            return null;
        }
        YAMLDocument searchElement = this.myDocument;
        for (String subKey : StringUtil.split((String)qualifiedKey, (String)".")) {
            if ((searchElement = SpringBootApplicationYamlAccessor.findChildRelaxed((YAMLPsiElement)searchElement, subKey)) != null) continue;
            return null;
        }
        return searchElement instanceof YAMLKeyValue ? (YAMLKeyValue)searchElement : null;
    }

    @Nullable
    private static YAMLKeyValue findChildRelaxed(YAMLPsiElement searchElement, String subKey) {
        YAMLKeyValue byKey = YAMLUtil.findChildByName((YAMLPsiElement)searchElement, (String)subKey);
        if (byKey != null) {
            return byKey;
        }
        for (String relaxedName : new RelaxedNames(subKey)) {
            YAMLKeyValue byRelaxedName = YAMLUtil.findChildByName((YAMLPsiElement)searchElement, (String)relaxedName);
            if (byRelaxedName == null) continue;
            return byRelaxedName;
        }
        return null;
    }

    @Nullable
    YAMLKeyValue create(String qualifiedKey, final int offset) throws IncorrectOperationException {
        String subKey;
        YAMLKeyValue nextKey;
        if (!this.isValid()) {
            return null;
        }
        List keyParts = StringUtil.split((String)qualifiedKey, (String)".");
        YAMLDocument topMostExistingKey = this.myDocument;
        int foundHierarchies = 0;
        Iterator iterator = keyParts.iterator();
        while (iterator.hasNext() && (nextKey = SpringBootApplicationYamlAccessor.findChildRelaxed((YAMLPsiElement)topMostExistingKey, subKey = (String)iterator.next())) != null) {
            topMostExistingKey = nextKey;
            ++foundHierarchies;
        }
        if (foundHierarchies == keyParts.size()) {
            throw new IncorrectOperationException("key exists already: " + qualifiedKey + "\n" + this.myDocument.getText());
        }
        final boolean foundParentKey = foundHierarchies != 0;
        final boolean insideParentKey = topMostExistingKey.getTextRange().contains(offset - 1);
        final StringBuilder sb = new StringBuilder();
        for (int i = foundHierarchies; i < keyParts.size(); ++i) {
            String nextKey2 = (String)keyParts.get(i);
            if (!foundParentKey || !insideParentKey || i > foundHierarchies) {
                sb.append(StringUtil.repeat((String)"  ", (int)i));
            }
            sb.append(nextKey2).append(":");
            if (i >= keyParts.size() - 1) continue;
            sb.append("\n");
        }
        sb.append(" ");
        YAMLDocument finalTopMostExistingKey = topMostExistingKey;
        WriteCommandAction.runWriteCommandAction((Project)this.myDocument.getProject(), (Runnable)new Runnable((YAMLPsiElement)finalTopMostExistingKey){
            final /* synthetic */ YAMLPsiElement val$finalTopMostExistingKey;
            {
                this.val$finalTopMostExistingKey = yAMLPsiElement;
            }

            @Override
            public void run() {
                PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)SpringBootApplicationYamlAccessor.this.myDocument.getProject());
                Document document = manager.getDocument(SpringBootApplicationYamlAccessor.this.myDocument.getContainingFile());
                assert (document != null);
                if (foundParentKey) {
                    if (insideParentKey) {
                        document.insertString(offset, (CharSequence)sb.toString());
                    } else {
                        int existingKeyEndOffset = this.val$finalTopMostExistingKey.getTextOffset() + this.val$finalTopMostExistingKey.getTextLength();
                        if (PsiTreeUtil.findChildOfType((PsiElement)this.val$finalTopMostExistingKey, YAMLCompoundValue.class) != null) {
                            document.insertString(existingKeyEndOffset, (CharSequence)"\n");
                            ++existingKeyEndOffset;
                        }
                        document.insertString(existingKeyEndOffset, (CharSequence)sb.toString());
                    }
                } else {
                    int lineEndOffset;
                    int endOfCurrentDocument = SpringBootApplicationYamlAccessor.this.myDocument.getStartOffsetInParent() + SpringBootApplicationYamlAccessor.this.myDocument.getTextLength();
                    int lineNumber = document.getLineNumber(endOfCurrentDocument);
                    int lineStartOffset = document.getLineStartOffset(lineNumber);
                    TextRange lastLineRange = TextRange.create((int)lineStartOffset, (int)(lineEndOffset = document.getLineEndOffset(lineNumber)));
                    String lastLineText = document.getText(lastLineRange);
                    if (StringUtil.isEmptyOrSpaces((String)lastLineText)) {
                        document.replaceString(lineStartOffset, lineEndOffset, (CharSequence)sb.toString());
                    } else {
                        document.insertString(endOfCurrentDocument, (CharSequence)("\n" + sb.toString()));
                    }
                }
                manager.commitDocument(document);
            }
        });
        return this.findExistingKey(qualifiedKey);
    }

    List<YAMLKeyValue> getAllKeys() {
        if (!this.isValid()) {
            return Collections.emptyList();
        }
        ArrayList<YAMLKeyValue> result = new ArrayList<YAMLKeyValue>();
        SpringBootApplicationYamlAccessor.processAllKeys((YAMLPsiElement)this.myDocument, result);
        return result;
    }

    private static void processAllKeys(YAMLPsiElement start, List<YAMLKeyValue> result) {
        for (YAMLPsiElement element : start.getYAMLElements()) {
            YAMLKeyValue yamlKeyValue;
            if (element instanceof YAMLKeyValue && SpringBootApplicationYamlUtil.isScalarKey(yamlKeyValue = (YAMLKeyValue)element)) {
                result.add(yamlKeyValue);
                continue;
            }
            SpringBootApplicationYamlAccessor.processAllKeys(element, result);
        }
    }
}

