/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.spring.boot.application.metadata.MetaConfigKeyReference;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.additional.DefineLocalMetaConfigKeyFix;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public class SpringBootApplicationYamlInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlInspection", "checkFile"));
        }
        if (!(file instanceof YAMLFile)) {
            return null;
        }
        YAMLFile yamlFile = (YAMLFile)file;
        if (!SpringBootApplicationYamlUtil.isApplicationYamlFile(yamlFile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (!SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        final ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
        List yamlDocuments = yamlFile.getDocuments();
        final boolean hasMultipleDocuments = yamlDocuments.size() > 1;
        for (YAMLDocument document : yamlDocuments) {
            document.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    if (!(element instanceof YAMLKeyValue)) {
                        return;
                    }
                    YAMLKeyValue yamlKeyValue = (YAMLKeyValue)element;
                    SpringBootApplicationMetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey(element);
                    if (configKey == null) {
                        if (SpringBootApplicationYamlUtil.isScalarKey(yamlKeyValue)) {
                            String qualifiedConfigKeyName = SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(yamlKeyValue);
                            if (hasMultipleDocuments && "spring.profiles".equals(qualifiedConfigKeyName)) {
                                return;
                            }
                            holder.registerProblem(manager.createProblemDescriptor(yamlKeyValue.getKey(), "Can not resolve configuration property '" + qualifiedConfigKeyName + "'", (LocalQuickFix)new DefineLocalMetaConfigKeyFix(qualifiedConfigKeyName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                        }
                        return;
                    }
                    if (configKey.isDeprecated()) {
                        String reasonShortText = configKey.getDeprecation().getReason().getShortText();
                        String reason = StringUtil.isNotEmpty((String)reasonShortText) ? ": " + reasonShortText : " configuration property '" + configKey.getName() + "'";
                        holder.registerProblem(manager.createProblemDescriptor(yamlKeyValue.getKey(), "Deprecated" + reason, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.LIKE_DEPRECATED));
                    }
                }
            });
        }
        return holder.getResultsArray();
    }
}

