/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.util.Key;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlAccessor;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlReferenceContributor;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import icons.SpringApiIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public class SpringBootApplicationYamlKeyCompletionContributor
extends CompletionContributor {
    public SpringBootApplicationYamlKeyCompletionContributor() {
        MyKeyCompletionProvider provider = new MyKeyCompletionProvider();
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(YAMLDocument.class)).with(SpringBootApplicationYamlReferenceContributor.APPLICATION_YAML_SB_1_2_OR_HIGHER), provider);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)YAMLTokenTypes.INDENT))).with(SpringBootApplicationYamlReferenceContributor.APPLICATION_YAML_SB_1_2_OR_HIGHER), provider);
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(LeafPsiElement.class).withElementType((IElementType)YAMLTokenTypes.SCALAR_KEY)).inside(YAMLKeyValue.class)).with(SpringBootApplicationYamlReferenceContributor.APPLICATION_YAML_SB_1_2_OR_HIGHER), provider);
    }

    private static class MyKeyCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final Key<String> CONFIG_KEY = Key.create((String)"ymlConfigKey");
        private static final InsertHandler<LookupElementDecorator<LookupElementBuilder>> INSERT_HANDLER = new InsertHandler<LookupElementDecorator<LookupElementBuilder>>(){

            public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElementBuilder> item) {
                String qualifiedKey = (String)item.getCopyableUserData(CONFIG_KEY);
                assert (qualifiedKey != null);
                PsiElement currentElement = context.getFile().findElementAt(context.getStartOffset());
                assert (currentElement != null) : "no element at " + context.getStartOffset();
                SpringBootApplicationYamlAccessor accessor = new SpringBootApplicationYamlAccessor(currentElement);
                context.getDocument().deleteString(context.getStartOffset(), context.getTailOffset());
                context.commitDocument();
                YAMLKeyValue created = accessor.create(qualifiedKey, context.getStartOffset());
                assert (created != null) : qualifiedKey;
                context.getEditor().getCaretModel().moveToOffset(created.getValue().getTextOffset());
            }
        };

        private MyKeyCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            int invocationCount;
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlKeyCompletionContributor$MyKeyCompletionProvider", "addCompletions"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlKeyCompletionContributor$MyKeyCompletionProvider", "addCompletions"));
            }
            YAMLFile yamlFile = (YAMLFile)parameters.getOriginalFile();
            PsiElement element = parameters.getPosition();
            PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)element);
            YAMLKeyValue parentYamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)originalElement, YAMLKeyValue.class);
            if (parentYamlKeyValue == null) {
                parentYamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
            }
            if ((invocationCount = parameters.getInvocationCount()) <= 1) {
                result.addLookupAdvertisement("Press " + SpringBootApplicationYamlKeyCompletionContributor.getActionShortcut((String)"CodeCompletion") + " to see all configuration keys with different prefix");
            }
            String parentConfigKeyName = parentYamlKeyValue == null || invocationCount > 1 ? "" : SpringBootApplicationYamlUtil.getQualifiedConfigKeyName(parentYamlKeyValue);
            SpringBootApplicationYamlAccessor accessor = new SpringBootApplicationYamlAccessor((PsiElement)ObjectUtils.chooseNotNull((Object)originalElement, (Object)element));
            List configKeys = SpringBootApplicationMetaConfigKeyManager.getInstance().getAllMetaConfigKeys((PsiElement)yamlFile);
            for (SpringBootApplicationMetaConfigKey configKey : configKeys) {
                if (!parentConfigKeyName.isEmpty() && !configKey.matchesPrefix(parentConfigKeyName) || accessor.findExistingKey(configKey.getName()) != null) continue;
                LookupElementBuilder builder = configKey.getLookupElement();
                builder.putCopyableUserData(CONFIG_KEY, (Object)configKey.getName());
                LookupElementDecorator insertHandler = LookupElementDecorator.withInsertHandler((LookupElement)builder, INSERT_HANDLER);
                result.addElement(configKey.tuneLookupElement((LookupElement)insertHandler));
            }
            if (yamlFile.getDocuments().size() > 1 && accessor.findExistingKey("spring.profiles") == null) {
                LookupElementBuilder builder = LookupElementBuilder.create((String)"spring.profiles").withIcon(SpringApiIcons.SpringProfile).withTailText(" (Define profile(s) for this document)", true);
                LookupElementDecorator decorator = LookupElementDecorator.withInsertHandler((LookupElement)builder, INSERT_HANDLER);
                result.addElement((LookupElement)decorator);
            }
            result.stopHere();
        }
    }
}

