/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

class SpringBootApplicationYamlUtil {
    static final String SPRING_PROFILES_KEY = "spring.profiles";

    SpringBootApplicationYamlUtil() {
    }

    static boolean isInsideApplicationYamlFile(PsiElement psiElement) {
        PsiFile containingFile = psiElement.getContainingFile().getOriginalFile();
        return containingFile instanceof YAMLFile && SpringBootApplicationYamlUtil.isApplicationYamlFile((YAMLFile)containingFile);
    }

    static boolean isApplicationYamlFile(YAMLFile yamlFile) {
        String fileName = yamlFile.getVirtualFile().getNameWithoutExtension();
        if (!("application".equals(fileName) || "bootstrap".equals(fileName) || StringUtil.startsWith((CharSequence)fileName, (CharSequence)"application-") || StringUtil.startsWith((CharSequence)fileName, (CharSequence)"bootstrap-"))) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)yamlFile);
        return SpringBootLibraryUtil.hasSpringBootLibrary(module);
    }

    static String getQualifiedConfigKeyName(YAMLKeyValue yamlKeyValue) {
        StringBuilder builder = new StringBuilder();
        YAMLKeyValue element = yamlKeyValue;
        while (element != null) {
            if (builder.length() > 0) {
                builder.insert(0, '.');
            }
            builder.insert(0, element.getKeyText());
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class);
            element = (YAMLKeyValue)parent;
        }
        return builder.toString();
    }

    static boolean isScalarKey(YAMLKeyValue yamlKeyValue) {
        return PsiTreeUtil.findChildOfType((PsiElement)yamlKeyValue, YAMLKeyValue.class) == null;
    }
}

