/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.spring.SpringModelProvider;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootFileSet;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootModelProvider
implements SpringModelProvider {
    @NotNull
    public List<SpringFileSet> getFilesets(@NotNull SpringFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/spring/boot/model/SpringBootModelProvider", "getFilesets"));
        }
        Module module = facet.getModule();
        if (DumbService.isDumb((Project)module.getProject()) || !SpringBootLibraryUtil.hasSpringBootLibrary(module)) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/SpringBootModelProvider", "getFilesets"));
            }
            return list;
        }
        PsiClass applicationClass = SpringBootModelProvider.findSingleSpringBootApplication(module);
        if (applicationClass == null) {
            List<SpringFileSet> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/SpringBootModelProvider", "getFilesets"));
            }
            return list;
        }
        SpringBootFileSet bootFileSet = new SpringBootFileSet(applicationClass, facet);
        for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
            for (VirtualFile file : contributor.getConfigurationFiles(module)) {
                bootFileSet.addFile(file);
            }
        }
        SpringFacetConfiguration configuration = (SpringFacetConfiguration)facet.getConfiguration();
        configuration.registerAutodetectedFileSet((SpringFileSet)bootFileSet);
        List<SpringBootFileSet> list = Collections.singletonList(bootFileSet);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/SpringBootModelProvider", "getFilesets"));
        }
        return list;
    }

    @Nullable
    private static PsiClass findSingleSpringBootApplication(Module module) {
        List results = SpringBootApplicationUtil.getSpringApplications((Module)module);
        return results.size() == 1 ? (PsiClass)ContainerUtil.getFirstItem((List)results) : null;
    }
}

