/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure;

import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemService;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnEvaluationContext;
import com.intellij.spring.boot.model.autoconfigure.jam.ConditionalOnJamElement;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AutoConfigClassConditionEvaluator {
    private static final boolean FILTER_AUTO_CONFIGS = true;
    private final Module myModule;
    private final PsiClass myAutoConfigClass;

    AutoConfigClassConditionEvaluator(Module module, PsiClass autoConfigClass) {
        this.myModule = module;
        this.myAutoConfigClass = autoConfigClass;
    }

    boolean isActive() {
        PsiModifierList modifierList = this.myAutoConfigClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        List<ConditionalOnJamElement> allConditions = AutoConfigClassConditionEvaluator.getAnnotationJamElements(this.myAutoConfigClass, modifierList);
        if (allConditions.isEmpty()) {
            return false;
        }
        ConditionalOnEvaluationContext evaluationContext = this.createConditionalOnEvaluationContext();
        for (ConditionalOnJamElement condition : allConditions) {
            if (condition.value((Object)evaluationContext)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private ConditionalOnEvaluationContext createConditionalOnEvaluationContext() {
        ConditionalOnEvaluationContext conditionalOnEvaluationContext = new ConditionalOnEvaluationContext(){

            @NotNull
            public PsiClass getAutoConfigClass() {
                PsiClass psiClass = AutoConfigClassConditionEvaluator.this.myAutoConfigClass;
                if (psiClass == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassConditionEvaluator$1", "getAutoConfigClass"));
                }
                return psiClass;
            }

            @NotNull
            public Module getModule() {
                Module module = AutoConfigClassConditionEvaluator.this.myModule;
                if (module == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassConditionEvaluator$1", "getModule"));
                }
                return module;
            }
        };
        if (conditionalOnEvaluationContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassConditionEvaluator", "createConditionalOnEvaluationContext"));
        }
        return conditionalOnEvaluationContext;
    }

    @NotNull
    private static List<ConditionalOnJamElement> getAnnotationJamElements(PsiClass autoConfigClass, PsiModifierList modifierList) {
        List allConditionalMeta = SemService.getSemService((Project)autoConfigClass.getProject()).getSemElements(ConditionalOnJamElement.MEMBER_META_KEY, (PsiElement)autoConfigClass);
        if (allConditionalMeta.isEmpty()) {
            List<ConditionalOnJamElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassConditionEvaluator", "getAnnotationJamElements"));
            }
            return list;
        }
        SmartList allConditionalJamElements = new SmartList();
        block0: for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            for (JamMemberMeta memberMeta : allConditionalMeta) {
                JamAnnotationMeta jamAnnotationMeta = memberMeta.findAnnotationMeta(annotation);
                if (jamAnnotationMeta == null) continue;
                ConditionalOnJamElement jamElement = (ConditionalOnJamElement)memberMeta.getJamElement((PsiModifierListOwner)autoConfigClass);
                allConditionalJamElements.add(jamElement);
                continue block0;
            }
        }
        SmartList smartList = allConditionalJamElements;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/boot/model/autoconfigure/AutoConfigClassConditionEvaluator", "getAnnotationJamElements"));
        }
        return smartList;
    }
}

