/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.application.BaseJavaApplicationCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import org.jetbrains.annotations.NotNull;

class SpringBootCommandLineState
extends BaseJavaApplicationCommandLineState<SpringBootApplicationRunConfiguration> {
    static final String DEBUG_PARAMETER = "--debug";
    static final String HIDE_BANNER_PARAMETER = "--spring.main.show_banner=false";
    static final String ACTIVE_PROFILES_PARAMETER = "--spring.profiles.active";
    static final String OUTPUT_ANSI_ENABLED_PARAMETER = "--spring.output.ansi.enabled=always";

    SpringBootCommandLineState(@NotNull SpringBootApplicationRunConfiguration configuration, ExecutionEnvironment environment) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/spring/boot/run/SpringBootCommandLineState", "<init>"));
        }
        super(environment, (RunConfigurationBase)configuration);
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters params = new JavaParameters();
        JavaRunConfigurationModule module = (JavaRunConfigurationModule)((SpringBootApplicationRunConfiguration)this.myConfiguration).getConfigurationModule();
        int classPathType = JavaParametersUtil.getClasspathType((RunConfigurationModule)module, (String)((SpringBootApplicationRunConfiguration)this.myConfiguration).getSpringBootMainClass(), (boolean)false);
        String jreHome = ((SpringBootApplicationRunConfiguration)this.myConfiguration).isAlternativeJrePathEnabled() ? ((SpringBootApplicationRunConfiguration)this.myConfiguration).getAlternativeJrePath() : null;
        JavaParametersUtil.configureModule((RunConfigurationModule)module, (JavaParameters)params, (int)classPathType, (String)jreHome);
        params.setMainClass(((SpringBootApplicationRunConfiguration)this.myConfiguration).getSpringBootMainClass());
        this.setupJavaParameters(params);
        this.applySpringBootSettings(params);
        return params;
    }

    private void applySpringBootSettings(JavaParameters params) {
        ParametersList parametersList = params.getProgramParametersList();
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isDebugMode()) {
            parametersList.add(DEBUG_PARAMETER);
        }
        if (((SpringBootApplicationRunConfiguration)this.myConfiguration).isHideBanner()) {
            parametersList.add(HIDE_BANNER_PARAMETER);
        }
        if (StringUtil.isNotEmpty((String)((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles())) {
            parametersList.add("--spring.profiles.active=" + ((SpringBootApplicationRunConfiguration)this.myConfiguration).getActiveProfiles());
        }
        parametersList.add(OUTPUT_ANSI_ENABLED_PARAMETER);
        for (SpringBootAdditionalParameter parameter : ((SpringBootApplicationRunConfiguration)this.myConfiguration).getAdditionalParameters()) {
            if (!parameter.isEnabled()) continue;
            parametersList.add("--" + parameter.getName() + "=" + parameter.getValue());
        }
    }
}

