/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import com.intellij.facet.FacetType;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.initializr.SpringInitializrApplicationInfoStep;
import com.intellij.spring.initializr.SpringInitializrDependenciesStep;
import com.intellij.spring.initializr.SpringInitializrDownloader;
import com.intellij.spring.initializr.SpringInitializrModuleBuilderPostTask;
import com.intellij.spring.initializr.SpringInitializrOptions;
import com.intellij.spring.initializr.SpringInitializrServiceChooserStep;
import icons.SpringBootApiIcons;
import java.io.IOException;
import javax.swing.Icon;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringInitializrModuleBuilder
extends ModuleBuilder {
    private SpringInitializrOptions myOptions;
    private String myServiceUrl;

    SpringInitializrOptions getOptions() {
        return this.myOptions;
    }

    void setOptions(SpringInitializrOptions options) {
        this.myOptions = options;
    }

    String getServiceUrl() {
        return this.myServiceUrl;
    }

    void setServiceUrl(String serviceUrl) {
        this.myServiceUrl = serviceUrl;
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wizardContext", "com/intellij/spring/initializr/SpringInitializrModuleBuilder", "createWizardSteps"));
        }
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/spring/initializr/SpringInitializrModuleBuilder", "createWizardSteps"));
        }
        return new ModuleWizardStep[]{new SpringInitializrApplicationInfoStep(this), new SpringInitializrDependenciesStep(this)};
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        return new SpringInitializrServiceChooserStep(this);
    }

    @Nullable
    public String getBuilderId() {
        return "SpringInitializr";
    }

    public String getPresentableName() {
        return "Spring Initializr";
    }

    public String getParentGroup() {
        return "Build Tools";
    }

    public int getWeight() {
        return 80;
    }

    public Icon getNodeIcon() {
        return SpringBootApiIcons.SpringBoot;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public void setupRootModel(ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        modifiableRootModel.inheritSdk();
        this.doAddContentEntry(modifiableRootModel);
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/spring/initializr/SpringInitializrModuleBuilder", "createModule"));
        }
        final Module module = super.createModule(moduleModel);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                    @Override
                    public void run() {
                        DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    SpringInitializrDownloader downloader = new SpringInitializrDownloader(SpringInitializrModuleBuilder.this);
                                    downloader.execute(ProgressManager.getInstance().getProgressIndicator());
                                }
                                catch (IOException e) {
                                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            Messages.showErrorDialog((String)("Error: " + e.getMessage()), (String)"Spring Initializr");
                                        }
                                    });
                                }
                            }
                        });
                    }
                }, "Downloading Spring Initializr Template...", true, null);
                for (SpringInitializrModuleBuilderPostTask task : (SpringInitializrModuleBuilderPostTask[])SpringInitializrModuleBuilderPostTask.EXTENSION_POINT_NAME.getExtensions()) {
                    if (task.runAfterSetup(module)) continue;
                    return;
                }
            }
        }, ModalityState.current());
        FacetUtil.addFacet((Module)module, (FacetType)SpringFacet.getSpringFacetType());
        Module module2 = module;
        if (module2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/initializr/SpringInitializrModuleBuilder", "createModule"));
        }
        return module2;
    }
}

