/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)(?:\\.([^0-9]+)(\\d+)?)?$");
    private static final VersionQualifierComparator qualifierComparator = new VersionQualifierComparator();
    private final Integer major;
    private final Integer minor;
    private final Integer patch;
    private final Qualifier qualifier;

    private Version(Integer major, Integer minor, Integer patch, Qualifier qualifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.qualifier = qualifier;
    }

    public Integer getMajor() {
        return this.major;
    }

    public Integer getMinor() {
        return this.minor;
    }

    public Integer getPatch() {
        return this.patch;
    }

    public Qualifier getQualifier() {
        return this.qualifier;
    }

    static Version parse(String text) {
        Matcher matcher = VERSION_PATTERN.matcher(text.trim());
        if (!matcher.matches()) {
            throw new InvalidVersionException("Could not determine version based on '" + text + "': version format " + "is Minor.Major.Patch.Qualifier (i.e. 1.0.5.RELEASE");
        }
        Integer major = Integer.valueOf(matcher.group(1));
        Integer minor = Integer.valueOf(matcher.group(2));
        Integer patch = Integer.valueOf(matcher.group(3));
        Qualifier qualifier = null;
        String qualifierId = matcher.group(4);
        if (qualifierId != null) {
            String qualifierVersion = matcher.group(5);
            qualifier = qualifierVersion != null ? new Qualifier(qualifierId, Integer.valueOf(qualifierVersion)) : new Qualifier(qualifierId);
        }
        return new Version(major, minor, patch, qualifier);
    }

    static Version safeParse(String text) {
        try {
            return Version.parse(text);
        }
        catch (InvalidVersionException e) {
            return null;
        }
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            return 1;
        }
        int majorDiff = Version.safeCompare(this.major, other.major);
        if (majorDiff != 0) {
            return majorDiff;
        }
        int minorDiff = Version.safeCompare(this.minor, other.minor);
        if (minorDiff != 0) {
            return minorDiff;
        }
        int patch = Version.safeCompare(this.patch, other.patch);
        if (patch != 0) {
            return patch;
        }
        return qualifierComparator.compare(this.qualifier, other.qualifier);
    }

    private static int safeCompare(Integer first, Integer second) {
        Integer firstIndex = first != null ? first : 0;
        Integer secondIndex = second != null ? second : 0;
        return firstIndex.compareTo(secondIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Version{");
        sb.append("major=").append(this.major);
        sb.append(", minor=").append(this.minor);
        sb.append(", patch=").append(this.patch);
        sb.append(", qualifier=").append(this.qualifier);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.major != null ? !this.major.equals(version.major) : version.major != null) {
            return false;
        }
        if (this.minor != null ? !this.minor.equals(version.minor) : version.minor != null) {
            return false;
        }
        if (this.patch != null ? !this.patch.equals(version.patch) : version.patch != null) {
            return false;
        }
        return !(this.qualifier == null ? version.qualifier != null : !this.qualifier.equals(version.qualifier));
    }

    public int hashCode() {
        int result = this.major != null ? this.major.hashCode() : 0;
        result = 31 * result + (this.minor != null ? this.minor.hashCode() : 0);
        result = 31 * result + (this.patch != null ? this.patch.hashCode() : 0);
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        return result;
    }

    private static class VersionQualifierComparator
    implements Comparator<Qualifier> {
        private static final String RELEASE = "RELEASE";
        private static final String SNAPSHOT = "BUILD-SNAPSHOT";
        private static final String MILESTONE = "M";
        private static final String RC = "RC";
        private static final List<String> KNOWN_QUALIFIERS = Arrays.asList("M", "RC", "BUILD-SNAPSHOT", "RELEASE");

        private VersionQualifierComparator() {
        }

        @Override
        public int compare(Qualifier o1, Qualifier o2) {
            Qualifier first = o1 != null ? o1 : new Qualifier(RELEASE);
            Qualifier second = o2 != null ? o2 : new Qualifier(RELEASE);
            int qualifier = VersionQualifierComparator.compareQualifier(first, second);
            return qualifier != 0 ? qualifier : VersionQualifierComparator.compareQualifierVersion(first, second);
        }

        private static int compareQualifierVersion(Qualifier first, Qualifier second) {
            Integer firstVersion = first.getVersion() != null ? first.getVersion() : 0;
            Integer secondVersion = second.getVersion() != null ? second.getVersion() : 0;
            return firstVersion.compareTo(secondVersion);
        }

        private static int compareQualifier(Qualifier first, Qualifier second) {
            Integer firstIndex = VersionQualifierComparator.getQualifierIndex(first.id);
            Integer secondIndex = VersionQualifierComparator.getQualifierIndex(second.id);
            if (firstIndex == -1 && secondIndex == -1) {
                return first.id.compareTo(second.id);
            }
            return firstIndex.compareTo(secondIndex);
        }

        private static int getQualifierIndex(String qualifier) {
            String q = qualifier != null ? qualifier : RELEASE;
            return KNOWN_QUALIFIERS.indexOf(q);
        }
    }

    static class Qualifier {
        private final String id;
        private final Integer version;

        private Qualifier(String id, Integer version) {
            this.id = id;
            this.version = version;
        }

        private Qualifier(String id) {
            this(id, (Integer)null);
        }

        String getId() {
            return this.id;
        }

        Integer getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Qualifier qualifier1 = (Qualifier)o;
            if (!this.id.equals(qualifier1.id)) {
                return false;
            }
            return !(this.version == null ? qualifier1.version != null : !this.version.equals(qualifier1.version));
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }

    public static class InvalidVersionException
    extends RuntimeException {
        public InvalidVersionException(String message) {
            super(message);
        }
    }
}

