/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.initializr.maven;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.spring.boot.application.SpringBootApplicationUtil;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.initializr.maven.config.SpringInitializrMavenConfiguration;
import java.util.List;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

class SpringBootMavenPostProcessorTask
implements MavenProjectsProcessorTask {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.initializr.maven.SpringBootMavenPostProcessorTask");
    private final Module myModule;
    private final RunManager myRunManager;
    private final SpringBootApplicationConfigurationTypeBase mySpringBootType;

    SpringBootMavenPostProcessorTask(Module module) {
        this.myModule = module;
        this.myRunManager = RunManager.getInstance((Project)this.myModule.getProject());
        this.mySpringBootType = SpringBootApplicationConfigurationTypeBase.getInstance();
    }

    public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
        DumbService.getInstance((Project)project).runReadActionInSmartMode(new Runnable(){

            @Override
            public void run() {
                SpringBootMavenPostProcessorTask.this.createSpringBootRunConfiguration();
            }
        });
    }

    private void createSpringBootRunConfiguration() {
        SpringInitializrMavenConfiguration configuration = SpringInitializrMavenConfiguration.getInstance(this.myModule.getProject());
        if (!configuration.isCreateRunConfiguration()) {
            return;
        }
        List applications = SpringBootApplicationUtil.getSpringApplications((Module)this.myModule);
        if (applications.size() != 1) {
            return;
        }
        PsiClass springBootApp = (PsiClass)applications.get(0);
        boolean hasSpringBootRunConfig = this.hasSpringBootRunConfiguration();
        if (!hasSpringBootRunConfig) {
            this.createSpringBootRunConfiguration(springBootApp);
        }
    }

    private void createSpringBootRunConfiguration(PsiClass springBootApp) {
        try {
            RunnerAndConfigurationSettings settings = this.myRunManager.createRunConfiguration("", this.mySpringBootType.getDefaultConfigurationFactory());
            SpringBootApplicationRunConfigurationBase newRunConfig = (SpringBootApplicationRunConfigurationBase)settings.getConfiguration();
            newRunConfig.setModule(this.myModule);
            newRunConfig.setSpringBootMainClass(springBootApp.getQualifiedName());
            settings.setName(newRunConfig.suggestedName());
            this.myRunManager.addConfiguration(settings, false);
            if (this.myRunManager.getAllConfigurationsList().size() == 1) {
                this.myRunManager.setSelectedConfiguration(settings);
            }
        }
        catch (Throwable t) {
            LOG.error("Error creating Spring Boot run configuration for " + springBootApp, t);
        }
    }

    private boolean hasSpringBootRunConfiguration() {
        List allSpringBootRunConfigs = this.myRunManager.getConfigurationsList((ConfigurationType)this.mySpringBootType);
        for (RunConfiguration config : allSpringBootRunConfigs) {
            Module configModule;
            if (!(config instanceof SpringBootApplicationRunConfigurationBase) || !this.myModule.equals(configModule = ((SpringBootApplicationRunConfigurationBase)config).getModule())) continue;
            return true;
        }
        return false;
    }
}

