/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.dependencies;

import com.intellij.execution.ExecutionException;
import com.intellij.maven.dependencies.bundle.MavenDependenciesBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.JBIterable;
import java.io.File;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.idea.maven.utils.library.remote.MavenDependenciesRemoteManager;

public class MavenManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + MavenManager.class.getName()));
    static MavenManager instance = new MavenManager();
    ConcurrentHashMap<String, List<String>> artifactDependentFilesMap = new ConcurrentHashMap();

    private MavenManager() {
    }

    public static MavenManager getInstance() {
        return instance;
    }

    private static boolean checkExistence(List<String> jars) {
        for (String jar : jars) {
            File file = new File(jar);
            if (file.exists() && file.isFile()) continue;
            return false;
        }
        return true;
    }

    public List<String> getOrLoadMavenArtifactJars(@NotNull Project project, @NotNull String groupId, @NotNull String artifactId, @NotNull String version, boolean downloadSources, boolean downloadJavaDocs) throws ExecutionException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/maven/dependencies/MavenManager", "getOrLoadMavenArtifactJars"));
        }
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/maven/dependencies/MavenManager", "getOrLoadMavenArtifactJars"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/intellij/maven/dependencies/MavenManager", "getOrLoadMavenArtifactJars"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/maven/dependencies/MavenManager", "getOrLoadMavenArtifactJars"));
        }
        String key = groupId + ":" + artifactId + ":" + version;
        List jars = this.artifactDependentFilesMap.get(key);
        if (jars != null && MavenManager.checkExistence(jars)) {
            return jars;
        }
        RepositoryLibraryProperties repositoryLibraryProperties = new RepositoryLibraryProperties(groupId, artifactId, version);
        repositoryLibraryProperties.changeVersion(RepositoryUtils.resolveEffectiveVersion((Project)project, (RepositoryLibraryProperties)repositoryLibraryProperties));
        List roots = MavenDependenciesRemoteManager.getInstance((Project)project).downloadDependenciesModal(repositoryLibraryProperties, downloadSources, downloadJavaDocs, null);
        if (roots == null || roots.isEmpty()) {
            throw new ExecutionException(MavenDependenciesBundle.message("arquillian.maven.dependencies.load.failed", key));
        }
        jars = JBIterable.from((Iterable)roots).transform((Function)new Function<OrderRoot, String>(){

            public String fun(OrderRoot root) {
                return PathUtil.toPresentableUrl((String)root.getFile().getUrl());
            }
        }).toList();
        this.artifactDependentFilesMap.put(key, jars);
        return jars;
    }

    public List<String> getMavenArtifactJars(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupId", "com/intellij/maven/dependencies/MavenManager", "getMavenArtifactJars"));
        }
        if (artifactId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactId", "com/intellij/maven/dependencies/MavenManager", "getMavenArtifactJars"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/maven/dependencies/MavenManager", "getMavenArtifactJars"));
        }
        String key = groupId + ":" + artifactId + ":" + version;
        return this.artifactDependentFilesMap.get(key);
    }
}

