/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlCollectionType;
import com.intellij.freemarker.psi.FtlDateType;
import com.intellij.freemarker.psi.FtlNodeType;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariableType;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.NullableConstantFunction;
import com.intellij.util.NullableFunction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FtlBuiltInDescriptor {
    private final String myCamelCaseName;
    private final String mySnakeCaseName;
    private final Function<FtlBuiltIn, FtlType> myType;

    protected FtlBuiltInDescriptor(@NonNls String camelCaseName, Function<FtlBuiltIn, FtlType> type) {
        String lower = FtlPsiUtil.camelToSnakeCase(camelCaseName);
        this.mySnakeCaseName = lower != null ? lower : camelCaseName;
        this.myCamelCaseName = camelCaseName;
        this.myType = type;
    }

    public FtlBuiltInDescriptor(String snakeCaseName, String camelCaseName, Function<FtlBuiltIn, FtlType> type) {
        if (snakeCaseName.contains("_") && !StringUtil.hasUpperCaseChar((String)camelCaseName)) {
            throw new IllegalArgumentException("camelCase name not supplied for " + snakeCaseName + " built-in");
        }
        this.mySnakeCaseName = snakeCaseName;
        this.myCamelCaseName = camelCaseName;
        this.myType = type;
    }

    public FtlBuiltInDescriptor(@NonNls String name, PsiType psiType) {
        this(name, (Function<FtlBuiltIn, FtlType>)new NullableConstantFunction((Object)FtlPsiType.wrap(psiType)));
    }

    public String getCamelCaseName() {
        return this.myCamelCaseName;
    }

    public String getSnakeCaseName() {
        return this.mySnakeCaseName;
    }

    public abstract boolean acceptsQualifier(@NotNull FtlType var1, @NotNull PsiElement var2);

    @Nullable
    public FtlType getType(FtlBuiltIn builtIn) {
        return (FtlType)this.myType.fun((Object)builtIn);
    }

    public boolean isDeprecated() {
        return false;
    }

    @Nullable
    @NonNls
    public String getQuickFixReplacement(FtlBuiltIn builtIn) {
        return null;
    }

    public static class BooleanBuiltIn
    extends FtlBuiltInDescriptor {
        public BooleanBuiltIn(@NonNls String name, Function<FtlBuiltIn, FtlType> type) {
            super(name, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/freemarker/FtlBuiltInDescriptor$BooleanBuiltIn", "acceptsQualifier"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlBuiltInDescriptor$BooleanBuiltIn", "acceptsQualifier"));
            }
            FtlPsiType type = qualifierType.asInstanceOf(FtlPsiType.class);
            return type != null && (PsiType.BOOLEAN.equals((Object)type.getPsiType()) || type.getPsiType().equalsToText("java.lang.Boolean"));
        }
    }

    public static class HashBuiltIn
    extends FtlBuiltInDescriptor {
        public HashBuiltIn(@NonNls String name, final int typeParam) {
            super(name, (Function<FtlBuiltIn, FtlType>)new NullableFunction<FtlBuiltIn, FtlType>(){

                public FtlType fun(FtlBuiltIn builtIn) {
                    FtlPsiType ftlPsiType = FtlPsiUtil.asInstanceOf(builtIn.getQualifierType(), FtlPsiType.class);
                    if (ftlPsiType != null) {
                        PsiType psiType = ftlPsiType.getPsiType();
                        PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)psiType, (String)"java.util.Map", (int)typeParam, (boolean)true);
                        return new FtlCollectionType(FtlPsiType.wrap(keyType));
                    }
                    return new FtlCollectionType(null);
                }
            });
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/freemarker/FtlBuiltInDescriptor$HashBuiltIn", "acceptsQualifier"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlBuiltInDescriptor$HashBuiltIn", "acceptsQualifier"));
            }
            return HashBuiltIn.isHash(qualifierType);
        }

        public static boolean isHash(FtlType qualifierType) {
            FtlPsiType type = qualifierType.asInstanceOf(FtlPsiType.class);
            if (type == null) {
                return false;
            }
            return FtlPsiUtil.isAssignableToClass(type, "java.util.Map");
        }
    }

    public static class SequenceBuiltIn
    extends FtlBuiltInDescriptor {
        public SequenceBuiltIn(@NonNls String name, NullableFunction<FtlBuiltIn, FtlType> type) {
            super(name, (Function<FtlBuiltIn, FtlType>)type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/freemarker/FtlBuiltInDescriptor$SequenceBuiltIn", "acceptsQualifier"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlBuiltInDescriptor$SequenceBuiltIn", "acceptsQualifier"));
            }
            return FtlListDirective.isCollectionType(qualifierType);
        }
    }

    public static class DateBuiltIn
    extends FtlBuiltInDescriptor {
        public DateBuiltIn(@NonNls String name, Function<FtlBuiltIn, FtlType> type) {
            super(name, type);
        }

        public DateBuiltIn(String name, String camelCaseName, Function<FtlBuiltIn, FtlType> type) {
            super(name, camelCaseName, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/freemarker/FtlBuiltInDescriptor$DateBuiltIn", "acceptsQualifier"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlBuiltInDescriptor$DateBuiltIn", "acceptsQualifier"));
            }
            return qualifierType.asInstanceOf(FtlDateType.class) != null || FtlPsiUtil.isAssignableToClass(qualifierType.asInstanceOf(FtlPsiType.class), "java.util.Date");
        }
    }

    public static class LoopVariableBuiltIn
    extends FtlBuiltInDescriptor {
        public LoopVariableBuiltIn(@NonNls String name, FtlType psiType) {
            super(name, (Function<FtlBuiltIn, FtlType>)new NullableConstantFunction((Object)psiType));
        }

        public LoopVariableBuiltIn(@NonNls String name, Function<FtlBuiltIn, FtlType> type) {
            super(name, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/freemarker/FtlBuiltInDescriptor$LoopVariableBuiltIn", "acceptsQualifier"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlBuiltInDescriptor$LoopVariableBuiltIn", "acceptsQualifier"));
            }
            return qualifierType.asInstanceOf(FtlLoopVariableType.class) != null;
        }
    }

    public static class NodeBuiltIn
    extends FtlBuiltInDescriptor {
        public NodeBuiltIn(@NonNls String name, FtlType psiType) {
            super(name, (Function<FtlBuiltIn, FtlType>)new NullableConstantFunction((Object)psiType));
        }

        public NodeBuiltIn(@NonNls String name, Function<FtlBuiltIn, FtlType> type) {
            super(name, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/freemarker/FtlBuiltInDescriptor$NodeBuiltIn", "acceptsQualifier"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlBuiltInDescriptor$NodeBuiltIn", "acceptsQualifier"));
            }
            return qualifierType.asInstanceOf(FtlNodeType.class) != null;
        }
    }

    public static class StringBuiltIn
    extends FtlBuiltInDescriptor {
        public StringBuiltIn(@NonNls String name, PsiType psiType) {
            super(name, psiType);
        }

        public StringBuiltIn(@NonNls String name, Function<FtlBuiltIn, FtlType> type) {
            super(name, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/freemarker/FtlBuiltInDescriptor$StringBuiltIn", "acceptsQualifier"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlBuiltInDescriptor$StringBuiltIn", "acceptsQualifier"));
            }
            if (!"string".equals(this.getCamelCaseName()) && FtlPsiUtil.isNumeric(qualifierType, context)) {
                return true;
            }
            FtlPsiType psiType = qualifierType.asInstanceOf(FtlPsiType.class);
            return FtlPsiUtil.isAssignableToClass(psiType, "java.lang.String") || FtlPsiUtil.isAssignableToClass(psiType, "java.lang.Enum");
        }
    }

    public static class ObjectBuiltIn
    extends FtlBuiltInDescriptor {
        public ObjectBuiltIn(@NonNls String name, Function<FtlBuiltIn, FtlType> type) {
            super(name, type);
        }

        public ObjectBuiltIn(@NonNls String name, PsiType psiType) {
            super(name, psiType);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/freemarker/FtlBuiltInDescriptor$ObjectBuiltIn", "acceptsQualifier"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlBuiltInDescriptor$ObjectBuiltIn", "acceptsQualifier"));
            }
            return true;
        }
    }

    public static class NumberBuiltIn
    extends FtlBuiltInDescriptor {
        public NumberBuiltIn(@NonNls String name, PsiType psiType) {
            super(name, psiType);
        }

        public NumberBuiltIn(@NonNls String name, Function<FtlBuiltIn, FtlType> type) {
            super(name, type);
        }

        @Override
        public boolean acceptsQualifier(@NotNull FtlType qualifierType, @NotNull PsiElement context) {
            if (qualifierType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierType", "com/intellij/freemarker/FtlBuiltInDescriptor$NumberBuiltIn", "acceptsQualifier"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlBuiltInDescriptor$NumberBuiltIn", "acceptsQualifier"));
            }
            return FtlPsiUtil.isNumeric(qualifierType, context);
        }
    }
}

