/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.FtlBuiltInDescriptor;
import com.intellij.freemarker.FtlBuiltIns;
import com.intellij.freemarker.FtlFileIndex;
import com.intellij.freemarker.FtlIndexInfo;
import com.intellij.freemarker.FtlPathGenerator;
import com.intellij.freemarker.FtlPsiTypeCanonicalLookupElement;
import com.intellij.freemarker.FtlReferenceContributor;
import com.intellij.freemarker.inspections.FtlWellformednessInspection;
import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.lexer.FtlLexer;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlCallableLookupElement;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlStringLiteral;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlDirectiveTokenType;
import com.intellij.freemarker.psi.directives.FtlFileReference;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariable;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.freemarker.psi.files.FtlFileViewProvider;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlCompletionContributor
extends CompletionContributor {
    private static final Key<FtlDirective> DIRECTIVE_KEY = Key.create((String)"FtlDirective");
    private static final PsiElementPattern.Capture<PsiElement> FILE_REFERENCE_PATTERN = (PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(FtlStringLiteral.class).withReference(FtlFileReference.class));

    public FtlCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)FtlElementTypes.START_DIRECTIVE_START).withParent((ElementPattern)PlatformPatterns.psiElement(FtlDirective.class).save(DIRECTIVE_KEY))), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/freemarker/FtlCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/freemarker/FtlCompletionContributor$1", "addCompletions"));
                }
                for (String name : FtlDirectiveTokenType.getAllDirectiveNames()) {
                    if (FtlWellformednessInspection.getWellformednessProblem(name, (FtlDirective)((Object)context.get(DIRECTIVE_KEY)), true) != null) continue;
                    result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)name).bold(), (TailType)TailType.SPACE));
                }
                result.addElement((LookupElement)LookupElementBuilder.create((String)"comment").bold());
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/freemarker/FtlCompletionContributor$2", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/freemarker/FtlCompletionContributor$2", "addCompletions"));
                }
                CharSequence contents = parameters.getOriginalFile().getViewProvider().getContents();
                int offset = parameters.getOffset() - result.getPrefixMatcher().getPrefix().length();
                if (offset > 0 && contents.charAt(offset - 1) == '#') {
                    --offset;
                    result = result.withPrefixMatcher("#" + result.getPrefixMatcher().getPrefix());
                }
                if (offset > 1 && contents.charAt(offset - 1) == '/') {
                    PsiElement ftlLeaf;
                    FtlDirective directive;
                    FtlDirectiveStyle directiveStyle = FtlLexer.guessDirectiveStyle(contents);
                    if (contents.charAt(offset - 2) == directiveStyle.getDirectiveStartChar() && (directive = (FtlDirective)PsiTreeUtil.getParentOfType((PsiElement)(ftlLeaf = parameters.getOriginalFile().getViewProvider().findElementAt(offset - 1, parameters.getOriginalFile().getViewProvider().getBaseLanguage())), FtlDirective.class, (boolean)false)) != null) {
                        char tailChar = directiveStyle.getDirectiveEndChar();
                        LookupElement item = AutoCompletionPolicy.GIVE_CHANCE_TO_OVERWRITE.applyPolicy((LookupElement)LookupElementBuilder.create((String)("#" + directive.getDirectiveName())).bold());
                        result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)item, (TailType)new CharTailType(tailChar)));
                    }
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)FtlElementTypes.IDENTIFIER).withParent(FtlBuiltIn.class), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/freemarker/FtlCompletionContributor$3", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/freemarker/FtlCompletionContributor$3", "addCompletions"));
                }
                FtlBuiltIn builtIn = (FtlBuiltIn)parameters.getPosition().getParent();
                List<FtlBuiltInDescriptor> list = FtlBuiltIns.getBuiltIns(builtIn.getQualifier(), null);
                boolean camelCase = FtlPsiUtil.isUsingCamelCase(builtIn.getContainingFile());
                for (FtlBuiltInDescriptor descriptor : list) {
                    String name;
                    FtlType type = descriptor.getType(builtIn);
                    String string = name = camelCase ? descriptor.getCamelCaseName() : descriptor.getSnakeCaseName();
                    if (type != null) {
                        List<FtlType> allTypes = FtlPsiUtil.getAllTypeComponents(type, FtlType.class);
                        for (FtlType ftlType : allTypes) {
                            if (ftlType instanceof FtlCallableType) {
                                result.addElement((LookupElement)new FtlCallableLookupElement(name, (FtlCallableType)ftlType, true));
                                continue;
                            }
                            result.addElement((LookupElement)LookupElementBuilder.create((String)name).withIcon(PlatformIcons.VARIABLE_ICON).withTypeText(type.getPresentableText()));
                        }
                        continue;
                    }
                    result.addElement((LookupElement)LookupElementBuilder.create((String)name));
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)FtlElementTypes.IDENTIFIER).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)FtlElementTypes.ATTRIBUTE_NAME).withParent((ElementPattern)PlatformPatterns.psiElement(FtlNameValuePair.class).withParent(FtlDirective.class))), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                THashSet attrNames;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/freemarker/FtlCompletionContributor$4", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/freemarker/FtlCompletionContributor$4", "addCompletions"));
                }
                FtlNameValuePair attr = (FtlNameValuePair)parameters.getPosition().getParent().getParent();
                FtlDirective directive = (FtlDirective)attr.getParent();
                if ("ftl".equals(directive.getDirectiveName())) {
                    attrNames = ContainerUtil.newTroveSet(FtlDirectiveTokenType.FTL_ATTRIBUTE_NAMES);
                } else if ("include".equals(directive.getDirectiveName())) {
                    attrNames = ContainerUtil.newTroveSet(FtlDirectiveTokenType.INCLUDE_ATTRIBUTE_NAMES);
                } else if ("setting".equals(directive.getDirectiveName())) {
                    attrNames = ContainerUtil.newTroveSet(FtlDirectiveTokenType.VALID_SETTING_NAMES);
                } else {
                    return;
                }
                for (PsiElement element : directive.getChildren()) {
                    if (element == attr) break;
                    if (!(element instanceof FtlNameValuePair)) continue;
                    attrNames.remove(((FtlNameValuePair)element).getName());
                }
                boolean camelCase = FtlPsiUtil.isUsingCamelCase(directive.getContainingFile());
                for (String name : attrNames) {
                    if (camelCase && name.contains("_") || !camelCase && StringUtil.hasUpperCaseChar((String)name)) continue;
                    result.addElement((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)name), (TailType)new CharTailType('=')));
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)FtlReferenceContributor.FTL_COMMENT, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                String shortcut;
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/freemarker/FtlCompletionContributor$5", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/freemarker/FtlCompletionContributor$5", "addCompletions"));
                }
                PsiComment element = (PsiComment)parameters.getPosition();
                String text = element.getText();
                int typeStart = FtlReferenceContributor.getTypeStartOffset(text);
                int offset = parameters.getOffset() - element.getTextRange().getStartOffset();
                if (offset >= typeStart && FtlReferenceContributor.getTypeEndOffset(text) > offset && !text.contains("name=\"\"") && (shortcut = FtlCompletionContributor.getActionShortcut((String)"SmartTypeCompletion")) != null) {
                    result.addLookupAdvertisement(FreeMarkerBundle.message("smart.completion.inference.hint", shortcut));
                }
            }
        });
        this.extend(CompletionType.SMART, (ElementPattern)FtlReferenceContributor.FTL_COMMENT, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet _result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/freemarker/FtlCompletionContributor$6", "addCompletions"));
                }
                if (_result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_result", "com/intellij/freemarker/FtlCompletionContributor$6", "addCompletions"));
                }
                PsiComment element = (PsiComment)parameters.getPosition();
                String text = element.getText();
                int typeStart = FtlReferenceContributor.getTypeStartOffset(text);
                int offset = parameters.getOffset() - element.getTextRange().getStartOffset();
                if (offset >= typeStart && FtlReferenceContributor.getTypeEndOffset(text) > offset) {
                    CompletionResultSet result = _result.withPrefixMatcher(text.substring(typeStart, offset));
                    FtlFile originalFile = (FtlFile)parameters.getOriginalFile();
                    PsiComment comment = (PsiComment)originalFile.findElementAt(element.getTextRange().getStartOffset());
                    FtlVariable originalVariable = null;
                    if (comment.getParent() instanceof FtlSignatureDirective) {
                        Matcher matcher = FtlFile.VAR_DECL_PATTERN.matcher(comment.getText());
                        if (matcher.matches()) {
                            originalVariable = ((FtlSignatureDirective)comment.getParent()).findParameter(matcher.group(1));
                        }
                    } else {
                        originalVariable = originalFile.findImplicitVariable(comment);
                    }
                    if (originalVariable == null || StringUtil.isEmptyOrSpaces((String)originalVariable.getName())) {
                        return;
                    }
                    Couple pair = FtlCompletionContributor.inferVariableType(originalVariable);
                    FtlCompletionContributor.addInferredTypeItems(element, result, false, (Collection)pair.first);
                    FtlCompletionContributor.addInferredTypeItems(element, result, true, (Collection)pair.second);
                }
            }
        });
        this.extend(null, (ElementPattern)FtlReferenceContributor.FTL_ROOT_COMMENT, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet _result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/freemarker/FtlCompletionContributor$7", "addCompletions"));
                }
                if (_result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_result", "com/intellij/freemarker/FtlCompletionContributor$7", "addCompletions"));
                }
                PsiComment element = (PsiComment)parameters.getPosition();
                Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
                if (module == null) {
                    return;
                }
                VirtualFile currentFile = parameters.getOriginalFile().getVirtualFile();
                String text = element.getText();
                int pathStart = text.indexOf(34);
                int offset = parameters.getOffset() - element.getTextRange().getStartOffset();
                if (pathStart > 0 && offset >= pathStart && text.indexOf(34, pathStart + 1) > offset) {
                    if (parameters.getCompletionType() == CompletionType.CLASS_NAME) {
                        return;
                    }
                    if (parameters.getCompletionType() == CompletionType.BASIC) {
                        String shortcut = FtlCompletionContributor.getActionShortcut((String)"SmartTypeCompletion");
                        if (shortcut != null) {
                            _result.addLookupAdvertisement(FreeMarkerBundle.message("smart.completion.roots.hint", shortcut));
                        }
                        return;
                    }
                    CompletionResultSet result = _result.withPrefixMatcher(text.substring(pathStart + 1, offset));
                    final MultiMap name2Path = new MultiMap();
                    final MultiMap name2File = new MultiMap();
                    FileBasedIndex.ValueProcessor<FtlIndexInfo> processor = new FileBasedIndex.ValueProcessor<FtlIndexInfo>(){

                        public boolean process(VirtualFile file, FtlIndexInfo value) {
                            name2File.putValue((Object)FtlCompletionContributor.removeLocale(file.getNameWithoutExtension()), (Object)file.getParent());
                            for (String s : value.includes) {
                                int sep = s.lastIndexOf(47);
                                String parentPath = sep < 0 ? "" : s.substring(0, sep);
                                String fileName = s.substring(sep + 1);
                                String nameWithoutExtension = StringUtil.getPackageName((String)fileName);
                                name2Path.putValue((Object)FtlCompletionContributor.removeLocale(nameWithoutExtension), (Object)parentPath);
                            }
                            return true;
                        }
                    };
                    FtlCompletionContributor.processAllFtlFiles(module, processor);
                    for (String file : name2Path.keySet()) {
                        Iterator iterator = name2Path.get((Object)file).iterator();
                        while (iterator.hasNext()) {
                            String _parentPath;
                            String parentPath = _parentPath = (String)iterator.next();
                            int parentsCount = 0;
                            while (parentPath.startsWith("/..")) {
                                --parentsCount;
                                parentPath = parentPath.substring(3);
                            }
                            for (VirtualFile parentFile : name2File.get((Object)file)) {
                                String lookupString;
                                String relPath;
                                if (!parentFile.getPath().endsWith(parentPath)) continue;
                                VirtualFile rootCandidate = parentFile;
                                int i = -1;
                                while (rootCandidate != null && (i = parentPath.indexOf(47, i + 1)) >= 0) {
                                    if (parentsCount < 0) {
                                        ++parentsCount;
                                        continue;
                                    }
                                    rootCandidate = rootCandidate.getParent();
                                }
                                if (rootCandidate == null || (relPath = FtlFileReferenceDirective.getRelativePath(currentFile, rootCandidate)) == null) continue;
                                String string = lookupString = relPath.length() == 0 ? "." : relPath;
                                if (lookupString.endsWith("/")) {
                                    lookupString = lookupString.substring(0, lookupString.length() - 1);
                                }
                                result.addElement((LookupElement)LookupElementBuilder.create((String)lookupString).withIcon(PlatformIcons.DIRECTORY_CLOSED_ICON));
                            }
                        }
                    }
                }
            }
        });
        this.extend(CompletionType.BASIC, (ElementPattern)FILE_REFERENCE_PATTERN, new AllFtlFilesProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)FILE_REFERENCE_PATTERN, (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet _result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/freemarker/FtlCompletionContributor$8", "addCompletions"));
                }
                if (_result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_result", "com/intellij/freemarker/FtlCompletionContributor$8", "addCompletions"));
                }
                String shortcut = FtlCompletionContributor.getActionShortcut((String)"CodeCompletion");
                if (shortcut != null) {
                    _result.addLookupAdvertisement(FreeMarkerBundle.message("global.completion.all.ftl.files.hint", shortcut));
                }
            }
        });
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/freemarker/FtlCompletionContributor", "beforeCompletion"));
        }
        FtlStringLiteral literal = (FtlStringLiteral)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), FtlStringLiteral.class, (boolean)false);
        if (literal != null) {
            context.setDummyIdentifier("IntellijIdeaRulezzz");
        }
    }

    public static LookupElement createFileReferenceLookupItem(String lookupString) {
        return LookupElementBuilder.create((String)lookupString).withIcon(FtlFileType.INSTANCE.getIcon());
    }

    public static void processAllFtlFiles(final @NotNull Module module, FileBasedIndex.ValueProcessor<FtlIndexInfo> processor) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/freemarker/FtlCompletionContributor", "processAllFtlFiles"));
        }
        Map ftlFiles = (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, (CachedValueProvider)new CachedValueProvider<Map<VirtualFile, FtlIndexInfo>>(){

            @Nullable
            public CachedValueProvider.Result<Map<VirtualFile, FtlIndexInfo>> compute() {
                final LinkedHashMap result = new LinkedHashMap();
                FileBasedIndex.getInstance().processValues(FtlFileIndex.NAME, (Object)FtlFileIndex.FtlIndexKey.DATA, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<FtlIndexInfo>(){

                    public boolean process(VirtualFile file, FtlIndexInfo value) {
                        result.put(file, value);
                        return true;
                    }
                }, GlobalSearchScope.moduleScope((Module)module));
                return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }
        });
        for (Map.Entry entry : ftlFiles.entrySet()) {
            if (processor.process((VirtualFile)entry.getKey(), entry.getValue())) continue;
            return;
        }
    }

    private static String removeLocale(String name) {
        int i = name.indexOf(95);
        if (i > 0) {
            name = name.substring(0, i);
        }
        return name;
    }

    private static void addInferredTypeItems(PsiComment element, CompletionResultSet result, boolean asStatic, Collection<String> typeNames) {
        for (String typeName : typeNames) {
            try {
                PsiType psiType = JavaPsiFacade.getInstance((Project)element.getProject()).getElementFactory().createTypeFromText(typeName, (PsiElement)element);
                result.addElement((LookupElement)new FtlPsiTypeCanonicalLookupElement(psiType, asStatic));
            }
            catch (IncorrectOperationException incorrectOperationException) {}
        }
    }

    @NotNull
    private static Couple<Collection<String>> inferVariableType(FtlVariable variable) {
        Couple<Collection<String>> couple = FtlCompletionContributor.inferVariableType((Query<PsiReference>)ReferencesSearch.search((PsiElement)variable));
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlCompletionContributor", "inferVariableType"));
        }
        return couple;
    }

    @NotNull
    public static Couple<Collection<String>> inferVariableType(Query<PsiReference> query) {
        Ref intersection = Ref.create(null);
        Ref intersectionStatic = Ref.create(null);
        final Ref onlyScalar = Ref.create(null);
        final ArrayList parentReferences = new ArrayList();
        final ArrayList loopVariables = new ArrayList();
        query.forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference psiReference) {
                FtlQualifiedReference parentReference;
                if (!(psiReference instanceof FtlQualifiedReference)) {
                    return true;
                }
                FtlQualifiedReference reference = (FtlQualifiedReference)psiReference;
                PsiElement parent = reference.getValidExpression().getParent();
                if (parent instanceof FtlInterpolation) {
                    if (onlyScalar.isNull()) {
                        onlyScalar.set((Object)Boolean.TRUE);
                    }
                } else {
                    onlyScalar.set((Object)Boolean.FALSE);
                }
                if ((parentReference = reference.getParentReference()) != null) {
                    String referenceName = parentReference.getReferenceName();
                    if (StringUtil.isNotEmpty((String)referenceName)) {
                        parentReferences.add(parentReference);
                    }
                } else if (parent instanceof FtlListDirective) {
                    FtlLoopVariable loopVariable = ((FtlListDirective)parent).getLoopVariable();
                    if (StringUtil.isEmptyOrSpaces((String)loopVariable.getName())) {
                        return true;
                    }
                    loopVariables.add(loopVariable);
                }
                return true;
            }
        });
        if (onlyScalar.get() == Boolean.TRUE) {
            List<String> classNames = Arrays.asList("java.lang.String", "java.util.Date", "java.lang.Number");
            Couple couple = Couple.of(classNames, Collections.emptyList());
            if (couple == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlCompletionContributor", "inferVariableType"));
            }
            return couple;
        }
        for (FtlQualifiedReference parentReference : parentReferences) {
            Couple<Set<String>> classes = FtlCompletionContributor.suggestClassesWithMember(parentReference);
            FtlCompletionContributor.intersect((Set)classes.first, (Ref<Set<String>>)intersection);
            FtlCompletionContributor.intersect((Set)classes.second, (Ref<Set<String>>)intersectionStatic);
        }
        for (FtlLoopVariable loopVariable : loopVariables) {
            THashSet collections = new THashSet();
            for (String type : (Collection)FtlCompletionContributor.inferVariableType((FtlVariable)loopVariable).first) {
                collections.add("java.util.Collection<" + type + ">");
                collections.add(type + "[]");
            }
            FtlCompletionContributor.intersect((Set<String>)collections, (Ref<Set<String>>)intersection);
        }
        Couple couple = Couple.of((Object)(intersection.isNull() ? Collections.emptySet() : (Set)intersection.get()), intersectionStatic.isNull() ? Collections.emptySet() : (Set)intersectionStatic.get());
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlCompletionContributor", "inferVariableType"));
        }
        return couple;
    }

    public static Couple<Set<String>> suggestClassesWithMember(FtlQualifiedReference reference) {
        FtlFile file = reference.getElement().getContainingFile();
        String referenceName = reference.getReferenceName();
        assert (referenceName != null);
        THashSet classes = new THashSet();
        THashSet classesStatic = new THashSet();
        if (reference.isCall()) {
            CreateFromUsageUtils.addClassesWithMember((String)referenceName, (PsiFile)file, (Set)classes, (boolean)true, (boolean)false);
            CreateFromUsageUtils.addClassesWithMember((String)referenceName, (PsiFile)file, (Set)classesStatic, (boolean)true, (boolean)true);
        } else {
            CreateFromUsageUtils.addClassesWithMember((String)referenceName, (PsiFile)file, (Set)classes, (boolean)false, (boolean)false);
            CreateFromUsageUtils.addClassesWithMember((String)referenceName, (PsiFile)file, (Set)classesStatic, (boolean)false, (boolean)true);
            String getter = PropertyUtil.suggestGetterName((String)referenceName, null);
            CreateFromUsageUtils.addClassesWithMember((String)getter, (PsiFile)file, (Set)classes, (boolean)true, (boolean)false);
            CreateFromUsageUtils.addClassesWithMember((String)getter, (PsiFile)file, (Set)classesStatic, (boolean)true, (boolean)true);
            String isGetter = PropertyUtil.suggestGetterName((String)referenceName, (PsiType)PsiType.BOOLEAN);
            CreateFromUsageUtils.addClassesWithMember((String)isGetter, (PsiFile)file, (Set)classes, (boolean)true, (boolean)false);
            CreateFromUsageUtils.addClassesWithMember((String)isGetter, (PsiFile)file, (Set)classesStatic, (boolean)true, (boolean)true);
        }
        return Couple.of((Object)classes, (Object)classesStatic);
    }

    private static void intersect(Set<String> classes, Ref<Set<String>> to) {
        if (to.isNull()) {
            to.set(classes);
        } else {
            ((Set)to.get()).retainAll(classes);
        }
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/freemarker/FtlCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/freemarker/FtlCompletionContributor", "fillCompletionVariants"));
        }
        if (!(parameters.getOriginalFile().getViewProvider() instanceof FtlFileViewProvider)) {
            return;
        }
        super.fillCompletionVariants(parameters, result);
    }

    private static class AllFtlFilesProvider
    extends CompletionProvider<CompletionParameters> {
        private AllFtlFilesProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet _result) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/freemarker/FtlCompletionContributor$AllFtlFilesProvider", "addCompletions"));
            }
            if (_result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_result", "com/intellij/freemarker/FtlCompletionContributor$AllFtlFilesProvider", "addCompletions"));
            }
            if (parameters.getCompletionType() == CompletionType.BASIC && parameters.getInvocationCount() < 2) {
                return;
            }
            _result.stopHere();
            FtlStringLiteral literal = (FtlStringLiteral)parameters.getPosition().getParent();
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)literal);
            if (module == null) {
                return;
            }
            int endOffsetInLiteral = parameters.getOffset() - literal.getTextRange().getStartOffset();
            String prefix = literal.getText().substring(literal.getValueStartOffset(), endOffsetInLiteral);
            final CompletionResultSet result = _result.withPrefixMatcher(prefix);
            PsiFile file = parameters.getOriginalFile();
            final FtlPathGenerator generator = new FtlPathGenerator(file, module);
            final VirtualFile currentFile = file.getVirtualFile();
            FtlCompletionContributor.processAllFtlFiles(module, new FileBasedIndex.ValueProcessor<FtlIndexInfo>(){

                public boolean process(VirtualFile file, FtlIndexInfo value) {
                    if (currentFile.equals(file)) {
                        return true;
                    }
                    String best = generator.generatePath(file);
                    if (best != null) {
                        result.addElement(FtlCompletionContributor.createFileReferenceLookupItem(best));
                    }
                    return true;
                }
            });
        }
    }
}

