/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInspection.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.freemarker.inspections.FtlInspectionToolProvider;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.files.FtlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class FtlValidator
extends InspectionValidator {
    public FtlValidator() {
        super("FreeMarker", "Checking FreeMarker files...");
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/freemarker/FtlValidator", "isAvailableOnScope"));
        }
        return true;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        return Arrays.asList(context.getProjectCompileScope().getFiles((FileType)FtlFileType.INSTANCE, true));
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = new FtlInspectionToolProvider().getInspectionClasses();
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlValidator", "getInspectionToolClasses"));
        }
        return classArray;
    }

    @NotNull
    public Collection<? extends PsiElement> getDependencies(final PsiFile psiFile) {
        Collection collection = (Collection)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Collection<PsiFile>>(){

            public Collection<PsiFile> compute() {
                final HashSet<PsiFile> result = new HashSet<PsiFile>();
                psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                    public void visitElement(PsiElement element) {
                        super.visitElement(element);
                        PsiReference reference = element.getReference();
                        if (reference instanceof FtlQualifiedReference) {
                            for (ResolveResult resolveResult : ((FtlQualifiedReference)reference).multiResolve(true)) {
                                PsiElement target = resolveResult.getElement();
                                if (target == null) continue;
                                ContainerUtil.addIfNotNull((Collection)result, (Object)target.getContainingFile());
                            }
                        }
                    }
                });
                return result;
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlValidator", "getDependencies"));
        }
        return collection;
    }

    @NotNull
    public Map<ProblemDescriptor, HighlightDisplayLevel> checkAdditionally(PsiFile topFile) {
        InspectionManager manager = InspectionManager.getInstance((Project)topFile.getProject());
        LinkedHashMap map = new LinkedHashMap();
        for (Pair pair : DefaultHighlightVisitorBasedInspection.runGeneralHighlighting((PsiFile)topFile, (boolean)true, (boolean)true, (boolean)false)) {
            HighlightInfo info = (HighlightInfo)pair.second;
            ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)pair.first, new TextRange(info.startOffset, info.endOffset), info.getDescription(), HighlightInfo.convertType((HighlightInfoType)info.type), false, new LocalQuickFix[0]);
            map.put((Object)descriptor, (Object)(info.type == HighlightInfoType.ERROR ? HighlightDisplayLevel.ERROR : HighlightDisplayLevel.WARNING));
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/FtlValidator", "checkAdditionally"));
        }
        return linkedHashMap;
    }
}

