/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlDirectiveTokenType;
import com.intellij.freemarker.psi.directives.FtlDirectiveType;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StringPattern;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlWellformednessInspection
extends FtlSuppressableInspection {
    private static final StringPattern NON_ID_PATTERN = PlatformPatterns.string().contains((ElementPattern)PlatformPatterns.not((ElementPattern)PlatformPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.character().javaIdentifierPart(), PlatformPatterns.character().oneOf((Object[])new Character[]{Character.valueOf('.')})})));

    @Nullable
    public static String getWellformednessProblem(String directiveName, final FtlDirective directive, boolean forCompletion) {
        if (forCompletion && "foreach".equals(directiveName)) {
            return "";
        }
        boolean isElse = "else".equals(directiveName);
        PsiElement parent = directive.getParent();
        if (!(!isElse && !"elseIf".equalsIgnoreCase(directiveName) || FtlDirectiveType.isDirective(parent, "if") || !directiveName.equals(directive.getDirectiveName()) && parent != null && FtlDirectiveType.isDirective(parent.getParent(), "if"))) {
            if (FtlDirectiveType.isDirective(parent, "list")) {
                return null;
            }
            return FreeMarkerBundle.message("no.matching.0.directive", "if/list");
        }
        if (isElse && parent instanceof FtlDirective) {
            FtlDirective ftlDirective = (FtlDirective)parent;
            List subDirectives = ContainerUtil.findAll((Object[])ftlDirective.getSubDirectives(), (Condition)new Condition<FtlDirective>(){

                public boolean value(FtlDirective ftlDirective) {
                    return "else".equals(ftlDirective.getDirectiveName()) || "elseIf".equalsIgnoreCase(ftlDirective.getDirectiveName()) || ftlDirective == directive;
                }
            });
            int index = subDirectives.indexOf((Object)directive);
            assert (index >= 0);
            if (index != subDirectives.size() - 1) {
                return FreeMarkerBundle.message("else.should.finish.if", new Object[0]);
            }
        }
        if (("case".equals(directiveName) || "default".equals(directiveName)) && !FtlDirectiveType.isDirective(parent, "switch")) {
            return FreeMarkerBundle.message("no.matching.0.directive", "switch");
        }
        if ("break".equals(directiveName) && FtlWellformednessInspection.findSuperDirective((PsiElement)directive, "case", "default", "list", "items") == null) {
            return FreeMarkerBundle.message("no.matching.0.directive", "switch/loop");
        }
        if ("sep".equals(directiveName) && !FtlDirectiveType.isDirective(parent, "list", "items")) {
            return FreeMarkerBundle.message("no.matching.0.directive", "loop");
        }
        if ("list".equals(directiveName) && directive instanceof FtlListDirective && !forCompletion) {
            FtlDirective ftlDirective = (FtlDirective)((Object)ContainerUtil.find((Object[])directive.getSubDirectives(), (Condition)new Condition<FtlDirective>(){

                public boolean value(FtlDirective child) {
                    return FtlDirectiveType.isDirective((PsiElement)child, "items");
                }
            }));
            PsiElement varName = ((FtlListDirective)directive).getNameElement();
            if (ftlDirective == null && varName == null) {
                return "'as' (loop variable name) missing";
            }
            if (ftlDirective != null && varName != null) {
                return "The parent #list of the #items must not have \"as " + varName.getText() + "\" parameter";
            }
        }
        if ("noEscape".equalsIgnoreCase(directiveName)) {
            final int[] nArray = new int[]{-1};
            FtlWellformednessInspection.processParentDirectives(parent, new Processor<FtlDirective>(){

                public boolean process(FtlDirective ftlDirective) {
                    if (FtlDirectiveType.isDirective((PsiElement)ftlDirective, "escape")) {
                        nArray[0] = nArray[0] + 1;
                    } else if (FtlDirectiveType.isDirective((PsiElement)ftlDirective, "noEscape")) {
                        nArray[0] = nArray[0] - 1;
                    }
                    return nArray[0] != 0;
                }
            });
            if (nArray[0] < 0) {
                return FreeMarkerBundle.message("no.matching.0.directive", "escape");
            }
        }
        if ("ftl".equals(directiveName) && StringUtil.isNotEmpty((String)directive.getContainingFile().getText().substring(0, directive.getTextRange().getStartOffset()).trim())) {
            return FreeMarkerBundle.message("ftl.should.start.file", new Object[0]);
        }
        if ("macro".equals(directiveName) || "function".equals(directiveName)) {
            if (!FtlWellformednessInspection.processParentDirectives(parent, new Processor<FtlDirective>(){

                public boolean process(FtlDirective directive) {
                    return !FtlDirectiveType.isDirective((PsiElement)directive, "macro", "function");
                }
            })) {
                return FreeMarkerBundle.message("macro.function.nesting", new Object[0]);
            }
            return null;
        }
        if (("fallback".equals(directiveName) || "nested".equals(directiveName)) && FtlWellformednessInspection.findSuperDirective(parent, "macro") == null) {
            return FreeMarkerBundle.message("can.only.occur.inside", directiveName, "macro");
        }
        if (("return".equals(directiveName) || "local".equals(directiveName)) && FtlWellformednessInspection.findSuperDirective(parent, "function", "macro") == null) {
            return FreeMarkerBundle.message("can.only.occur.inside.or", "#ref", "function", "macro");
        }
        if ("recover".equals(directiveName)) {
            FtlDirective subDirective;
            if (!FtlDirectiveType.isDirective(parent, "attempt")) {
                return FreeMarkerBundle.message("recover.inside.attempt", new Object[0]);
            }
            FtlDirective[] ftlDirectiveArray = ((FtlDirective)parent).getSubDirectives();
            int n = ftlDirectiveArray.length;
            for (int i = 0; i < n && (subDirective = ftlDirectiveArray[i]) != directive; ++i) {
                if (!FtlDirectiveType.isDirective((PsiElement)subDirective, "recover")) continue;
                return FreeMarkerBundle.message("recover.once", new Object[0]);
            }
        }
        if (!forCompletion && "attempt".equals(directiveName)) {
            for (FtlDirective subDirective : directive.getSubDirectives()) {
                if (!FtlDirectiveType.isDirective((PsiElement)subDirective, "recover")) continue;
                return null;
            }
            return FreeMarkerBundle.message("recover.expected", new Object[0]);
        }
        boolean bl = FtlPsiUtil.isUsingCamelCase(directive.getContainingFile());
        if (FtlDirectiveTokenType.getLowerCaseDirectiveNames().contains(directiveName) && bl || !bl && StringUtil.hasUpperCaseChar((String)directiveName)) {
            return FreeMarkerBundle.message("error.mixing.camelcase.lowercase", new Object[0]);
        }
        return null;
    }

    @Nullable
    private static FtlDirective findSuperDirective(PsiElement element, String ... superDirectiveNames) {
        PsiElement parent = element;
        while (!(parent instanceof PsiFile)) {
            if (FtlDirectiveType.isDirective(parent, superDirectiveNames)) {
                return (FtlDirective)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static boolean processParentDirectives(PsiElement element, Processor<FtlDirective> processor) {
        PsiElement parent = element;
        while (!(parent instanceof PsiFile)) {
            if (parent instanceof FtlDirective && !processor.process((Object)((FtlDirective)parent))) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/freemarker/inspections/FtlWellformednessInspection", "buildVisitor"));
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                FtlMacro ftlMacro;
                List refs;
                if (element instanceof FtlDirective) {
                    FtlDirective directive = (FtlDirective)element;
                    PsiElement nameElement = directive.getStartTagNameElement();
                    if (nameElement == null) {
                        return;
                    }
                    if (directive.needsClosing() && !directive.isClosed()) {
                        holder.registerProblem(nameElement, FreeMarkerBundle.message("unclosed.directive", new Object[0]), new LocalQuickFix[0]);
                        return;
                    }
                    PsiElement endName = directive.getEndTagNameElement();
                    if (endName != null && !endName.textMatches(nameElement)) {
                        holder.registerProblem(endName, "'" + nameElement.getText() + "' expected", new LocalQuickFix[0]);
                        return;
                    }
                    String message = FtlWellformednessInspection.getWellformednessProblem(nameElement.getText(), directive, false);
                    if (message != null) {
                        holder.registerProblem(nameElement, message, new LocalQuickFix[0]);
                    }
                }
                if (element instanceof FtlMacro && (refs = ContainerUtil.findAll((Object[])(ftlMacro = (FtlMacro)element).getChildren(), FtlExpression.class)).size() == 2) {
                    String startText = ((FtlExpression)refs.get(0)).getText().replaceAll(" ", "");
                    if (!startText.equals(((FtlExpression)refs.get(1)).getText().replaceAll(" ", ""))) {
                        holder.registerProblem((PsiElement)refs.get(1), FreeMarkerBundle.message("wrong.closing.directive.name", new Object[0]), new LocalQuickFix[0]);
                    }
                    if (NON_ID_PATTERN.accepts((Object)startText)) {
                        holder.registerProblem((PsiElement)refs.get(1), PsiBundle.message((String)"0.expected", (Object[])new Object[]{ftlMacro.getText().startsWith("<") ? ">" : "]"}), new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlWellformednessInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlWellformednessInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlWellformednessInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FreeMarkerBundle.message("ftl.wellformedness.inspection", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlWellformednessInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("FtlWellformednessInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/inspections/FtlWellformednessInspection", "getShortName"));
        }
        return "FtlWellformednessInspection";
    }
}

