/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.lexer;

import com.intellij.freemarker.lexer.FtlDirectiveStyle;
import com.intellij.freemarker.lexer._FtlLexer;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlTokenType;
import com.intellij.freemarker.psi.directives.FtlDirectiveTokenType;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LookAheadLexer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlLexer
extends LookAheadLexer {
    @NonNls
    private static final Map<String, FtlTokenType> ourKeywords = new THashMap();
    public static final TokenSet MARKUP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{FtlElementTypes.START_DIRECTIVE_START, FtlElementTypes.START_MACRO_START, FtlElementTypes.END_MACRO_START, FtlElementTypes.END_DIRECTIVE_START, FtlElementTypes.EL_START, FtlElementTypes.NUM_EL_START, FtlElementTypes.TERSE_COMMENT_START, FtlElementTypes.COMMENT_START, FtlElementTypes.EMPTY_MACRO_END});
    private final _FtlLexer myRawLexer;

    private FtlLexer(_FtlLexer rawLexer) {
        super((Lexer)new FlexAdapter((FlexLexer)rawLexer));
        this.myRawLexer = rawLexer;
    }

    public void clearStyle() {
        this.myRawLexer.myStyle = null;
    }

    @NotNull
    public static FtlDirectiveStyle guessDirectiveStyle(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/freemarker/lexer/FtlLexer", "guessDirectiveStyle"));
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document != null) {
            FtlDirectiveStyle ftlDirectiveStyle = FtlLexer.guessDirectiveStyle(document.getCharsSequence());
            if (ftlDirectiveStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/lexer/FtlLexer", "guessDirectiveStyle"));
            }
            return ftlDirectiveStyle;
        }
        FtlDirectiveStyle ftlDirectiveStyle = FtlLexer.guessDirectiveStyle(LoadTextUtil.loadText((VirtualFile)file));
        if (ftlDirectiveStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/lexer/FtlLexer", "guessDirectiveStyle"));
        }
        return ftlDirectiveStyle;
    }

    @NotNull
    public static FtlDirectiveStyle guessDirectiveStyle(CharSequence sequence) {
        FtlLexer lexer = FtlLexer.createLexer();
        lexer.start(sequence);
        while (lexer.getStyle() == null && lexer.getTokenType() != null) {
            lexer.advance();
        }
        FtlDirectiveStyle style = lexer.getStyle();
        FtlDirectiveStyle ftlDirectiveStyle = style == null ? FtlDirectiveStyle.ANGLE : style;
        if (ftlDirectiveStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/lexer/FtlLexer", "guessDirectiveStyle"));
        }
        return ftlDirectiveStyle;
    }

    @Nullable
    private IElementType mergeTokens(Lexer baseLexer, TokenSet until, FtlTokenType intoType) {
        if (FtlLexer.skipTokens(baseLexer, until)) {
            this.addToken(baseLexer.getTokenStart(), (IElementType)intoType);
        }
        return baseLexer.getTokenType();
    }

    private static boolean skipTokens(Lexer baseLexer, TokenSet until) {
        boolean skipped = false;
        IElementType tokenType;
        while ((tokenType = baseLexer.getTokenType()) != null && !until.contains(tokenType)) {
            skipped = true;
            baseLexer.advance();
        }
        return skipped;
    }

    protected void lookAhead(Lexer baseLexer) {
        IElementType tokenType = baseLexer.getTokenType();
        if (tokenType == null) {
            super.lookAhead(baseLexer);
            return;
        }
        if (!MARKUP_TOKENS.contains(tokenType)) {
            this.mergeTokens(baseLexer, MARKUP_TOKENS, FtlElementTypes.TEMPLATE_TEXT);
            return;
        }
        if (tokenType == FtlElementTypes.TERSE_COMMENT_START) {
            this.terseComment(baseLexer);
        } else if (tokenType == FtlElementTypes.COMMENT_START) {
            this.advanceLexer(baseLexer);
            this.mergeTokens(baseLexer, TokenSet.create((IElementType[])new IElementType[]{FtlElementTypes.COMMENT_END}), FtlElementTypes.COMMENT_TEXT);
            this.advanceLexer(baseLexer);
        } else if (tokenType == FtlElementTypes.START_DIRECTIVE_START || tokenType == FtlElementTypes.END_DIRECTIVE_START) {
            this.tokenizeDirective(baseLexer);
        } else if (tokenType == FtlElementTypes.START_MACRO_START || tokenType == FtlElementTypes.END_MACRO_START) {
            this.advanceLexer(baseLexer);
            while (baseLexer.getTokenType() == FtlElementTypes.IDENTIFIER || baseLexer.getTokenType() == FtlElementTypes.DOT) {
                this.advanceLexer(baseLexer);
            }
            if (baseLexer.getTokenType() == FtlElementTypes.WHITE_SPACE) {
                this.advanceAs(baseLexer, (IElementType)FtlElementTypes.TERMINATING_WHITE_SPACE);
            }
            this.tokenizeFtlCode(baseLexer, true);
        } else if (tokenType == FtlElementTypes.EL_START || tokenType == FtlElementTypes.NUM_EL_START) {
            this.interpolation(baseLexer);
        } else {
            super.lookAhead(baseLexer);
        }
    }

    private void tokenizeDirective(Lexer baseLexer) {
        String directiveName;
        FtlDirectiveTokenType directiveTokenType;
        this.advanceLexer(baseLexer);
        if ((baseLexer.getTokenType() == FtlElementTypes.IDENTIFIER || baseLexer.getTokenType() == FtlElementTypes.LT) && (directiveTokenType = FtlDirectiveTokenType.getDirectiveToken(directiveName = baseLexer.getTokenText())) != null) {
            this.advanceAs(baseLexer, (IElementType)directiveTokenType);
            this.handleNoParse(baseLexer, directiveName, directiveTokenType);
        }
        this.tokenizeFtlCode(baseLexer, true);
    }

    private void handleNoParse(Lexer baseLexer, String directiveName, FtlDirectiveTokenType directiveTokenType) {
        if (!"noParse".equalsIgnoreCase(directiveName) || !this.isDirectiveEnd(baseLexer.getTokenType())) {
            return;
        }
        this.advanceAs(baseLexer, (IElementType)FtlElementTypes.DIRECTIVE_END);
        int bodyStart = baseLexer.getTokenStart();
        while (true) {
            IElementType type;
            if ((type = baseLexer.getTokenType()) == null) {
                if (baseLexer.getTokenStart() > bodyStart) {
                    this.addToken((IElementType)FtlElementTypes.TEMPLATE_TEXT);
                }
                return;
            }
            if (type == FtlElementTypes.END_DIRECTIVE_START) {
                int bodyEnd = baseLexer.getTokenStart();
                baseLexer.advance();
                if (baseLexer.getTokenType() != FtlElementTypes.IDENTIFIER || !directiveName.equals(baseLexer.getTokenText())) continue;
                if (bodyEnd > bodyStart) {
                    this.addToken(bodyEnd, (IElementType)FtlElementTypes.TEMPLATE_TEXT);
                }
                this.addToken(baseLexer.getTokenStart(), (IElementType)FtlElementTypes.END_DIRECTIVE_START);
                this.advanceAs(baseLexer, (IElementType)directiveTokenType);
                return;
            }
            baseLexer.advance();
        }
    }

    private void terseComment(Lexer baseLexer) {
        FtlLexer.skipTokens(baseLexer, TokenSet.create((IElementType[])new IElementType[]{FtlElementTypes.TERSE_COMMENT_END}));
        this.advanceAs(baseLexer, (IElementType)(baseLexer.getTokenType() == FtlElementTypes.TERSE_COMMENT_END ? FtlElementTypes.COMMENT_TEXT : FtlElementTypes.TERSE_COMMENT_START));
    }

    private void tokenizeFtlCode(Lexer baseLexer, boolean directive) {
        IElementType next;
        int parenNesting = 0;
        int bracketNesting = 0;
        int braceNesting = 0;
        while ((next = baseLexer.getTokenType()) != null) {
            IElementType type;
            if (directive) {
                if (this.isDirectiveEnd(next) && (this.getStyle() == FtlDirectiveStyle.ANGLE ? parenNesting : bracketNesting) == 0) {
                    this.advanceAs(baseLexer, (IElementType)FtlElementTypes.DIRECTIVE_END);
                    break;
                }
                if (next == FtlElementTypes.EMPTY_DIRECTIVE_END) {
                    this.advanceLexer(baseLexer);
                    break;
                }
            } else if (FtlElementTypes.RIGHT_BRACE == next && braceNesting == 0) {
                this.advanceAs(baseLexer, (IElementType)FtlElementTypes.EL_END);
                break;
            }
            if (next == FtlElementTypes.LEFT_PAREN) {
                ++parenNesting;
            }
            if (next == FtlElementTypes.RIGHT_PAREN) {
                --parenNesting;
            }
            if (next == FtlElementTypes.LEFT_BRACKET) {
                ++bracketNesting;
            }
            if (next == FtlElementTypes.RIGHT_BRACKET) {
                --bracketNesting;
            }
            if (next == FtlElementTypes.LEFT_BRACE) {
                ++braceNesting;
            }
            if (next == FtlElementTypes.RIGHT_BRACE) {
                --braceNesting;
            }
            if (next == FtlElementTypes.JUST_GT) {
                baseLexer.advance();
                if (baseLexer.getTokenType() == FtlElementTypes.EQ) {
                    this.advanceAs(baseLexer, (IElementType)FtlElementTypes.GTE);
                    continue;
                }
                this.addToken(baseLexer.getTokenStart(), (IElementType)FtlElementTypes.GT);
                continue;
            }
            if (next == FtlElementTypes.EL_START || next == FtlElementTypes.NUM_EL_START) {
                if (directive) {
                    this.interpolation(baseLexer);
                    continue;
                }
                this.addToken(baseLexer.getTokenEnd() - 1, (IElementType)FtlElementTypes.IDENTIFIER);
                this.advanceAs(baseLexer, (IElementType)FtlElementTypes.LEFT_BRACE);
                continue;
            }
            if (next == FtlElementTypes.DOLLAR) {
                baseLexer.advance();
                if (baseLexer.getTokenType() == FtlElementTypes.IDENTIFIER) {
                    this.advanceAs(baseLexer, (IElementType)FtlElementTypes.IDENTIFIER);
                    continue;
                }
                this.addToken(baseLexer.getTokenStart(), FtlElementTypes.DOLLAR);
                continue;
            }
            if (next == FtlElementTypes.SHARP) {
                this.advanceAs(baseLexer, FtlElementTypes.BAD_CHARACTER);
                continue;
            }
            if (next == FtlElementTypes.TERSE_COMMENT_START) {
                this.terseComment(baseLexer);
                continue;
            }
            if (next == FtlElementTypes.START_DIRECTIVE_START || next == FtlElementTypes.END_DIRECTIVE_START) {
                this.tokenizeDirective(baseLexer);
                continue;
            }
            if (next == FtlElementTypes.IDENTIFIER && this.handleIdentifier(baseLexer)) continue;
            this.advanceLexer(baseLexer);
            if (next == FtlElementTypes.SINGLE_QUOTE || next == FtlElementTypes.DOUBLE_QUOTE) {
                this.tokenizeString(baseLexer, next, false);
                continue;
            }
            if (next != FtlElementTypes.DOT || (type = baseLexer.getTokenType()) != FtlElementTypes.ASTERISK && !ourKeywords.containsKey(baseLexer.getTokenText())) continue;
            this.advanceAs(baseLexer, (IElementType)FtlElementTypes.IDENTIFIER);
        }
    }

    private boolean isDirectiveEnd(IElementType next) {
        return next == (this.getStyle() == FtlDirectiveStyle.ANGLE ? FtlElementTypes.JUST_GT : FtlElementTypes.RIGHT_BRACKET);
    }

    private boolean handleIdentifier(Lexer baseLexer) {
        if (baseLexer.getTokenEnd() == baseLexer.getTokenStart() + 1 && "r".equals(baseLexer.getTokenText())) {
            baseLexer.advance();
            IElementType afterR = baseLexer.getTokenType();
            if (afterR == FtlElementTypes.SINGLE_QUOTE) {
                this.advanceAs(baseLexer, (IElementType)FtlElementTypes.R_SINGLE_QUOTE);
                this.tokenizeString(baseLexer, (IElementType)FtlElementTypes.SINGLE_QUOTE, true);
            } else if (afterR == FtlElementTypes.DOUBLE_QUOTE) {
                this.advanceAs(baseLexer, (IElementType)FtlElementTypes.R_DOUBLE_QUOTE);
                this.tokenizeString(baseLexer, (IElementType)FtlElementTypes.DOUBLE_QUOTE, true);
            } else {
                this.addToken(baseLexer.getTokenStart(), (IElementType)FtlElementTypes.IDENTIFIER);
            }
            return true;
        }
        return false;
    }

    private void tokenizeString(Lexer baseLexer, IElementType quote, boolean raw) {
        while (true) {
            IElementType next;
            if ((next = this.mergeTokens(baseLexer, raw ? TokenSet.create((IElementType[])new IElementType[]{quote}) : TokenSet.create((IElementType[])new IElementType[]{quote, FtlElementTypes.CHAR_ESCAPE, FtlElementTypes.EL_START, FtlElementTypes.NUM_EL_START}), FtlElementTypes.STRING_TEXT)) == FtlElementTypes.CHAR_ESCAPE) {
                this.advanceLexer(baseLexer);
                continue;
            }
            if (next == quote) {
                this.advanceLexer(baseLexer);
                return;
            }
            if (next != FtlElementTypes.EL_START && next != FtlElementTypes.NUM_EL_START) break;
            this.interpolation(baseLexer);
        }
    }

    private void interpolation(Lexer baseLexer) {
        this.advanceLexer(baseLexer);
        this.tokenizeFtlCode(baseLexer, false);
    }

    public static FtlLexer createLexer() {
        return new FtlLexer(new _FtlLexer());
    }

    @Nullable
    public FtlDirectiveStyle getStyle() {
        return this.myRawLexer.myStyle;
    }

    static {
        ourKeywords.put("true", FtlElementTypes.BOOLEAN);
        ourKeywords.put("false", FtlElementTypes.BOOLEAN);
        ourKeywords.put("gt", FtlElementTypes.GT);
        ourKeywords.put("gte", FtlElementTypes.GTE);
        ourKeywords.put("lt", FtlElementTypes.LT);
        ourKeywords.put("lte", FtlElementTypes.LTE);
        ourKeywords.put("as", FtlElementTypes.AS);
        ourKeywords.put("in", FtlElementTypes.IN);
        ourKeywords.put("using", FtlElementTypes.USING);
    }
}

