/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.FtlEnumReference;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlIndexExpression;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlLiteralExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlReferenceQualifier;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.injected.StringLiteralEscaper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlStringLiteral
extends FtlLiteralExpression
implements PsiLanguageInjectionHost {
    @NonNls
    private static final Set<String> SPRING_PROPERTY_MACROS = new THashSet(Arrays.asList("message", "messageText", "messageArgs", "messageAsText", "messageArgsText", "theme", "themeArgs", "themeArgsText", "themeText"));

    public FtlStringLiteral(ASTNode node) {
        super(node);
    }

    @Override
    public Object getConstantValue() {
        String s = this.getValueText();
        return !this.isRaw() && (s.contains("$") || s.contains("#")) ? null : s;
    }

    private boolean isRaw() {
        return this.getText().startsWith("r");
    }

    @NotNull
    public String getValueText() {
        String s = this.getText();
        if (s.startsWith("r")) {
            s = s.substring(1);
        }
        if (s.startsWith("\"") || s.startsWith("'")) {
            s = s.substring(1);
        }
        if (s.endsWith("\"") || s.endsWith("'")) {
            s = s.substring(0, s.length() - 1);
        }
        String string = s;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlStringLiteral", "getValueText"));
        }
        return string;
    }

    public int getValueStartOffset() {
        return this.getText().startsWith("r") ? 2 : 1;
    }

    @NotNull
    public PsiReference[] getReferences() {
        CachedValuesManager.getManager((Project)this.getProject());
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getCachedValue((PsiElement)this, (CachedValueProvider)new CachedValueProvider<PsiReference[]>(){

            @Nullable
            public CachedValueProvider.Result<PsiReference[]> compute() {
                return CachedValueProvider.Result.create((Object)FtlStringLiteral.this.calcReferences(), (Object[])new Object[]{FtlStringLiteral.this});
            }
        });
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlStringLiteral", "getReferences"));
        }
        return psiReferenceArray;
    }

    private PsiReference[] calcReferences() {
        FtlIndexExpression expression;
        for (PsiElement element : this.getChildren()) {
            if (!(element instanceof FtlInterpolation)) continue;
            return PsiReference.EMPTY_ARRAY;
        }
        PsiElement parent = this.getParent();
        final String valueText = this.getValueText();
        if (parent instanceof FtlIndexExpression && this == (expression = (FtlIndexExpression)parent).getExpression(1)) {
            return new PsiReference[]{new FtlQualifiedReference(expression){

                @Override
                public String getReferenceName() {
                    return valueText;
                }

                @Override
                @NotNull
                public FtlExpression getElement() {
                    FtlStringLiteral ftlStringLiteral = FtlStringLiteral.this;
                    if (ftlStringLiteral == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlStringLiteral$2", "getElement"));
                    }
                    return ftlStringLiteral;
                }

                @Override
                public FtlReferenceQualifier getReferenceQualifier() {
                    return expression.getReferenceQualifier();
                }

                public TextRange getRangeInElement() {
                    return FtlStringLiteral.this.getValueRange();
                }

                @Override
                public PsiElement doHandleElementRename(String newElementName) throws IncorrectOperationException {
                    return FtlStringLiteral.this.setStringValue(this.getRangeInElement(), newElementName);
                }
            }};
        }
        if (parent instanceof FtlFileReferenceDirective) {
            return FtlFileReferenceDirective.createFileReferences(this);
        }
        if (!valueText.contains(" ")) {
            return new PsiReference[]{new FtlEnumReference(this), new PropertyReference(valueText, this, null, false){

                public TextRange getRangeInElement() {
                    return FtlStringLiteral.this.getValueRange();
                }
            }};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public FtlType getType() {
        return FtlPsiType.wrap((PsiType)PsiType.getJavaLangString((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope()));
    }

    public TextRange getValueRange() {
        int start = 0;
        String text = this.getText();
        if (text.length() > 0 && text.charAt(0) == 'r') {
            ++start;
        }
        if (text.length() > start && FtlStringLiteral.isQuote(text.charAt(start))) {
            ++start;
        }
        int end = text.length();
        if (text.length() > 0 && end > start && FtlStringLiteral.isQuote(text.charAt(end - 1))) {
            --end;
        }
        return new TextRange(start, end);
    }

    public boolean isValidHost() {
        return true;
    }

    public FtlStringLiteral updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/freemarker/psi/FtlStringLiteral", "updateText"));
        }
        this.setStringValue(this.getValueRange(), text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<FtlStringLiteral> createLiteralTextEscaper() {
        StringLiteralEscaper stringLiteralEscaper = new StringLiteralEscaper((PsiLanguageInjectionHost)this);
        if (stringLiteralEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlStringLiteral", "createLiteralTextEscaper"));
        }
        return stringLiteralEscaper;
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    public FtlStringLiteral setStringValue(TextRange range, String newContent) {
        String oldText = this.getText();
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiElement newElement = FtlPsiUtil.parseFtlExpression(newText, this.getProject());
        PsiElement parent = this.getParent();
        ASTNode newNode = newElement.getNode();
        parent.getNode().replaceChild(this.getNode(), newNode);
        return (FtlStringLiteral)newNode.getPsi();
    }
}

