/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlParser;
import com.intellij.freemarker.psi.FtlTokenType;
import com.intellij.freemarker.psi.directives.FtlAssignDirective;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.freemarker.psi.directives.FtlDirectiveNames;
import com.intellij.freemarker.psi.directives.FtlDirectiveType;
import com.intellij.freemarker.psi.directives.FtlEscapeDirective;
import com.intellij.freemarker.psi.directives.FtlIfDirective;
import com.intellij.freemarker.psi.directives.FtlImportDirective;
import com.intellij.freemarker.psi.directives.FtlIncludeDirective;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.directives.FtlNestedDirective;
import com.intellij.freemarker.psi.directives.FtlRecoverDirective;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.directives.FtlSwitchDirective;
import com.intellij.freemarker.psi.directives.FtlVisitDirective;
import com.intellij.lang.ASTNode;
import com.intellij.lang.pratt.MutableMarker;
import com.intellij.lang.pratt.PrattBuilder;
import com.intellij.lang.pratt.PrattParsingUtil;
import com.intellij.lang.pratt.PrattTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlDirectiveTokenType
extends FtlTokenType
implements FtlDirectiveNames {
    public static final Set<String> INCLUDE_ATTRIBUTE_NAMES = ContainerUtil.newTroveSet((Object[])new String[]{"parse", "encoding"});
    public static final Set<String> FTL_ATTRIBUTE_NAMES = ContainerUtil.newTroveSet((Object[])new String[]{"encoding", "strip_whitespace", "stripWhitespace", "strip_text", "stripText", "strict_syntax", "strictSyntax", "ns_prefixes", "nsPrefixes", "attributes"});
    public static final Set<String> VALID_SETTING_NAMES = ContainerUtil.newTroveSet((Object[])new String[]{"locale", "number_format", "numberFormat", "boolean_format", "booleanFormat", "date_format", "dateFormat", "time_format", "timeFormat", "datetime_format", "datetimeFormat", "time_zone", "timeZone", "sql_date_and_time_time_zone", "sqlDateAndTimeTimeZone", "url_escaping_charset", "urlEscapingCharset", "output_encoding", "outputEncoding", "classic_compatible", "classicCompatible"});
    private static final Map<String, FtlDirectiveTokenType> ourDirectiveNames = ContainerUtil.newTroveMap();
    private static final Set<String> ourLowerCaseDirectiveNames = ContainerUtil.newTroveSet();
    private final FtlDirectiveType myDirectiveType;
    public static final PrattTokenType[] DIRECTIVE_CLOSING_TOKENS = new PrattTokenType[]{FtlElementTypes.DIRECTIVE_END, FtlElementTypes.EMPTY_DIRECTIVE_END, FtlElementTypes.START_DIRECTIVE_START, FtlElementTypes.START_MACRO_START, FtlElementTypes.END_DIRECTIVE_START, FtlElementTypes.END_MACRO_START, FtlElementTypes.EL_START, FtlElementTypes.NUM_EL_START};

    private static void parseAttributeList(PrattBuilder builder, Set<String> attributeNames, String nameExpectedMessage) {
        while (builder.isToken((IElementType)FtlElementTypes.IDENTIFIER)) {
            MutableMarker pair = builder.mark();
            MutableMarker attrName = builder.mark();
            if (!attributeNames.contains(builder.getTokenText())) {
                builder.error(nameExpectedMessage);
            }
            builder.advance();
            attrName.finish((IElementType)FtlElementTypes.ATTRIBUTE_NAME);
            if (builder.assertToken((PrattTokenType)FtlElementTypes.EQ)) {
                builder.createChildBuilder(30).parse();
            }
            pair.finish((IElementType)FtlElementTypes.NAME_VALUE_PAIR);
        }
        FtlDirectiveTokenType.closeDirective(builder, true);
    }

    private static void addDirective(FtlDirectiveTokenType type) {
        String name = type.getDirectiveName();
        ourDirectiveNames.put(name, type);
        String lowerCase = name.toLowerCase();
        if (!lowerCase.equals(name)) {
            ourDirectiveNames.put(lowerCase, type);
            ourLowerCaseDirectiveNames.add(lowerCase);
        }
    }

    private FtlDirectiveTokenType(@NonNls String directiveName, boolean expectsClosing) {
        this(new FtlDirectiveType(directiveName, expectsClosing));
    }

    protected FtlDirectiveTokenType(@NonNls FtlDirectiveType directiveType) {
        super(directiveType.getDirectiveName());
        this.myDirectiveType = directiveType;
    }

    private FtlDirectiveType getDirectiveType() {
        return this.myDirectiveType;
    }

    @NonNls
    private String getDirectiveName() {
        return this.myDirectiveType.getDirectiveName();
    }

    protected void parseBody(PrattBuilder builder, String directiveName) {
        FtlDirectiveTokenType.closeDirective(builder, true);
    }

    public static TokenSet getAllDirectiveTokens() {
        Collection<FtlDirectiveTokenType> collection = ourDirectiveNames.values();
        return TokenSet.create((IElementType[])((IElementType[])collection.toArray(new FtlDirectiveTokenType[collection.size()])));
    }

    public static Set<String> getAllDirectiveNames() {
        return new THashSet(ourDirectiveNames.keySet());
    }

    public static Set<String> getLowerCaseDirectiveNames() {
        return Collections.unmodifiableSet(ourLowerCaseDirectiveNames);
    }

    public static FtlDirectiveTokenType getDirectiveToken(@NonNls String name) {
        return ourDirectiveNames.get(name);
    }

    public boolean parseDirective(PrattBuilder builder, MutableMarker marker) {
        String directiveName = builder.getTokenText();
        builder.advance();
        this.parseBody(builder, directiveName);
        marker.finish((IElementType)this.getDirectiveType());
        return true;
    }

    private static boolean closeDirective(PrattBuilder builder, boolean allowEmpty) {
        if (!allowEmpty && builder.assertToken((PrattTokenType)FtlElementTypes.DIRECTIVE_END)) {
            return true;
        }
        if (!PrattParsingUtil.searchFor((PrattBuilder)builder, (boolean)false, (PrattTokenType[])DIRECTIVE_CLOSING_TOKENS)) {
            return false;
        }
        if (FtlDirectiveTokenType.isNextConstructStart(builder)) {
            builder.advance();
        } else {
            builder.assertToken((PrattTokenType)FtlElementTypes.DIRECTIVE_END);
        }
        return true;
    }

    public static boolean isNextConstructStart(PrattBuilder builder) {
        return builder.isToken((IElementType)FtlElementTypes.EMPTY_DIRECTIVE_END) || builder.isToken((IElementType)FtlElementTypes.DIRECTIVE_END);
    }

    protected final void parseDirectiveEnd(PrattBuilder builder, String directiveName) {
        if (!FtlDirectiveTokenType.closeDirective(builder, false)) {
            return;
        }
        if (!builder.isToken((IElementType)FtlElementTypes.END_DIRECTIVE_START)) {
            builder.createChildBuilder(0).parse();
        }
        if (builder.isToken((IElementType)FtlElementTypes.END_DIRECTIVE_START)) {
            MutableMarker marker = builder.mark();
            builder.advance();
            IElementType tokenType = builder.getTokenType();
            marker.rollback();
            if (tokenType instanceof FtlDirectiveTokenType && tokenType != this) {
                for (PrattBuilder parent = builder; parent != null; parent = parent.getParent()) {
                    FtlDirectiveTokenType prevDirective = FtlDirectiveTokenType.getPreviousDirective(parent);
                    if (prevDirective != tokenType) continue;
                    builder.error(FreeMarkerBundle.message("closing.directive.expected.0", directiveName));
                    return;
                }
            }
        }
        if (builder.assertToken((IElementType)FtlElementTypes.END_DIRECTIVE_START, FreeMarkerBundle.message("closing.directive.expected.0", directiveName)) && this.assertClosingDirective(builder) && PrattParsingUtil.searchFor((PrattBuilder)builder, (boolean)false, (PrattTokenType[])DIRECTIVE_CLOSING_TOKENS)) {
            builder.assertToken((PrattTokenType)FtlElementTypes.DIRECTIVE_END);
        }
    }

    protected boolean assertClosingDirective(PrattBuilder builder) {
        return builder.assertToken((PrattTokenType)this);
    }

    @Nullable
    private static FtlDirectiveTokenType getPreviousDirective(PrattBuilder builder) {
        PrattBuilder parent = builder.getParent();
        if (parent != null) {
            IElementType prev = null;
            ListIterator iterator = parent.getBackResultIterator();
            while (iterator.hasPrevious()) {
                IElementType type = (IElementType)iterator.previous();
                if (type == FtlElementTypes.START_DIRECTIVE_START && prev instanceof FtlDirectiveTokenType) {
                    return (FtlDirectiveTokenType)prev;
                }
                prev = type;
            }
        }
        return null;
    }

    static {
        FtlDirectiveTokenType ifDirective = new FtlDirectiveTokenType(new FtlDirectiveType("if", true){

            @Override
            public FtlDirective createPsiElement(ASTNode node) {
                return new FtlIfDirective(node);
            }
        }){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                FtlParser.parseExpression(builder);
                this.parseDirectiveEnd(builder, directiveName);
            }
        };
        FtlDirectiveTokenType.addDirective(ifDirective);
        FtlDirectiveTokenType.addDirective(new FtlChildDirectiveTokenType("else", 0));
        FtlDirectiveTokenType.addDirective(new FtlChildDirectiveTokenType("elseIf", 0){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                FtlParser.parseExpression(builder);
                super.parseBody(builder, directiveName);
            }
        });
        FtlDirectiveTokenType switchToken = new FtlDirectiveTokenType(new FtlDirectiveType("switch", true){

            @Override
            public FtlDirective createPsiElement(ASTNode node) {
                return new FtlSwitchDirective(node);
            }
        }){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                FtlParser.parseExpression(builder);
                this.parseDirectiveEnd(builder, directiveName);
            }
        };
        FtlDirectiveTokenType.addDirective(switchToken);
        FtlDirectiveTokenType.addDirective(new FtlChildDirectiveTokenType("case", 1){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                FtlParser.parseExpression(builder);
                super.parseBody(builder, directiveName);
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlChildDirectiveTokenType("default", 1));
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("break", false));
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("call", false){

            @Override
            protected void parseBody(PrattBuilder builder, String directiveName) {
                MutableMarker nameMarker = builder.mark();
                if (builder.assertToken((PrattTokenType)FtlElementTypes.IDENTIFIER)) {
                    nameMarker.finish((IElementType)FtlElementTypes.REFERENCE_EXPRESSION);
                } else {
                    nameMarker.drop();
                }
                MutableMarker argListMarker = builder.mark();
                if (builder.checkToken((IElementType)FtlElementTypes.LEFT_PAREN)) {
                    FtlParser.parseArgumentList(builder);
                }
                argListMarker.finish((IElementType)FtlElementTypes.ARGUMENT_LIST);
                super.parseBody(builder, directiveName);
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType(new FtlDirectiveType("list", true){

            @Override
            public FtlDirective createPsiElement(ASTNode node) {
                return new FtlListDirective(node);
            }
        }){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                FtlParser.parseExpression(builder);
                if (builder.checkToken((IElementType)FtlElementTypes.AS)) {
                    builder.assertToken((PrattTokenType)FtlElementTypes.IDENTIFIER);
                }
                this.parseDirectiveEnd(builder, directiveName);
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType(new FtlDirectiveType("items", true){

            @Override
            public FtlDirective createPsiElement(ASTNode node) {
                return new FtlListDirective(node);
            }
        }){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                if (builder.assertToken((PrattTokenType)FtlElementTypes.AS)) {
                    builder.assertToken((PrattTokenType)FtlElementTypes.IDENTIFIER);
                }
                this.parseDirectiveEnd(builder, directiveName);
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType(new FtlDirectiveType("foreach", true){

            @Override
            public FtlDirective createPsiElement(ASTNode node) {
                return new FtlListDirective(node);
            }
        }){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                if (builder.assertToken((PrattTokenType)FtlElementTypes.IDENTIFIER) && builder.assertToken((PrattTokenType)FtlElementTypes.IN)) {
                    FtlParser.parseExpression(builder);
                }
                this.parseDirectiveEnd(builder, directiveName);
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("sep", false){

            @Override
            protected void parseBody(PrattBuilder builder, String directiveName) {
                if (!builder.assertToken((PrattTokenType)FtlElementTypes.DIRECTIVE_END)) {
                    return;
                }
                MutableMarker marker = builder.mark();
                if (!builder.isToken((IElementType)FtlElementTypes.END_DIRECTIVE_START)) {
                    builder.createChildBuilder(0).parse();
                }
                if (builder.checkToken((IElementType)FtlElementTypes.END_DIRECTIVE_START) && builder.checkToken((IElementType)this)) {
                    builder.assertToken((PrattTokenType)FtlElementTypes.DIRECTIVE_END);
                    marker.drop();
                    return;
                }
                marker.rollback();
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType(new FtlDirectiveType("include", false){

            @Override
            public FtlDirective createPsiElement(ASTNode node) {
                return new FtlIncludeDirective(node);
            }
        }){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                FtlParser.parseExpression(builder);
                FtlDirectiveTokenType.parseAttributeList(builder, 16.INCLUDE_ATTRIBUTE_NAMES, FreeMarkerBundle.message("attribute.name.expected", new Object[0]));
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType(new FtlDirectiveType("import", false){

            @Override
            public FtlDirective createPsiElement(ASTNode node) {
                return new FtlImportDirective(node);
            }
        }){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                FtlParser.parseExpression(builder);
                if (builder.assertToken((PrattTokenType)FtlElementTypes.AS)) {
                    builder.assertToken((PrattTokenType)FtlElementTypes.IDENTIFIER);
                }
                FtlDirectiveTokenType.closeDirective(builder, true);
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("compress", true){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                this.parseDirectiveEnd(builder, directiveName);
            }
        });
        FtlDirectiveTokenType escapeToken = new FtlDirectiveTokenType(new FtlDirectiveType("escape", true){

            @Override
            public FtlDirective createPsiElement(ASTNode node) {
                return new FtlEscapeDirective(node);
            }
        }){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                if (builder.assertToken((PrattTokenType)FtlElementTypes.IDENTIFIER) && builder.assertToken((PrattTokenType)FtlElementTypes.AS)) {
                    FtlParser.parseExpression(builder);
                }
                this.parseDirectiveEnd(builder, directiveName);
            }
        };
        FtlDirectiveTokenType.addDirective(escapeToken);
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("noEscape", true){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                this.parseDirectiveEnd(builder, directiveName);
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("noParse", true){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                this.parseDirectiveEnd(builder, directiveName);
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlAssignDirectiveTokenType("assign", true));
        FtlDirectiveTokenType.addDirective(new FtlAssignDirectiveTokenType("global", false));
        FtlDirectiveTokenType.addDirective(new FtlAssignDirectiveTokenType("local", false));
        FtlDirectiveTokenType.addDirective(new SettingDirectiveTokenType());
        final SignatureTokenType macro = new SignatureTokenType("macro");
        FtlDirectiveTokenType.addDirective(macro);
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType(new FtlDirectiveType("nested", false){

            @Override
            public FtlDirective createPsiElement(ASTNode node) {
                return new FtlNestedDirective(node);
            }
        }){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                boolean comma = false;
                while (!(builder.isToken((IElementType)FtlElementTypes.DIRECTIVE_END) || builder.isToken((IElementType)FtlElementTypes.EMPTY_DIRECTIVE_END) || builder.isEof() || FtlParser.parseExpression(builder) == null)) {
                    comma = builder.checkToken((IElementType)FtlElementTypes.COMMA);
                }
                if (comma) {
                    builder.error(FreeMarkerBundle.message("expression.expected", new Object[0]));
                }
                FtlDirectiveTokenType.closeDirective(builder, true);
            }
        });
        final SignatureTokenType function = new SignatureTokenType("function");
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("return", false){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                for (PrattBuilder parent = builder; parent != null; parent = parent.getParent()) {
                    FtlDirectiveTokenType prevDirective = FtlDirectiveTokenType.getPreviousDirective(parent);
                    if (prevDirective == function) {
                        FtlParser.parseExpression(builder);
                        super.parseBody(builder, directiveName);
                        return;
                    }
                    if (prevDirective != macro) continue;
                    super.parseBody(builder, directiveName);
                    return;
                }
                super.parseBody(builder, directiveName);
            }
        });
        FtlDirectiveTokenType.addDirective(function);
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("flush", false));
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("stop", false){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                if (!builder.isToken((IElementType)FtlElementTypes.DIRECTIVE_END) && !builder.isToken((IElementType)FtlElementTypes.EMPTY_DIRECTIVE_END)) {
                    FtlParser.parseExpression(builder);
                }
                super.parseBody(builder, directiveName);
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("ftl", false){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                FtlDirectiveTokenType.parseAttributeList(builder, 28.FTL_ATTRIBUTE_NAMES, FreeMarkerBundle.message("attribute.name.expected", new Object[0]));
            }
        });
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("t", false));
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("lt", false));
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("rt", false));
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("nt", false));
        final FtlChildDirectiveTokenType recover = new FtlChildDirectiveTokenType(new FtlDirectiveType("recover", false){

            @Override
            public FtlDirective createPsiElement(ASTNode node) {
                return new FtlRecoverDirective(node);
            }
        }, 2);
        FtlDirectiveTokenType.addDirective(recover);
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("attempt", true){

            @Override
            public void parseBody(PrattBuilder builder, String directiveName) {
                this.parseDirectiveEnd(builder, directiveName);
            }

            @Override
            protected boolean assertClosingDirective(PrattBuilder builder) {
                return builder.checkToken((IElementType)recover) || super.assertClosingDirective(builder);
            }
        });
        FtlDirectiveTokenType.addDirective(new VisitDirectiveTokenType("visit", true));
        FtlDirectiveTokenType.addDirective(new VisitDirectiveTokenType("recurse", false));
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("fallback", false));
        FtlDirectiveTokenType.addDirective(new FtlDirectiveTokenType("transform", true){

            @Override
            protected void parseBody(PrattBuilder builder, String directiveName) {
                try {
                    if (!builder.checkToken((IElementType)FtlElementTypes.IDENTIFIER)) {
                        return;
                    }
                    while (!31.isNextConstructStart(builder)) {
                        if (!builder.checkToken((IElementType)FtlElementTypes.IDENTIFIER)) {
                            break;
                        }
                        if (!builder.checkToken((IElementType)FtlElementTypes.EQ)) continue;
                        FtlParser.parseExpression(builder);
                    }
                }
                finally {
                    this.parseDirectiveEnd(builder, directiveName);
                }
            }
        });
    }

    private static class VisitDirectiveTokenType
    extends FtlDirectiveTokenType {
        private final boolean myVisit;

        public VisitDirectiveTokenType(@NonNls String directiveName, boolean visit) {
            super(new FtlDirectiveType(directiveName, false){

                @Override
                public FtlDirective createPsiElement(ASTNode node) {
                    return new FtlVisitDirective(node);
                }
            });
            this.myVisit = visit;
        }

        @Override
        public void parseBody(PrattBuilder builder, String directiveName) {
            if (!this.myVisit && (builder.checkToken((IElementType)FtlElementTypes.DIRECTIVE_END) || builder.checkToken((IElementType)FtlElementTypes.EMPTY_DIRECTIVE_END))) {
                return;
            }
            if (this.myVisit || !builder.isToken((IElementType)FtlElementTypes.USING)) {
                FtlParser.parseExpression(builder);
            }
            if (builder.checkToken((IElementType)FtlElementTypes.USING)) {
                builder.createChildBuilder(20, FreeMarkerBundle.message("namespace.expected", new Object[0])).parse();
            }
            super.parseBody(builder, directiveName);
        }
    }

    private static class SignatureTokenType
    extends FtlDirectiveTokenType {
        public SignatureTokenType(@NonNls String directiveName) {
            super(new FtlDirectiveType(directiveName, true){

                @Override
                public FtlDirective createPsiElement(ASTNode node) {
                    return new FtlSignatureDirective(node);
                }
            });
        }

        @Override
        public void parseBody(PrattBuilder builder, String directiveName) {
            builder.assertToken((PrattTokenType)FtlElementTypes.IDENTIFIER);
            boolean inParens = builder.checkToken((IElementType)FtlElementTypes.LEFT_PAREN);
            boolean shouldBeDefault = false;
            while (builder.isToken((IElementType)FtlElementTypes.IDENTIFIER) || FtlElementTypes.QUOTES.contains(builder.getTokenType())) {
                MutableMarker pair = builder.mark();
                MutableMarker attrName = builder.mark();
                if (!builder.isToken((IElementType)FtlElementTypes.IDENTIFIER)) {
                    builder.createChildBuilder(90).parse();
                } else {
                    builder.advance();
                }
                attrName.finish((IElementType)FtlElementTypes.ATTRIBUTE_NAME);
                boolean isVararg = false;
                if (builder.checkToken((IElementType)FtlElementTypes.EQ)) {
                    builder.createChildBuilder(30).parse();
                    shouldBeDefault = true;
                } else {
                    isVararg = builder.checkToken((IElementType)FtlElementTypes.DOT_DOT_DOT);
                    if (!isVararg && shouldBeDefault) {
                        builder.error(FreeMarkerBundle.message("default.value.should.occur.at.the.end", new Object[0]));
                    }
                }
                pair.finish((IElementType)FtlElementTypes.PARAMETER_DECLARATION);
                if (isVararg) break;
                builder.checkToken((IElementType)FtlElementTypes.COMMA);
            }
            if (inParens) {
                builder.assertToken((PrattTokenType)FtlElementTypes.RIGHT_PAREN);
            }
            this.parseDirectiveEnd(builder, directiveName);
        }
    }

    private static class FtlChildDirectiveTokenType
    extends FtlDirectiveTokenType {
        private final int myGroupId;

        public FtlChildDirectiveTokenType(@NonNls String name, @NonNls int groupId) {
            super(name, false);
            this.myGroupId = groupId;
        }

        public FtlChildDirectiveTokenType(@NonNls FtlDirectiveType directiveType, int groupId) {
            super(directiveType);
            this.myGroupId = groupId;
        }

        @Override
        public boolean parseDirective(PrattBuilder builder, MutableMarker marker) {
            FtlDirectiveTokenType prev = FtlDirectiveTokenType.getPreviousDirective(builder);
            if (prev instanceof FtlChildDirectiveTokenType && this.myGroupId == ((FtlChildDirectiveTokenType)prev).myGroupId) {
                marker.rollback();
                return false;
            }
            return super.parseDirective(builder, marker);
        }

        @Override
        public void parseBody(PrattBuilder builder, String directiveName) {
            if (FtlDirectiveTokenType.closeDirective(builder, false) && !builder.isToken((IElementType)FtlElementTypes.END_DIRECTIVE_START)) {
                builder.createChildBuilder(0).parse();
            }
        }
    }

    private static class SettingDirectiveTokenType
    extends FtlDirectiveTokenType {
        public SettingDirectiveTokenType() {
            super("setting", false);
        }

        @Override
        public void parseBody(PrattBuilder builder, String directiveName) {
            if (!builder.isToken((IElementType)FtlElementTypes.IDENTIFIER)) {
                builder.error(FreeMarkerBundle.message("setting.name.expected", new Object[0]));
                FtlDirectiveTokenType.closeDirective(builder, true);
                return;
            }
            FtlDirectiveTokenType.parseAttributeList(builder, SettingDirectiveTokenType.VALID_SETTING_NAMES, FreeMarkerBundle.message("setting.name.expected", new Object[0]));
        }
    }

    static class FtlAssignDirectiveTokenType
    extends FtlDirectiveTokenType {
        private final boolean myAllowNamespace;

        private FtlAssignDirectiveTokenType(@NotNull @NonNls String directiveName, boolean allowNamespace) {
            if (directiveName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directiveName", "com/intellij/freemarker/psi/directives/FtlDirectiveTokenType$FtlAssignDirectiveTokenType", "<init>"));
            }
            super(new FtlDirectiveType(directiveName, true){

                @Override
                public FtlDirective createPsiElement(ASTNode node) {
                    return new FtlAssignDirective(node);
                }
            });
            this.myAllowNamespace = allowNamespace;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parseBody(PrattBuilder builder, String directiveName) {
            boolean start = true;
            boolean isCapture = false;
            while (true) {
                MutableMarker param = builder.mark();
                try {
                    IElementType type = builder.createChildBuilder(40, FreeMarkerBundle.message("variable.name.expected", new Object[0])).parse();
                    if (type == null) {
                        this.parseDirectiveEnd(builder, directiveName);
                        return;
                    }
                    if (builder.isToken((IElementType)FtlElementTypes.PLUS_PLUS) || builder.isToken((IElementType)FtlElementTypes.MINUS_MINUS)) {
                        builder.advance();
                    } else if (builder.checkToken((IElementType)FtlElementTypes.OPERATION_ASSIGNMENT) || builder.checkToken((IElementType)FtlElementTypes.EQ)) {
                        FtlParser.parseExpression(builder);
                    } else {
                        if (start) {
                            isCapture = true;
                            break;
                        }
                        builder.error(FtlElementTypes.EQ.getExpectedText(builder));
                    }
                }
                finally {
                    param.finish((IElementType)FtlElementTypes.NAME_VALUE_PAIR);
                }
                if (builder.isEof() || builder.isToken((IElementType)FtlElementTypes.IN) || TokenSet.create((IElementType[])DIRECTIVE_CLOSING_TOKENS).contains(builder.getTokenType())) break;
                builder.checkToken((IElementType)FtlElementTypes.COMMA);
                start = false;
            }
            if (this.myAllowNamespace && builder.isToken((IElementType)FtlElementTypes.IN)) {
                MutableMarker marker = builder.mark();
                builder.advance();
                FtlParser.parseExpression(builder);
                marker.finish((IElementType)FtlElementTypes.ASSIGNMENT_NAMESPACE);
            }
            if (isCapture) {
                this.parseDirectiveEnd(builder, directiveName);
            } else {
                FtlDirectiveTokenType.closeDirective(builder, true);
            }
        }
    }
}

