/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.FtlXmlRootTag;
import com.intellij.freemarker.psi.directives.FtlListDirective;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FtlLoopVariable
extends RenameableFakePsiElement
implements FtlVariable {
    private final FtlListDirective myDirective;
    private final String mySuffix;
    private final PsiType myType;

    protected FtlLoopVariable(FtlListDirective directive, @NonNls String suffix, PsiType type) {
        super((PsiElement)directive);
        this.myDirective = directive;
        this.mySuffix = suffix;
        this.myType = type;
    }

    @NotNull
    public SearchScope getUseScope() {
        LocalSearchScope localSearchScope = new LocalSearchScope((PsiElement)this.myDirective);
        if (localSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "getUseScope"));
        }
        return localSearchScope;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement element = this.myDirective.getNameElement();
        Object object = element == null ? this.myDirective : element;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "getNavigationElement"));
        }
        return object;
    }

    public FtlListDirective getDirective() {
        return this.myDirective;
    }

    public String getSuffix() {
        return this.mySuffix;
    }

    public String getName() {
        PsiElement element = this.myDirective.getNameElement();
        return element == null ? null : element.getText() + this.mySuffix;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/directives/FtlLoopVariable", "setName"));
        }
        if (StringUtil.isNotEmpty((String)this.mySuffix)) {
            return this;
        }
        FtlXmlRootTag tag = FtlPsiUtil.parseFtlFile("<#list a as " + name + ">", this.getProject());
        FtlListDirective directive = (FtlListDirective)tag.getSubDirectives()[0];
        this.myDirective.getNode().replaceChild(this.myDirective.getNameElement().getNode(), directive.getNameElement().getNode());
        return this;
    }

    public PsiElement getParent() {
        return this.myDirective;
    }

    public String getTypeName() {
        return FreeMarkerBundle.message("type.name.variable", new Object[0]);
    }

    public Icon getIcon() {
        return PlatformIcons.VARIABLE_ICON;
    }

    @Override
    public FtlType getType() {
        return FtlPsiType.wrap(this.myType);
    }
}

